/*
 * Copyright (c) 2003-2004 The Ochusha Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: ochusha_thread_2ch.h,v 1.9.2.2 2005/08/01 06:07:39 fuyu Exp $
 */

#ifndef _OCHUSHA_THREAD_2CH_H_
#define _OCHUSHA_THREAD_2CH_H_

#include "ochusha_bbs_thread.h"
#include "ochusha_board_2ch.h"

#include <glib-object.h>
#include <glib.h>

#include <time.h>


#ifdef __cplusplus
extern "C" {
#endif

#define OCHUSHA_TYPE_THREAD_2CH			(ochusha_thread_2ch_get_type())
#define OCHUSHA_THREAD_2CH(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), OCHUSHA_TYPE_THREAD_2CH, OchushaThread2ch))
#define OCHUSHA_THREAD_2CH_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), OCHUSHA_TYPE_THREAD_2CH, OchushaThread2chClass))
#define OCHUSHA_IS_THREAD_2CH(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), OCHUSHA_TYPE_THREAD_2CH))
#define OCHUSHA_IS_THREAD_2CH_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), OCHUSHA_TYPE_THREAD_2CH))
#define OCHUSHA_THREAD_2CH_GET_CLASS(obj) 	(G_TYPE_INSTANCE_GET_CLASS((obj), OCHUSHA_TYPE_THREAD_2CH, OchushaThread2chClass))


typedef struct _OchushaThread2ch OchushaThread2ch;
typedef struct _OchushaThread2chClass OchushaThread2chClass;


struct _OchushaThread2ch
{
  OchushaBBSThread parent_object;

		   /* ʲidboard */
  char *dat_url;   /* "http://pc.2ch.net/linux/dat/1022744633.dat" */
  char *base_url;  /* "http://pc.2ch.net/test/read.cgi/linux/1022744633/" */
  char *base_path; /* "/test/read.cgi/linux/1022744633/" */
  char *post_url;  /* "http://pc.2ch.net/test/read.cgi/linux/1022744633/l10" */

  char *kako_html;	/* HTMLѲåɤξΤߤURLݻ */
  char *oyster_url;	/* ɤURL */

  /* responses[n]: (0ϤޤΤ)n+1ܤΥ쥹DAToffset */
  unsigned int *responses;
  unsigned int responses_length;

  char *last_modified;	/* DATեɤ߹߻Last-Modifiedإå */
  time_t date;		/* 񤭹߻˻Ȥ */

  /* ιŪ˻Ȥ */
  gboolean alive;
};


struct _OchushaThread2chClass
{
  OchushaBBSThreadClass parent_class;

  char *(*get_base_path)(OchushaThread2ch *thread);
  char *(*make_post_response_message)(OchushaThread2ch *thread,
				      const char *from, const char *mail,
				      const char *message, const char *bbs,
				      const char *key, time_t time);
};


GType ochusha_thread_2ch_get_type(void) G_GNUC_CONST;
OchushaBBSThread *ochusha_thread_2ch_new(OchushaBoard2ch *board,
					 const char *dat_filename,
					 const gchar *title);

const char *ochusha_thread_2ch_get_dat_filename(OchushaThread2ch *thread);
const char *ochusha_thread_2ch_get_dat_url(OchushaThread2ch *thread);
const char *ochusha_thread_2ch_get_base_path(OchushaThread2ch *thread);

void ochusha_thread_2ch_set_kako_html_url(OchushaThread2ch *thread,
					  const gchar *url);


#ifdef __cplusplus
} // extern "C"
#endif

#endif	/* _OCHUSHA_THREAD_2CH_H_ */
