// Install script for Xprint XPI

var err;

var regname="xprint";
var version="20040214";
  
err = initInstall("XprintXPI v0.0.2", // name for install UI
                  regname,            // registered name
                  version);           // package version

logComment("initInstall: " + err);

logComment("# Main start.");
doXpXPIInstall();
logComment("# Main done.");

function doXpXPIInstall()
{
  var srDest = 16384; // Disk space required for installation (KB)

  var fProgram           = getFolder("Program");
  var fComponents        = getFolder("Components");
  var userProfileBaseDir = getUserProfileBaseDir();

  logComment("# fProgram:           '" + fProgram           + "'.");
  logComment("# fComponents:        '" + fComponents        + "'.");
  logComment("# userProfileBaseDir: '" + userProfileBaseDir + "'.");

  /* Test whether Xprint's client side module was compiled-in (this is the
   * default for Mozilla builds, but Red Hat has turned it off... ;-( ) */
  var libgfxxprintPath = getFolder(fComponents, "libgfxxprint.so");
  logComment("# Checking whether '" + libgfxxprintPath + "' exists.");
  if (!File.exists(libgfxxprintPath)) {
    logComment("# libgfxxprint.so missing");
    alert("It seems that your version of Mozilla was build with --disable-xprint\n" +
          "which means the Xprint client support was EXPLICITLY TURNED OFF at build time.\n" + 
          "Please contact the creator of the Mozilla package to provide a build where this flag was not set.");
    cancelInstall(ACCESS_DENIED);
    return;
  }

  /* Test whether we're running mozilla or something else */
  logComment("# Checking application type exists.");
  var is_mozilla     = File.exists(getFolder(fProgram, "mozilla-bin"));
  var is_firefox     = File.exists(getFolder(fProgram, "firefox-bin")) || File.exists(getFolder(fProgram, "firebird-bin"));
  var is_thunderbird = File.exists(getFolder(fProgram, "thunderbird-bin"));
  if ( (!is_mozilla) && (!is_firefox) && (!is_thunderbird)) {
    logComment("# unknown application type");
    alert("This XPI currently only supports Mozilla, FirdBird and ThunderBird.\n" +
          "Please contact file a bug at http://xprint.mozdev.org if you see this error.");
    cancelInstall(ACCESS_DENIED);
    return;
  }

  /* Test whether this mozilla supports pluggable shell scripts */
  var init_d_readme_path = getFolder(fProgram, "init.d/README");
  logComment("# Checking whether '" + init_d_readme_path + "' exists.");
  if (!File.exists(init_d_readme_path)) {
    logComment("# init_d_readme_path missing");
    if (is_firefox) {
      alert("Your version of FireFox does not support pluggable shell scripts.\n" + 
            "You need at least FireFox 0.9 (or later).");
    }
    else if (is_thunderbird) {
      alert("Your version of ThunderBird does not support pluggable shell scripts.\n" + 
            "You need at least ThunderBird 0.6 (or later).");
    }
    else
    {
      alert("Your version of Mozilla does not support pluggable shell scripts.\n" + 
            "You need at least Mozilla 1.7a (or later).");
    }
    cancelInstall(ACCESS_DENIED);
    return;
  }
    
  /* Verify available disk space */
  if (!verifyDiskSpace(fProgram, srDest)) {
    logComment("# verifyDiskSpace failure.");
    cancelInstall(INSUFFICIENT_DISK_SPACE);
    return;
  }
  
  /* Add the files which should be installed */
  logComment("# addDirectory sequence begin.");       
  addDirectory(regname, version, "xprint_xpi", userProfileBaseDir, "xprint_xpi", true);
  addDirectory(regname, version, "init.d",     userProfileBaseDir, "init.d",     true);
  logComment("# addDirectory sequence end.");       

  err = getLastError();

  if (err == ACCESS_DENIED) {
    logComment("# ACCESS_DENIED");
    alert("Unable to write to directory " + userProfileBaseDir + ".\n" +
          "You will need to restart the browser with administrator/root " + 
          "privileges to install this software." +
          "After installing as root (or administrator), " + 
          "you will need to restart the browser one more time to " + 
          "register the installed software.\n After the second restart, " +
          "you can go back to running the browser without privileges!");

    logComment("# cancelInstall(), ACCESS_DENIED");
    cancelInstall(ACCESS_DENIED);
    return;
  }
  else if (err != SUCCESS) {
    logComment("# cancelInstall(), err=" + err);
    cancelInstall(err);
    return;
  }

  logComment("# performInstall()");
  performInstall();
}

// this function verifies disk space in kilobytes
function verifyDiskSpace(dirPath, spaceRequired) {
  var spaceAvailable;

  // Get the available disk space on the given path
  spaceAvailable = fileGetDiskSpaceAvailable(dirPath);

  // Convert the available disk space into kilobytes
  spaceAvailable = parseInt(spaceAvailable / 1024);

  // do the verification
  if(spaceAvailable < spaceRequired) {
    logComment("Insufficient disk space: " + dirPath);
    logComment("  required : " + spaceRequired  + " K");
    logComment("  available: " + spaceAvailable + " K");
    return false;
  }

  return true;
}

function getUserProfileBaseDir()
{
    var userPofileBaseDir;
    
    logComment("# getUserProfileBaseDir");
    
    userPofileBaseDir = getFolder("Profile", "../..");

    logComment("# getUserProfileBaseDir='" + userPofileBaseDir + "'");

    return userPofileBaseDir;
}

/* EOF. */
