#ifndef _H_EUREKA_WINDOW
#define _H_EUREKA_WINDOW

#include <KXmlGuiWindow>
#include <ktabwidget.h>
#include <kurl.h>
#include <kparts/browserextension.h>
#include <QProgressBar>
#include <kprocess.h>
#include <KActionMenu>
#include <KLineEdit>
#include <kaction.h>
#include "page.h"
#include "urlaction.h"
#include <config.h>

class EurekaWindow : public KXmlGuiWindow
{
    Q_OBJECT

public:
    EurekaWindow( QWidget *parent = 0 );

public slots:
    void open( const KUrl& url, const KParts::OpenUrlArguments& arguments = KParts::OpenUrlArguments(), const KParts::BrowserArguments& browserArguments = KParts::BrowserArguments() );
    inline void newWindow( const KUrl& url ) { KProcess::execute(  "xdg-open", QStringList() << url.url() ); }
    void closeTab( QWidget* page );
    void configure();
    inline void closeTab() { closeTab(  pages->currentWidget() ); }
    inline void setCurrentTabText( const QString & label ) { pages->setTabText(  pages->currentIndex(), label ); }
    bool queryClose();
    #ifdef NEPOMUK_FOUND
    void setupTagsMenu();
    void tagPage();
    #endif
    inline void back() { pages->currentWidget()->findChild<Page*>()->back(); }
    inline void forward() { pages->currentWidget()->findChild<Page*>()->forward(); }
    inline void reload() { pages->currentWidget()->findChild<Page*>()->reload(); }
    inline void stop() { pages->currentWidget()->findChild<Page*>()->stop(); }
    inline void goTo( KUrl url, KParts::OpenUrlArguments arguments, KParts::BrowserArguments browserArguments ) { pages->currentWidget()->findChild<Page*>()->goTo( url, arguments, browserArguments ); }

private:
    KTabWidget *pages;
    KLineEdit* addressBar;
    QProgressBar* progressBar;
    KAction* stopAction;
    KAction* reloadAction;
    UrlAction* m_newTabAct;
    UrlAction* addressBarAction;
    KActionMenu* tagsMenu;

private slots:
    void setupActions();
    void currentTabChanged( int index );

};

#endif

