/////////////////////////////////////////////////////////////////////////////
// Name:        MenuObjectPropDlg.h
// Purpose:     DVD menu button properties dialog
// Author:      Alex Thuering
// Created:	20.11.2003
// RCS-ID:      $Id: MenuObjectPropDlg.h,v 1.3 2006/12/06 14:53:37 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////
 
#ifndef BUTTON_PROP_DLG_H
#define BUTTON_PROP_DLG_H

#include <wx/wx.h>
#include <wxVillaLib/PropDlg.h>
#include "DVD.h"

enum ButtonDirCommand
{
  bdNONE, bdLEFT, bdRIGHT, bdUP, bdDOWN
};

class MenuObjectPropDlg: public wxPropDlg
{
  public:
    MenuObjectPropDlg(wxWindow *parent, wxString id,
      Menu *menu, DVD* dvd, int tsi, int pgci);
    virtual ~MenuObjectPropDlg() {}

  protected:
    wxString m_id;
    MenuObject* m_object;
    Menu* m_menu;
    DVD* m_dvd;
    int m_tsi;
    int m_pgci;
    int m_btInd;
    void CreatePropPanel(wxSizer* sizer);
    
    wxChoice* m_titlesetChoice;
    wxChoice* m_targetChoice;
    wxChoice* m_chapterChoice;
    int GetTsi(); // returns selected titleset id
    int GetPgci(); // returns selected pgc (target) id
    int GetChapter(); // returns selected chapter nummer
    void UpdateTitlesets();
    void UpdateTargets();
    void UpdateChapters();
    void OnChangeTitleset(wxCommandEvent& WXUNUSED(evt)) { UpdateTargets(); UpdateChapters(); }
    void OnChangeTarget(wxCommandEvent& WXUNUSED(evt)) { UpdateChapters(); }
    
    wxTextCtrl* m_customActionEdit;
    void OnJumpActionSelected(wxCommandEvent& WXUNUSED(evt));
    void OnCustomActionSelected(wxCommandEvent& WXUNUSED(evt));
    
    int m_posCtrlNum;
    wxTextCtrl* m_widthEdit;
    wxTextCtrl* m_heightEdit;
    void OnDefaultSizeSelected(wxCommandEvent& WXUNUSED(evt));
    void OnCustomSizeSelected(wxCommandEvent& WXUNUSED(evt));
    
    void AddStaticLine(wxSizer* sizer, wxString caption);
    void AddDirectionProp(wxSizer* sizer, ButtonDirCommand dir);
    bool SetValues();
    
  private:
    DECLARE_EVENT_TABLE()
};

#endif // BUTTON_PROP_DLG_H
