/////////////////////////////////////////////////////////////////////////////
// Name:        SettingsDlg.cpp
// Purpose:     Setting Dlg
// Author:      Alex Thuering
// Created:     27.03.2004
// RCS-ID:      $Id: SettingsDlg.cpp,v 1.22 2006/12/06 14:53:37 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////
 
#include "SettingsDlg.h"
#include "Config.h"
#include "Languages.h"
#include "DVD.h"
#include <wx/notebook.h>

SettingsDlg::SettingsDlg(wxWindow* parent):
 wxPropDlg(parent)
{
  Create(true);
  SetTitle(_("Settings"));
  SetSize(600,-1);
  Center();
}

void SettingsDlg::CreatePropPanel(wxSizer* sizer)
{
  bool def = sizer == NULL;
  
  wxNotebook* notebook = NULL;
  wxBoxSizer* interfaceSizer = NULL;
  wxFlexGridSizer* interfaceGrid = NULL;
  if (sizer)
  {
	notebook = new wxNotebook(this, -1);
#if wxCHECK_VERSION(2,6,0)
	sizer->Add(notebook, 0, wxEXPAND);
#else
    sizer->Add(new wxNotebookSizer(notebook), 0, wxEXPAND);
#endif
	
	wxPanel* interfacePanel = new wxPanel(notebook, -1);
    notebook->AddPage(interfacePanel, _("Interface"));
	propWindow = interfacePanel;
	
	interfaceSizer = new wxBoxSizer(wxVERTICAL);
	interfacePanel->SetAutoLayout(true);
	interfacePanel->SetSizer(interfaceSizer);
	
    interfaceGrid = new wxFlexGridSizer(2, 2, 4, 16);
	interfaceGrid->AddGrowableCol(1);
	interfaceSizer->Add(interfaceGrid, 1, wxEXPAND|wxALL, 10);
  }
  
  wxString lang = GetLangName(s_config.GetLanguage());
  AddComboProp(interfaceGrid, _("Language:"), lang, GetLangNames(), wxCB_READONLY);
  AddTextProp(interfaceGrid, _("Default volume name:"), s_config.GetDefVolumeName(def));
  wxString videoFormat = DVD::GetVideoFormatStrings()[s_config.GetDefVideoFormat()];
  AddComboProp(interfaceGrid, _("Default video format:"), videoFormat, DVD::GetVideoFormatStrings(), wxCB_READONLY);
  wxString audioFormat = DVD::GetAudioFormatStrings()[s_config.GetDefAudioFormat()];
  AddComboProp(interfaceGrid, _("Default audio format:"), audioFormat, DVD::GetAudioFormatStrings(), wxCB_READONLY);
  wxArrayString fbDirs;
  wxString fbDir = s_config.GetFileBrowserDir();
  if (!fbDir.length())
	fbDir = wxGetHomeDir();
  AddDirectoryProp(interfaceGrid, _("Default directory:"), fbDir);
  
  wxBoxSizer* coreSizer = NULL;
  wxFlexGridSizer* coreGrid = NULL;
  wxBoxSizer* debugSizer = NULL;
  if (sizer)
  {
	wxPanel* interfacePanel = new wxPanel(notebook, -1);
    notebook->AddPage(interfacePanel, _("Core"));
	propWindow = interfacePanel;
	
	coreSizer = new wxBoxSizer(wxVERTICAL);
	interfacePanel->SetAutoLayout(true);
	interfacePanel->SetSizer(coreSizer);
	
    coreGrid = new wxFlexGridSizer(2, 2, 4, 16);
	coreGrid->AddGrowableCol(1);
	coreSizer->Add(coreGrid, 1, wxEXPAND|wxTOP|wxLEFT|wxRIGHT, 10);
	
	debugSizer = new wxBoxSizer(wxVERTICAL);
	coreSizer->Add(debugSizer, 0, wxEXPAND|wxBOTTOM|wxLEFT|wxRIGHT, 10);
  }
  
  AddTextProp(coreGrid, _("Jpeg2Mpeg command:"), s_config.GetJpeg2MpegCmd(def));
  AddSpinProp(coreGrid, _("Frame count of menu:"), s_config.GetMenuFrameCount(def), 1, 9999);
  AddSpinProp(coreGrid, _("Menu video bitrate:"), s_config.GetMenuVideoBitrate(def), 1, 9999999);
  AddSpinProp(coreGrid, _("Slideshow video bitrate:"), s_config.GetSlideshowVideoBitrate(def), 1, 9999999);
  AddTextProp(coreGrid, _("Multiplexing command:"), s_config.GetMplexCmd(def));
  AddTextProp(coreGrid, _("Demultiplexing command:"), s_config.GetDemplexCmd(def));
  AddTextProp(coreGrid, _("Spumux command:"), s_config.GetSpumuxCmd(def));
  AddTextProp(coreGrid, _("Dvdauthor command:"), s_config.GetDvdauthorCmd(def));
  AddTextProp(coreGrid, _("Preview command:"), s_config.GetPreviewCmd(def));
  AddTextProp(coreGrid, _("Create ISO command:"), s_config.GetIsoCmd(def));
  AddTextProp(coreGrid, _("Burn command:"), s_config.GetBurnCmd(def));
  AddTextProp(coreGrid, _("Format command:"), s_config.GetFormatCmd(def));
  
  wxSizer* grpSizer = BeginGroup(debugSizer, _("Debug"));
  AddCheckProp(grpSizer, _("Don't remove temp files"), !s_config.GetRemoveTempFiles(def));
}

bool SettingsDlg::SetValues()
{
  int i=0;
  if (GetLangCode(GetInt(i++)) != s_config.GetLanguage())
  {
	s_config.SetLanguage(GetLangCode(GetInt(i-1)));
	wxMessageBox(
	  _("Language change will not take effect\nuntil DVDStyler is restarted"),
	  GetTitle(), wxOK|wxICON_INFORMATION, this);
  }
  s_config.SetDefVolumeName(GetString(i++));
  s_config.SetDefVideoFormat(GetInt(i++));
  s_config.SetDefAudioFormat(GetInt(i++));
  wxString fbDir = GetString(i++);
  if (fbDir == wxGetHomeDir())
	fbDir = wxT("");
  s_config.SetFileBrowserDir(fbDir);
  s_config.SetJpeg2MpegCmd(GetString(i++));
  s_config.SetMenuFrameCount(GetInt(i++));
  s_config.SetMenuVideoBitrate(GetInt(i++));
  s_config.SetSlideshowVideoBitrate(GetInt(i++));
  s_config.SetMplexCmd(GetString(i++));
  s_config.SetDemplexCmd(GetString(i++));
  s_config.SetSpumuxCmd(GetString(i++));
  s_config.SetDvdauthorCmd(GetString(i++));
  s_config.SetPreviewCmd(GetString(i++));
  s_config.SetIsoCmd(GetString(i++));
  s_config.SetBurnCmd(GetString(i++));
  s_config.SetFormatCmd(GetString(i++));
  s_config.SetRemoveTempFiles(!GetBool(i++));
  return true;
}
