/////////////////////////////////////////////////////////////////////////////
// Name:        MenuEditor.h
// Purpose:     The widget to edit a DVD Menu
// Author:      Alex Thuering
// Created:	11.10.2003
// RCS-ID:      $Id: MenuEditor.h,v 1.5 2006/12/06 14:53:37 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////
 
#ifndef MENUEDITOR_H
#define MENUEDITOR_H

#include <wxSVG/svgctrl.h>
#include "DVD.h"

typedef enum TransformType
{ ttOut, ttIn, ttTL, ttTR, ttBL, ttBR };

class MenuEditor: public wxSVGCtrl
{
  public:
    MenuEditor(wxWindow *parent, wxWindowID id = -1);
	
	void  SetMenu(DVD* dvd, Menu* menu, int tsi, int pgci);
	Menu* GetMenu() { return m_menu; }
	DVD*  GetDVD()	{ return m_dvd;	}
	
	bool SetBackground(wxString fname);
	void SetBackgroundColour(wxColour colour);
	bool AddImage(wxString fname, int x = 0, int y = 0);
	bool AddText(wxString text, int x = 0, int y = 0);
    bool AddObject(wxString fname, int x = 0, int y = 0);
	bool AddButton(wxString fname, int x = 0, int y = 0);
	
	wxString GetSelected() { return m_selected; }
    void Select(wxString id) { DoSelect(id, true, true); }
	
	wxString GetPointed() { return m_pointed; }
	void SetPointed(wxString id) { m_pointed = id; }
	
	int  GetGrid() { return m_grid; }
	void SetGrid(int value) { m_grid = value; }
	
	void ShowSafeTV();
	void ShowGrid();
    
    /** Causes a Menu-changed-event to be generated and repaints window */
    void Update(const wxRect* rect = NULL) { SendChangedEvent(); Refresh(true, rect); }
    void Update(const wxSVGRect* rect) { SendChangedEvent(); Refresh(rect); }
    /** Causes a Menu-changed-event to be generated and
      * redraws the contents of the given rectangle */
    void UpdateRect(const wxRect& rect) { Update(&rect); }
    void UpdateRect(const wxSVGRect& rect) { Update(&rect); }

  protected:
	DVD*  m_dvd;
	Menu* m_menu;
	int m_tsi;
	int m_pgci;
    wxMenu* m_pmenu;
	wxMenu* m_objMenu;
	wxMenu* m_viewMenu;
	wxMenu* m_gridMenu;
	wxMenu* m_addMenu;
    wxMenu* m_arrangeMenu;
	wxPoint m_menuPos;
	wxString m_selected;
	wxString m_pointed;
	bool m_safeTV;
	bool m_showGrid;
	bool m_gridOverObejcts;
	int m_grid;
    wxArrayString m_addMenuObjects;
    
    TransformType m_tt;
    int m_oldx, m_oldy;
    TransformType GetTransformType(int x, int y);
    void SetMouseCursor(TransformType tt);
    bool MoveObject(int& x, int& y);
    bool MoveObjectInt(int& x, int& y);
	bool ResizeObject(int x, int y, TransformType transformType = ttBR);
    bool ResizeObjectInt(int x, int y, TransformType transformType = ttBR);
    
	wxString HitTest(int x, int y);
    void DoSelect(wxString id = wxT(""), bool refresh = false, bool sendEvent = false);
	
	void OnMouseLeftButton(wxMouseEvent &event);
    void OnMouseMove(wxMouseEvent &event);
	void OnMouseRightButton(wxMouseEvent &event);
	void OnMouseDClick(wxMouseEvent& WXUNUSED(event));
    
    /** timer to send changed event */
    wxTimer m_eventTimer;
    void StartEventTimer();
	void OnEventTimer(wxTimerEvent& event);
    
	void OnKeyDown(wxKeyEvent& event);
	
	void OnObjectCut(wxCommandEvent& WXUNUSED(event));
	void OnObjectCopy(wxCommandEvent& WXUNUSED(event));
	void OnObjectPaste(wxCommandEvent& WXUNUSED(event));
	void OnUpdateUIObjectPaste(wxUpdateUIEvent& event);
	void OnObjectDelete(wxCommandEvent& WXUNUSED(event));
    void OnObjectToFront(wxCommandEvent& WXUNUSED(event));
    void OnObjectForward(wxCommandEvent& WXUNUSED(event));
    void OnObjectBackward(wxCommandEvent& WXUNUSED(event));
    void OnObjectToBack(wxCommandEvent& WXUNUSED(event));
    void OnUpdateUIObjectForward(wxUpdateUIEvent& event);
    void OnUpdateUIObjectBackward(wxUpdateUIEvent& event);
	void OnProperties(wxCommandEvent& WXUNUSED(event));
	void OnSafeTV(wxCommandEvent& event);
	void OnShowGrid(wxCommandEvent& event);
	void OnShowGridOverObjects(wxCommandEvent& event);
	void OnGridMenu(wxCommandEvent& event);
	void OnAddObject(wxCommandEvent& event);
    
    void SendChangedEvent();
    DECLARE_EVENT_TABLE()
};

BEGIN_DECLARE_EVENT_TYPES()
  DECLARE_EVENT_TYPE(EVT_COMMAND_MENUEDITOR_MENU_CHANGED, 3305)
  DECLARE_EVENT_TYPE(EVT_COMMAND_MENUEDITOR_OBJECT_POINTED, 3306)
END_DECLARE_EVENT_TYPES()

#define EVT_MENUEDITOR_MENU_CHANGED(id, fn)\
 DECLARE_EVENT_TABLE_ENTRY(EVT_COMMAND_MENUEDITOR_MENU_CHANGED, id, wxID_ANY,\
 (wxObjectEventFunction) (wxEventFunction) (wxCommandEventFunction)& fn, NULL),

#define EVT_MENUEDITOR_OBJECT_POINTED(id, fn)\
 DECLARE_EVENT_TABLE_ENTRY(EVT_COMMAND_MENUEDITOR_OBJECT_POINTED, id,\
 wxID_ANY,\
 (wxObjectEventFunction) (wxEventFunction) (wxCommandEventFunction)& fn, NULL),

#endif // MENUEDITOR_H
