/////////////////////////////////////////////////////////////////////////////
// Name:        NewPropjectDlg.cpp
// Purpose:     New project dialog
// Author:      Alex Thuering
// Created:	29.10.2006
// RCS-ID:      $Id: NewProjectDlg.cpp,v 1.4 2006/12/06 16:41:08 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#include "NewProjectDlg.h"
#include "DVD.h"
#include "Config.h"

NewProjectDlg::NewProjectDlg(wxWindow *parent): wxPropDlg(parent)
{
	Create();
	SetTitle(_("Create a new dvd"));
	SetSize(400,-1);
}

void NewProjectDlg::CreatePropPanel(wxSizer* sizer)
{
  wxFlexGridSizer* grid = new wxFlexGridSizer(2, 1, 16);
  grid->AddGrowableCol(1);
  sizer->Add(grid, 0, wxEXPAND|wxALL, 6);
  AddTextProp(grid, _("Volume name:"), s_config.GetDefVolumeName());
  
  // Video and audio format
  wxFlexGridSizer* fSizer = new wxFlexGridSizer(2, 1, 16);
  fSizer->AddGrowableCol(0);
  fSizer->AddGrowableCol(1);
  sizer->Add(fSizer, 0, wxEXPAND|wxALL, 6);
  wxSizer* grp = BeginGroup(fSizer, _("Video Format"));
  grp->Add(4,4);
  wxArrayString formats = DVD::GetVideoFormatStrings();
  AddRadioGroupProp(grp, formats, s_config.GetDefVideoFormat());
  grp->Add(4,4);
  grp = BeginGroup(fSizer, _("Audio Format"));
  grp->Add(4,4);
  formats = DVD::GetAudioFormatStrings();
  AddRadioGroupProp(grp, formats, s_config.GetDefAudioFormat());
  grp->Add(4,4);
}

wxString NewProjectDlg::GetVolumeName()
{
  return GetString(0);
}

VideoFormat NewProjectDlg::GetVideoFormat()
{
  return (VideoFormat) GetInt(1);
}

AudioFormat NewProjectDlg::GetAudioFormat()
{
  return (AudioFormat) GetInt(2);
}
