/* 
 * $Id: x11dialg.h,v 1.6 2003/02/16 12:43:37 isizaka Exp isizaka $
 * 
 * This file is part of "Ngraph for X11".
 * 
 * Copyright (C) 2002, Satoshi ISHIZAKA. isizaka@msa.biglobe.ne.jp
 * 
 * "Ngraph for X11" is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * "Ngraph for X11" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

/**
 *
 * $Log: x11dialg.h,v $
 * Revision 1.6  2003/02/16 12:43:37  isizaka
 * for release 6.13.18
 *
 * Revision 1.5  2002/07/06 08:57:25  isizaka
 * change to GPL.
 *
 * Revision 1.4  2001/07/14 17:44:50  isizaka
 * for 6.03.14
 *
 * Revision 1.3  1999/04/11 06:09:20  isizaka
 * *** empty log message ***
 *
 * Revision 1.2  1999/03/21 12:51:43  isizaka
 * *** empty log message ***
 *
 * Revision 1.1  1999/03/17 13:29:01  isizaka
 * Initial revision
 *
 *
 **/

#define CLINESTYLE 7
#define CNUMSTYLE 11
extern char *fwlinestyle[CLINESTYLE];
extern char *fwnumstyle[CNUMSTYLE];
extern int fwlinestylelistn[CLINESTYLE];
extern char *fwlinestylelist[CLINESTYLE];
#define CBLINEWIDTH 5
extern char *cblinewidth[CBLINEWIDTH];
#define CBTEXTPT 6
extern char *cbtextpt[CBTEXTPT];
#define CBDIRECTION 4
extern char *cbdirection[CBDIRECTION];
#define CBMARKSIZE 5
extern char *cbmarksize[CBMARKSIZE];
extern char dashes[2];

void initdialog();
int CopyClick(Widget parent,struct objlist *obj,int Id,
              char *(*callback)(struct objlist *obj,int id));
int SetObjFieldFromText(Widget w,char *res,struct objlist *Obj,int Id,char *field);
void SetTextFromObjField(Widget w,char *res,struct objlist *Obj,int Id,char *field);
void SetComboListFromObjField(Widget w,char *res,struct objlist *Obj,int Id,char *field);
int SetObjFieldFromToggle(Widget w,char *res,struct objlist *Obj,int Id,char *field);
void SetToggleFromObjField(Widget w,char *res,struct objlist *Obj,int Id,char *field);
int SetObjFieldFromStyle(Widget w,char *res,struct objlist *Obj,int Id,char *field);
void SetStyleFromObjField(Widget w,char *res,struct objlist *Obj,int Id,char *field);
int SetObjFieldFromList(Widget w,char *res,struct objlist *Obj,int Id,char *field);
void SetListFromObjField(Widget w,char *res,struct objlist *Obj,int Id,char *field);
void SetComboList(Widget w,char *res,char **list,int num);
void SetComboList2(Widget w,char *res,char **list,int num);
Widget GetComboBoxList(Widget w,char *res);
Widget GetComboBoxText(Widget w,char *res);
void SetComboBoxVisibleItemCount(Widget w,char *res,int count);

struct MarkDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
  Widget toggle[90];
  int Type;
};
void MarkDialog(struct MarkDialog *data,int type);

struct FileDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
  struct objlist *Obj;
  int Id;
  struct MarkDialog mark;
  int R,G,B,R2,G2,B2;
};

void FileDialog(struct FileDialog *data,
                struct objlist *obj,int id);

struct EvalDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
  struct narray *sel;
  struct objlist *Obj;
  int Num;
};
void EvalDialog(struct EvalDialog *data,
                struct objlist *obj,int num,struct narray *iarray);

struct MathDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
  struct objlist *Obj;
  int Mode;
};
void MathDialog(struct MathDialog *data,
                struct objlist *obj);

struct MathTextDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
  char *Text;
  char *math;
};
void MathTextDialog(struct MathTextDialog *data,char *text);

struct FitDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
  struct objlist *Obj;
  int Id;
  int Lastid;
};
void FitDialog(struct FitDialog *data,
               struct objlist *obj,int id);

struct FitLoadDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
  struct objlist *Obj;
  int Sid;
  int sel;
};
void FitLoadDialog(struct FitLoadDialog *data,
                   struct objlist *obj,int sid);

struct FitSaveDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
  struct objlist *Obj;
  int Sid;
  char *Profile;
};
void FitSaveDialog(struct FitSaveDialog *data,
                   struct objlist *obj,int sid);

struct FileMoveDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
  struct objlist *Obj;
  int Id;
};
void FileMoveDialog(struct FileMoveDialog *data,
                    struct objlist *obj,int id);

struct FileMaskDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
  struct objlist *Obj;
  int Id;
};
void FileMaskDialog(struct FileMaskDialog *data,
                    struct objlist *obj,int id);

struct FileLoadDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
  struct objlist *Obj;
  int Id;
};
void FileLoadDialog(struct FileLoadDialog *data,
                    struct objlist *obj,int id);

struct FileMathDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
  struct objlist *Obj;
  int Id;
};
void FileMathDialog(struct FileMathDialog *data,
                    struct objlist *obj,int id);

struct SectionDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
  int Section;
  int X,Y,LenX,LenY,X0,Y0,LenX0,LenY0;
  int IDX,IDY,IDU,IDR,*IDG;
  struct objlist *Obj,*Obj2;
  int MaxX,MaxY;
};
void SectionDialog(struct SectionDialog *data,
                   int x,int y,int lenx,int leny,
                   struct objlist *obj,int idx,int idy,int idu,int idr,
                   struct objlist *obj2,int *idg,int section);

struct CrossDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
  int X,Y,LenX,LenY,X0,Y0,LenX0,LenY0;
  int IDX,IDY;
  struct objlist *Obj;
  int MaxX,MaxY;
};
void CrossDialog(struct CrossDialog *data,
                 int x,int y,int lenx,int leny,
                 struct objlist *obj,int idx,int idy);

struct AxisDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
  struct objlist *Obj;
  int Id;
  int CanDel;
};
void AxisDialog(struct AxisDialog *data,
                struct objlist *obj,int id,int candel);

struct GridDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
  struct objlist *Obj;
  int Id;
  int R,G,B,R2,G2,B2;
};
void GridDialog(struct GridDialog *data,
                struct objlist *obj,int id);

struct ZoomDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
  int zoom;
};
void ZoomDialog(struct ZoomDialog *data);

struct AxisBaseDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
  struct objlist *Obj;
  int Id;
  int R,G,B;
};
void AxisBaseDialog(struct AxisBaseDialog *data,
                    struct objlist *obj,int id);

struct AxisPosDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
  struct objlist *Obj;
  int Id;
};
void AxisPosDialog(struct AxisPosDialog *data,
                   struct objlist *obj,int id);

struct NumDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
  struct objlist *Obj;
  int Id;
};
void NumDialog(struct NumDialog *data,
                    struct objlist *obj,int id);

struct AxisFontDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
  struct objlist *Obj;
  int Id;
  int R,G,B;
};
void AxisFontDialog(struct AxisFontDialog *data,
                    struct objlist *obj,int id);

struct GaugeDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
  struct objlist *Obj;
  int Id;
  int R,G,B;
};
void GaugeDialog(struct GaugeDialog *data,
                struct objlist *obj,int id);

struct MergeDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
  struct objlist *Obj;
  int Id;
};
void MergeDialog(struct MergeDialog *data,
                 struct objlist *obj,int id);

struct LegendCurveDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
  struct objlist *Obj;
  int Id;
  int R,G,B;
};
void LegendCurveDialog(struct LegendCurveDialog *data,
                      struct objlist *obj,int id);

struct LegendPolyDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
  struct objlist *Obj;
  int Id;
  int R,G,B;
};
void LegendPolyDialog(struct LegendPolyDialog *data,
                       struct objlist *obj,int id);

struct LegendArrowDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
  struct objlist *Obj;
  int Id;
  int R,G,B;
  int wid,ang;
};
void LegendArrowDialog(struct LegendArrowDialog *data,
                       struct objlist *obj,int id);

struct LegendRectDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
  struct objlist *Obj;
  int Id;
  int R,G,B,R2,G2,B2;
};
void LegendRectDialog(struct LegendRectDialog *data,
                       struct objlist *obj,int id);

struct LegendArcDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
  struct objlist *Obj;
  int Id;
  int R,G,B;
};
void LegendArcDialog(struct LegendArcDialog *data,
                       struct objlist *obj,int id);

struct LegendMarkDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
  struct objlist *Obj;
  int Id;
  struct MarkDialog mark;
  int R,G,B,R2,G2,B2;
};
void LegendMarkDialog(struct LegendMarkDialog *data,
                       struct objlist *obj,int id);

struct LegendTextDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
  struct objlist *Obj;
  int Id;
  int R,G,B;
};
void LegendTextDialog(struct LegendTextDialog *data,
                       struct objlist *obj,int id);

struct LegendGaussDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
  int R,G,B;
  struct objlist *Obj;
  int Id;
  int Minx,Miny,Wdx,Wdy;
  int Div,Dir;
  int Mode;
  double Position,Param;
  int alloc;
};
void LegendGaussDialog(struct LegendGaussDialog *data,
                       struct objlist *obj,int id,
                       int minx,int miny,int wdx,int wdy);

struct PageDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
};
void PageDialog(struct PageDialog *data);

struct SwitchDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
  struct narray drawrable;
  struct narray idrawrable;
};
void SwitchDialog(struct SwitchDialog *data);

struct DirectoryDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
};
void DirectoryDialog(struct DirectoryDialog *data);

struct LoadDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
  int expand;
  char *exdir;
  int ignorepath;
  int Id;
};
void LoadDialog(struct LoadDialog *data);

struct PrmDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
  struct objlist *Obj;
  int Id;
};
void PrmDialog(struct PrmDialog *data,
               struct objlist *obj,int id);

struct SaveDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
  int Path;
  int *SaveData,*SaveMerge;
};
void SaveDialog(struct SaveDialog *data,int *sdata,int *smerge);

struct AboutDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
};
void AboutDialog(struct AboutDialog *data);

struct DriverDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
  struct objlist *Obj;
  int Id;
};
void DriverDialog(struct DriverDialog *data,
                 struct objlist *obj,int id);

struct PrintDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
  struct objlist *Obj;
  int Id;
};
void PrintDialog(struct PrintDialog *data,
                 struct objlist *obj,int id);

struct OutputDataDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
  int div;
};
void OutputDataDialog(struct OutputDataDialog *data,int div);

struct ScriptDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
  char *execscript;
  char option[256];
};
void ScriptDialog(struct ScriptDialog *data);

struct DefaultDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
};
void DefaultDialog(struct DefaultDialog *data);

struct SetScriptDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
  struct script *Script;
};
void SetScriptDialog(struct SetScriptDialog *data,
                        struct script *sc);

struct PrefScriptDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
};
void PrefScriptDialog(struct PrefScriptDialog *data);

struct SetDriverDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
  struct extprinter *Driver;
};
void SetDriverDialog(struct SetDriverDialog *data,
                        struct extprinter *prn);

struct PrefDriverDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
};
void PrefDriverDialog(struct PrefDriverDialog *data);

struct MiscDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
};
void MiscDialog(struct MiscDialog *data);

struct ExViewerDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
  struct objlist *Obj;
  int Id;
};
void ExViewerDialog(struct ExViewerDialog *data);

struct ViewerDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
  struct objlist *Obj;
  int Id;
  int Clear;
  int dpis;
};
void ViewerDialog(struct ViewerDialog *data,
                  struct objlist *obj,int id);

struct SelectDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
  struct narray *sel,*isel;
  struct objlist *Obj;
  char *Field;
  char *(*cb)(struct objlist *obj,int id);
};
void SelectDialog(struct SelectDialog *data,
                  struct objlist *obj,
                  char *(*callback)(struct objlist *obj,int id),
                  struct narray *array,struct narray *iarray);

struct CopyDialog {
  Widget parent,widget;
  int ret;
  char *resource;
  void (*SetupWindow)(Widget w,void *data,int makewidget);
  void (*CloseWindow)(Widget w,void *data);
  struct objlist *Obj;
  int Id;
  int sel;
  char *(*cb)(struct objlist *obj,int id);
};
void CopyDialog(struct CopyDialog *data,
                struct objlist *obj,int id,
                char *(*callback)(struct objlist *obj,int id));

extern struct FileDialog DlgFile;
extern struct FileDialog DlgFileDef;
extern struct EvalDialog DlgEval;
extern struct MathDialog DlgMath;
extern struct MathTextDialog DlgMathText;
extern struct FitDialog DlgFit;
extern struct FitLoadDialog DlgFitLoad;
extern struct FitSaveDialog DlgFitSave;
extern struct FileMoveDialog DlgFileMove;
extern struct FileMaskDialog DlgFileMask;
extern struct FileLoadDialog DlgFileLoad;
extern struct FileMathDialog DlgFileMath;
extern struct SectionDialog DlgSection;
extern struct CrossDialog DlgCross;
extern struct AxisDialog DlgAxis;
extern struct GridDialog DlgGrid;
extern struct ZoomDialog DlgZoom;
extern struct AxisBaseDialog DlgAxisBase;
extern struct AxisPosDialog DlgAxisPos;
extern struct NumDialog DlgNum;
extern struct AxisFontDialog DlgAxisFont;
extern struct GaugeDialog DlgGauge;
extern struct MergeDialog DlgMerge;
extern struct LegendCurveDialog DlgLegendCurve;
extern struct LegendPolyDialog DlgLegendPoly;
extern struct LegendArrowDialog DlgLegendArrow;
extern struct LegendRectDialog DlgLegendRect;
extern struct LegendArcDialog DlgLegendArc;
extern struct LegendMarkDialog DlgLegendMark;
extern struct LegendTextDialog DlgLegendText;
extern struct LegendTextDialog DlgLegendTextDef;
extern struct LegendGaussDialog DlgLegendGauss;
extern struct PageDialog DlgPage;
extern struct SwitchDialog DlgSwitch;
extern struct DirectoryDialog DlgDirectory;
extern struct LoadDialog DlgLoad;
extern struct PrmDialog DlgPrm;
extern struct SaveDialog DlgSave;
extern struct AboutDialog DlgAbout;
extern struct DriverDialog DlgDriver;
extern struct PrintDialog DlgPrinter;
extern struct OutputDataDialog DlgOutputData;
extern struct ScriptDialog DlgScript;
extern struct DefaultDialog DlgDefault;
extern struct SetScriptDialog DlgSetScript;
extern struct PrefScriptDialog DlgPrefScript;
extern struct SetDriverDialog DlgSetDriver;
extern struct PrefDriverDialog DlgPrefDriver;
extern struct MiscDialog DlgMisc;
extern struct ExViewerDialog DlgExViewer;
extern struct ViewerDialog DlgViewer;
extern struct SelectDialog DlgSelect;
extern struct CopyDialog DlgCopy;
