'''OpenGL extension APPLE.element_array

Overview (from the spec)
	
	This extension provides facilities to improve DrawElements style vertex
	indices submission performance by allowing index arrays.  Using this
	extension these arrays can be contained inside a vertex array range and
	thus pulled directly by the graphics processor, avoiding the CPU overhead
	of touching the index data.
	
	This extension is most useful when used in conjunction with the
	APPLE_vertex_array_range extension. APPLE_vertex_array_range provides an
	interface for storing vertex array data. In cases where large amounts of
	vertex data are in use, the index data used to construct primitives
	(typically as passed to the GL through DrawElements) can impose a
	significant bandwidth burden. APPLE_element_array allows the application to
	specify independent arrays of elements, which can then be cached using
	APPLE_vertex_array_range.  In effect this creates a more orthogonal
	interface for both vertex indices and data.
	

The official definition of this extension is available here:
	http://oss.sgi.com/projects/ogl-sample/registry/APPLE/element_array.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
GL_ELEMENT_ARRAY_APPLE = constant.Constant( 'GL_ELEMENT_ARRAY_APPLE', 0x8768 )
GL_ELEMENT_ARRAY_TYPE_APPLE = constant.Constant( 'GL_ELEMENT_ARRAY_TYPE_APPLE', 0x8769 )
glget.addGLGetConstant( GL_ELEMENT_ARRAY_TYPE_APPLE, (1,) )
GL_ELEMENT_ARRAY_POINTER_APPLE = constant.Constant( 'GL_ELEMENT_ARRAY_POINTER_APPLE', 0x876A )
glElementPointerAPPLE = platform.createExtensionFunction( 
	'glElementPointerAPPLE', dll=platform.GL,
	resultType=None, 
	argTypes=(constants.GLenum, ctypes.c_void_p,),
	doc = 'glElementPointerAPPLE( GLenum(type), c_void_p(pointer) ) -> None',
	argNames = ('type', 'pointer',),
)

glDrawElementArrayAPPLE = platform.createExtensionFunction( 
	'glDrawElementArrayAPPLE', dll=platform.GL,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLint, constants.GLsizei,),
	doc = 'glDrawElementArrayAPPLE( GLenum(mode), GLint(first), GLsizei(count) ) -> None',
	argNames = ('mode', 'first', 'count',),
)

glDrawRangeElementArrayAPPLE = platform.createExtensionFunction( 
	'glDrawRangeElementArrayAPPLE', dll=platform.GL,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLuint, constants.GLuint, constants.GLint, constants.GLsizei,),
	doc = 'glDrawRangeElementArrayAPPLE( GLenum(mode), GLuint(start), GLuint(end), GLint(first), GLsizei(count) ) -> None',
	argNames = ('mode', 'start', 'end', 'first', 'count',),
)

glMultiDrawElementArrayAPPLE = platform.createExtensionFunction( 
	'glMultiDrawElementArrayAPPLE', dll=platform.GL,
	resultType=None, 
	argTypes=(constants.GLenum, arrays.GLintArray, arrays.GLsizeiArray, constants.GLsizei,),
	doc = 'glMultiDrawElementArrayAPPLE( GLenum(mode), GLintArray(first), GLsizeiArray(count), GLsizei(primcount) ) -> None',
	argNames = ('mode', 'first', 'count', 'primcount',),
)

glMultiDrawRangeElementArrayAPPLE = platform.createExtensionFunction( 
	'glMultiDrawRangeElementArrayAPPLE', dll=platform.GL,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLuint, constants.GLuint, arrays.GLintArray, arrays.GLsizeiArray, constants.GLsizei,),
	doc = 'glMultiDrawRangeElementArrayAPPLE( GLenum(mode), GLuint(start), GLuint(end), GLintArray(first), GLsizeiArray(count), GLsizei(primcount) ) -> None',
	argNames = ('mode', 'start', 'end', 'first', 'count', 'primcount',),
)


def glInitElementArrayAPPLE():
	'''Return boolean indicating whether this extension is available'''
	return extensions.hasGLExtension( 'GL_APPLE_element_array' )
