'''OpenGL extension SGIX.sprite

Overview (from the spec)
	
	    This extension provides support for viewpoint dependent alignment
	    of geometry, in particular geometry that rotates about a point or
	    a specified axis to face the eye point.  The primary use is for
	    quickly rendering roughly cylindrically or spherically symmetric
	    objects, e.g. trees, smoke, clouds, etc. using geometry textured
	    with a partially transparent texture map.
	
	    Rendering sprite geometry requires applying a transformation to
	    primitives before the current model view. This matrix includes a
	    rotation which is computed based on the current model view matrix
	    and a translation which is specified explicitly
	    (SPRITE_TRANSLATION_SGIX). The current model view matrix itself
	    is not modified.
	
	    Primitives are first transformed by a rotation, depending on the
	    sprite mode:
	
		SPRITE_AXIAL_SGIX: The front of the object is rotated about
		an axis so that it faces the eye as much as the axis
		constraint allows.  This is used for roughly rendering cylindrical
		objects such as trees in visual simulation. 
	
		SPRITE_OBJECT_ALIGNED_SGIX: The front of the object is
		rotated about a point to face the eye with the remaining
		rotational degree of freedom specified by aligning the top
		of the object with a specified axis in object coordinates.
		This is used for spherical objects and special effects such
		as smoke which must maintain an alignment in object
		coordinates for realism.
	
		SPRITE_EYE_ALIGNED_SGIX: The front of the object is rotated
		about a point to face the eye with the remaining rotational
		degree of freedom specified by aligning the top of the object
		with a specified axis in eye coordinates. This is used for
		rendering sprites which must maintain an alignment on the
		screen, such as 3D annotations.
	
	    The axis of rotation or alignment, SPRITE_AXIS_SGIX, can be 
	    an arbitrary direction to support geocentric coordinate frames
	    in which "up" is not along X, Y or Z.
	
	    Sprite geometry is modeled in a canonical frame: +Z is the up
	    vector. -Y is the front vector which is rotated to point towards
	    the eye. In the discussion below, the eye vector is the vector to
	    the eye from the origin of the model view frame translated by the
	    sprite position.

The official definition of this extension is available here:
	http://oss.sgi.com/projects/ogl-sample/registry/SGIX/sprite.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
GL_SPRITE_SGIX = constant.Constant( 'GL_SPRITE_SGIX', 0x8148 )
GL_SPRITE_MODE_SGIX = constant.Constant( 'GL_SPRITE_MODE_SGIX', 0x8149 )
GL_SPRITE_AXIS_SGIX = constant.Constant( 'GL_SPRITE_AXIS_SGIX', 0x814A )
GL_SPRITE_TRANSLATION_SGIX = constant.Constant( 'GL_SPRITE_TRANSLATION_SGIX', 0x814B )
GL_SPRITE_AXIAL_SGIX = constant.Constant( 'GL_SPRITE_AXIAL_SGIX', 0x814C )
GL_SPRITE_OBJECT_ALIGNED_SGIX = constant.Constant( 'GL_SPRITE_OBJECT_ALIGNED_SGIX', 0x814D )
GL_SPRITE_EYE_ALIGNED_SGIX = constant.Constant( 'GL_SPRITE_EYE_ALIGNED_SGIX', 0x814E )
glSpriteParameterfSGIX = platform.createExtensionFunction( 
	'glSpriteParameterfSGIX', dll=platform.GL,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLfloat,),
	doc = 'glSpriteParameterfSGIX( GLenum(pname), GLfloat(param) ) -> None',
	argNames = ('pname', 'param',),
)

glSpriteParameterfvSGIX = platform.createExtensionFunction( 
	'glSpriteParameterfvSGIX', dll=platform.GL,
	resultType=None, 
	argTypes=(constants.GLenum, arrays.GLfloatArray,),
	doc = 'glSpriteParameterfvSGIX( GLenum(pname), GLfloatArray(params) ) -> None',
	argNames = ('pname', 'params',),
)

glSpriteParameteriSGIX = platform.createExtensionFunction( 
	'glSpriteParameteriSGIX', dll=platform.GL,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLint,),
	doc = 'glSpriteParameteriSGIX( GLenum(pname), GLint(param) ) -> None',
	argNames = ('pname', 'param',),
)

glSpriteParameterivSGIX = platform.createExtensionFunction( 
	'glSpriteParameterivSGIX', dll=platform.GL,
	resultType=None, 
	argTypes=(constants.GLenum, arrays.GLintArray,),
	doc = 'glSpriteParameterivSGIX( GLenum(pname), GLintArray(params) ) -> None',
	argNames = ('pname', 'params',),
)


def glInitSpriteSGIX():
	'''Return boolean indicating whether this extension is available'''
	return extensions.hasGLExtension( 'GL_SGIX_sprite' )
