#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#define AREA_W 640
#define AREA_H 480

gboolean
on_mainwindow_delete_event             (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  gtk_main_quit();
  return FALSE;
}


float font_w, font_h, char_w, line_h, area_w, area_h;

int char2width_length;
struct {
  char character[3];
  float width;
  float dx;
} char2width[500]; /* FIXME: use malloc.  */


struct {
  char* char1;
  char* char2;
} substchar[] = {
  {"", "@"}, 
  {0, 0}
};

void load_data() {
  FILE *f;
  char s[PATH_MAX];

  char2width_length = 0;

  sprintf(s, "%s/.aadisplayrc", getenv("HOME"));
  f = fopen(s, "r");
  if (!f) {
    printf("No .aadisplayrc");
    gtk_main_quit();
    return;
  }
    
  while(1) {
    fscanf(f, "%s", s);
    if (strcmp(s, "END") == 0)
      break;
    if (strcmp(s, "FONT_W") == 0)
      fscanf(f, "%f", &font_w);
    else if (strcmp(s, "FONT_H") == 0)
      fscanf(f, "%f", &font_h);
    else if (strcmp(s, "CHAR_W") == 0)
      fscanf(f, "%f", &char_w);
    else if (strcmp(s, "LINE_H") == 0)
      fscanf(f, "%f", &line_h);
    else if (strcmp(s, "SP") == 0) {
      strcpy(char2width[char2width_length].character, " ");
      fscanf(f, "%f", &char2width[char2width_length].width);
      fscanf(f, "%f", &char2width[char2width_length].dx);
      char2width_length++;
    }
    else {
      strcpy(char2width[char2width_length].character, s);
      fscanf(f, "%f", &char2width[char2width_length].width);
      fscanf(f, "%f", &char2width[char2width_length].dx);
      char2width_length++;
    }
  }
  fclose(f);
}

float get_dx(char* s) {
  int i;
  for(i=0; strlen(char2width[i].character); i++)
    if (strcmp(char2width[i].character, s) == 0)
      return char2width[i].dx;
  return 0;
}

float get_width(unsigned char* s) {
  int i;
  for(i=0; strlen(char2width[i].character); i++)
    if (strcmp(char2width[i].character, s) == 0)
      return char2width[i].width;
  if (s[0] == 0x8e)
    return font_w/2;
  return (font_w/2)*strlen(s);
}

extern GdkFont *font;
extern char *filename;
gboolean
on_drawingarea_expose_event            (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
  GdkWChar text[2];
  char s[3];
  float x, y;
  FILE *f;
  int c;
  int i;

  load_data();
  gdk_draw_rectangle(widget->window, 
		     widget->style->bg_gc[GTK_WIDGET_STATE(widget)],
		     1, 0, 0, AREA_W, AREA_H);
  if (filename) {
    if ((f = fopen(filename, "r")) == NULL) {
      printf("Can't open %s\n", filename);
      gtk_main_quit();
    }
  } else {
    f = stdin;
  }
  x = 0;
  y = line_h;

  while((c = fgetc(f)) != EOF) {
    s[0] = (char) c;
    if (c & 0x80) {
      if ((c = fgetc(f)) == EOF)
	break;
      else {
	s[1] = (char) c;
	s[2] = 0;
      }
    } else {
      s[1] = 0;
    }
    for(i=0; substchar[i].char1!=0; i++)
      if (strcmp(substchar[i].char1, s) == 0)
	strcpy(s, substchar[i].char2);

    gdk_mbstowcs(text, s, 2);

    if (text[0] == '\n') {
      x = 0;
      y += line_h;
      if (y >= AREA_H)
	break;
    } else {
      gdk_draw_text_wc(widget->window, 
		       font, 
		       widget->style->fg_gc[GTK_WIDGET_STATE(widget)],
		       x + get_dx(s), y, text, 1);
      x += get_width(s);
    }
  }
  fclose(f);
  return FALSE;
}
