/* A Bison parser, made by GNU Bison 2.1.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004, 2005 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.1"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     IDENTIFIER = 258,
     SYMBOL = 259,
     ARRAY_SYMBOL = 260,
     TYPE_FLOAT = 261,
     TYPE_POINT = 262,
     TYPE_STRING = 263,
     TYPE_COLOR = 264,
     TYPE_NORMAL = 265,
     TYPE_VECTOR = 266,
     TYPE_VOID = 267,
     TYPE_MATRIX = 268,
     TYPE_UNIFORM = 269,
     TYPE_VARYING = 270,
     SHADER_TYPE_SURFACE = 271,
     SHADER_TYPE_VOLUME = 272,
     SHADER_TYPE_IMAGER = 273,
     SHADER_TYPE_TRANSFORMATION = 274,
     SHADER_TYPE_DISPLACEMENT = 275,
     SHADER_TYPE_LIGHT = 276,
     SHADER_TYPE_ATMOSPHERE = 277,
     ATTRIBUTE = 278,
     OPTION = 279,
     RENDERERINFO = 280,
     INCIDENT = 281,
     OPPOSITE = 282,
     LIGHTSOURCE = 283,
     EXTERN = 284,
     TEXTUREINFO = 285,
     OUTPUT = 286,
     IF = 287,
     ELSE = 288,
     WHILE = 289,
     FOR = 290,
     CONTINUE = 291,
     BREAK = 292,
     RETURN = 293,
     ILLUMINATE = 294,
     ILLUMINANCE = 295,
     SOLAR = 296,
     TEXTUREMAP = 297,
     ENVIRONMENT = 298,
     BUMP = 299,
     SHADOW = 300,
     OCCLUSION = 301,
     SETXCOMP = 302,
     SETYCOMP = 303,
     SETZCOMP = 304,
     SETCOMP = 305,
     DIV_ASSIGN = 306,
     MUL_ASSIGN = 307,
     SUB_ASSIGN = 308,
     ADD_ASSIGN = 309,
     OR_OP = 310,
     AND_OP = 311,
     NE_OP = 312,
     EQ_OP = 313,
     LE_OP = 314,
     GE_OP = 315,
     NEG = 316,
     FLOAT_CONSTANT = 317,
     STRING_LITERAL = 318
   };
#endif
/* Tokens.  */
#define IDENTIFIER 258
#define SYMBOL 259
#define ARRAY_SYMBOL 260
#define TYPE_FLOAT 261
#define TYPE_POINT 262
#define TYPE_STRING 263
#define TYPE_COLOR 264
#define TYPE_NORMAL 265
#define TYPE_VECTOR 266
#define TYPE_VOID 267
#define TYPE_MATRIX 268
#define TYPE_UNIFORM 269
#define TYPE_VARYING 270
#define SHADER_TYPE_SURFACE 271
#define SHADER_TYPE_VOLUME 272
#define SHADER_TYPE_IMAGER 273
#define SHADER_TYPE_TRANSFORMATION 274
#define SHADER_TYPE_DISPLACEMENT 275
#define SHADER_TYPE_LIGHT 276
#define SHADER_TYPE_ATMOSPHERE 277
#define ATTRIBUTE 278
#define OPTION 279
#define RENDERERINFO 280
#define INCIDENT 281
#define OPPOSITE 282
#define LIGHTSOURCE 283
#define EXTERN 284
#define TEXTUREINFO 285
#define OUTPUT 286
#define IF 287
#define ELSE 288
#define WHILE 289
#define FOR 290
#define CONTINUE 291
#define BREAK 292
#define RETURN 293
#define ILLUMINATE 294
#define ILLUMINANCE 295
#define SOLAR 296
#define TEXTUREMAP 297
#define ENVIRONMENT 298
#define BUMP 299
#define SHADOW 300
#define OCCLUSION 301
#define SETXCOMP 302
#define SETYCOMP 303
#define SETZCOMP 304
#define SETCOMP 305
#define DIV_ASSIGN 306
#define MUL_ASSIGN 307
#define SUB_ASSIGN 308
#define ADD_ASSIGN 309
#define OR_OP 310
#define AND_OP 311
#define NE_OP 312
#define EQ_OP 313
#define LE_OP 314
#define GE_OP 315
#define NEG 316
#define FLOAT_CONSTANT 317
#define STRING_LITERAL 318




/* Copy the first part of user declarations.  */


#ifdef	WIN32
#include <malloc.h>
#pragma warning(disable : 4786)
#include <cstdio>
#include <memory>
namespace std
{ using ::size_t; 
  using ::malloc;
  using ::free;
}
#endif

#include <algorithm>
#include <iostream>
#include <map>
#include <string>
#include <vector>
#include <cassert>

#include	"parsenode.h"
#include	"logging.h"

# define YYMAXDEPTH 100000
# define YYINITDEPTH  2000

using namespace Aqsis;


namespace Aqsis
{

extern CqString ParseStreamName;
extern std::ostream* ParseErrorStream;
extern TqInt ParseLineNumber;
extern TqBool ParseSucceeded;
extern TqInt	iArrayAccess;
CqParseNode*	ParseTreePointer;
std::vector<std::pair<TqBool,CqString> >	ParseNameSpaceStack;
int blockID = 0;
std::vector<TqInt>		FunctionReturnCountStack;
EqShaderType gShaderType;

TqBool	FindVariable(const char* name, SqVarRef& ref);
TqBool	FindFunction(const char* name, std::vector<SqFuncRef>& Ref);
CqString strNameSpace();
void	pushScope(CqString name, TqBool terminal=TqFalse);
CqString	popScope();
void	TypeCheck();
void	Optimise();
void	InitStandardNamespace();
void	ProcessShaderArguments( CqParseNode* pArgs );

}



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)

typedef union YYSTYPE {
	CqParseNode::Pos m_Pos;
	CqParseNode*	m_pParseNode;
	TqInt			m_VarType;
	EqShaderType	m_ShaderType;
	TqFloat			m_FloatConst;
	CqString*	m_Identifier;
	struct{
		SqVarRef		VarRef;
		SqFuncRef		FuncRef;
		TqInt				eType;
	}				m_pSymbol;
	struct{
		TqInt				Type;
		CqString*	Space;
	}				m_TypeAndSpace;
	EqCommType		m_CommType;
} YYSTYPE;
/* Line 196 of yacc.c.  */

# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


extern TqInt yylex();
static void yyerror(const CqString Message);


/* Line 219 of yacc.c.  */


#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T) && (defined (__STDC__) || defined (__cplusplus))
# include <stddef.h> /* INFRINGES ON USER NAME SPACE */
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#ifndef YY_
# if YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if defined (__STDC__) || defined (__cplusplus)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     define YYINCLUDED_STDLIB_H
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2005 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM ((YYSIZE_T) -1)
#  endif
#  ifdef __cplusplus
extern "C" {
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if (! defined (malloc) && ! defined (YYINCLUDED_STDLIB_H) \
	&& (defined (__STDC__) || defined (__cplusplus)))
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if (! defined (free) && ! defined (YYINCLUDED_STDLIB_H) \
	&& (defined (__STDC__) || defined (__cplusplus)))
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifdef __cplusplus
}
#  endif
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (defined (YYSTYPE_IS_TRIVIAL) && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short int yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short int) + sizeof (YYSTYPE))			\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined (__GNUC__) && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short int yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  41
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   2193

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  84
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  49
/* YYNRULES -- Number of rules. */
#define YYNRULES  183
/* YYNRULES -- Number of states. */
#define YYNSTATES  392

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   318

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    72,     2,     2,     2,     2,     2,     2,
      74,    75,    70,    66,    81,    67,    71,    69,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,    57,    80,
      61,    51,    60,    56,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    82,     2,    83,    68,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    78,     2,    79,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    52,    53,    54,    55,
      58,    59,    62,    63,    64,    65,    73,    76,    77
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short int yyprhs[] =
{
       0,     0,     3,     5,     8,    10,    12,    13,    23,    33,
      42,    51,    58,    64,    68,    71,    75,    78,    80,    82,
      84,    86,    88,    90,    92,    96,    99,   102,   106,   109,
     113,   116,   118,   120,   124,   127,   129,   134,   140,   144,
     147,   149,   154,   160,   164,   167,   172,   174,   178,   180,
     182,   184,   186,   188,   190,   192,   194,   196,   198,   201,
     203,   206,   208,   211,   213,   216,   218,   221,   223,   225,
     227,   230,   233,   236,   239,   242,   246,   249,   251,   254,
     256,   257,   258,   264,   267,   269,   273,   277,   283,   289,
     293,   297,   307,   317,   322,   330,   336,   346,   352,   360,
     370,   382,   385,   387,   389,   391,   393,   397,   401,   405,
     409,   413,   417,   420,   422,   428,   431,   433,   435,   437,
     439,   444,   446,   448,   450,   452,   454,   458,   466,   500,
     502,   504,   506,   508,   510,   512,   516,   520,   524,   528,
     531,   535,   539,   543,   547,   551,   558,   565,   572,   579,
     586,   591,   595,   600,   604,   606,   610,   617,   623,   629,
     634,   636,   638,   640,   642,   644,   646,   650,   653,   657,
     659,   661,   663,   665,   667,   669,   671,   673,   675,   677,
     679,   686,   695,   702
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short int yyrhs[] =
{
      85,     0,    -1,    86,    -1,    85,    86,    -1,    88,    -1,
      89,    -1,    -1,    91,     3,    87,    74,    92,    75,    78,
     109,    79,    -1,    91,     4,    87,    74,    92,    75,    78,
     109,    79,    -1,    91,     3,    87,    74,    75,    78,   109,
      79,    -1,    91,     4,    87,    74,    75,    78,   109,    79,
      -1,    90,    92,    75,    78,   109,    79,    -1,    90,    75,
      78,   109,    79,    -1,    95,     3,    74,    -1,     3,    74,
      -1,    95,     4,    74,    -1,     4,    74,    -1,    21,    -1,
      16,    -1,    17,    -1,    20,    -1,    19,    -1,    18,    -1,
      93,    -1,    92,    80,    93,    -1,    92,    80,    -1,    95,
      96,    -1,    31,    95,    96,    -1,    95,    96,    -1,    29,
      95,    96,    -1,   101,   102,    -1,   102,    -1,    97,    -1,
      96,    81,    97,    -1,     3,    98,    -1,     3,    -1,     3,
      82,   130,    83,    -1,     3,    82,   130,    83,    99,    -1,
       3,    82,    83,    -1,     4,    98,    -1,     4,    -1,     4,
      82,   130,    83,    -1,     4,    82,   130,    83,    99,    -1,
       4,    82,    83,    -1,    51,   116,    -1,    51,    78,   100,
      79,    -1,   116,    -1,   100,    81,   116,    -1,    15,    -1,
      14,    -1,     6,    -1,     8,    -1,    12,    -1,   103,    -1,
     104,    -1,   105,    -1,   106,    -1,   107,    -1,     7,   108,
      -1,     7,    -1,     9,   108,    -1,     9,    -1,    11,   108,
      -1,    11,    -1,    10,   108,    -1,    10,    -1,    13,   108,
      -1,    13,    -1,    77,    -1,   110,    -1,   109,   110,    -1,
     121,    80,    -1,   122,    80,    -1,   123,    80,    -1,   132,
      80,    -1,    38,   116,    80,    -1,   114,    80,    -1,   113,
      -1,    94,    80,    -1,    89,    -1,    -1,    -1,    78,   111,
     109,   112,    79,    -1,    78,    79,    -1,    80,    -1,    32,
     120,   110,    -1,    32,   116,   110,    -1,    32,   120,   110,
      33,   110,    -1,    32,   116,   110,    33,   110,    -1,    34,
     120,   110,    -1,    34,   116,   110,    -1,    35,    74,   116,
      80,   120,    80,   116,    75,   110,    -1,    35,    74,   116,
      80,   116,    80,   116,    75,   110,    -1,    41,    74,    75,
     110,    -1,    41,    74,   116,    81,   116,    75,   110,    -1,
      39,    74,   116,    75,   110,    -1,    39,    74,   116,    81,
     116,    81,   116,    75,   110,    -1,    40,    74,   116,    75,
     110,    -1,    40,    74,   116,    81,   116,    75,   110,    -1,
      40,    74,   116,    81,   116,    81,   116,    75,   110,    -1,
      40,    74,   116,    81,   116,    81,   116,    81,   116,    75,
     110,    -1,   115,   130,    -1,   115,    -1,    37,    -1,    36,
      -1,   118,    -1,   116,    71,   116,    -1,   116,    69,   116,
      -1,   116,    70,   116,    -1,   116,    68,   116,    -1,   116,
      66,   116,    -1,   116,    67,   116,    -1,    67,   116,    -1,
     117,    -1,   120,    56,   116,    57,   116,    -1,   102,   116,
      -1,   130,    -1,   125,    -1,     4,    -1,     5,    -1,     5,
      82,   116,    83,    -1,    77,    -1,   122,    -1,   123,    -1,
     132,    -1,   121,    -1,    74,   116,    75,    -1,    74,   116,
      81,   116,    81,   116,    75,    -1,    74,   116,    81,   116,
      81,   116,    81,   116,    81,   116,    81,   116,    81,   116,
      81,   116,    81,   116,    81,   116,    81,   116,    81,   116,
      81,   116,    81,   116,    81,   116,    81,   116,    75,    -1,
      60,    -1,    65,    -1,    61,    -1,    64,    -1,    63,    -1,
      62,    -1,    74,   120,    75,    -1,   116,   119,   116,    -1,
     120,    59,   120,    -1,   120,    58,   120,    -1,    72,   120,
      -1,     4,    51,   116,    -1,     4,    55,   116,    -1,     4,
      54,   116,    -1,     4,    53,   116,    -1,     4,    52,   116,
      -1,     5,    82,   116,    83,    51,   116,    -1,     5,    82,
     116,    83,    55,   116,    -1,     5,    82,   116,    83,    54,
     116,    -1,     5,    82,   116,    83,    53,   116,    -1,     5,
      82,   116,    83,    52,   116,    -1,     4,    74,   124,    75,
      -1,     4,    74,    75,    -1,     3,    74,   124,    75,    -1,
       3,    74,    75,    -1,   116,    -1,   124,    81,   116,    -1,
     126,    74,   127,   128,   129,    75,    -1,   126,    74,   127,
     129,    75,    -1,   126,    74,   127,   128,    75,    -1,   126,
      74,   127,    75,    -1,    42,    -1,    43,    -1,    44,    -1,
      45,    -1,    46,    -1,   116,    -1,    82,   116,    83,    -1,
      81,   116,    -1,   129,    81,   116,    -1,    76,    -1,    22,
      -1,    20,    -1,    28,    -1,    16,    -1,    23,    -1,    24,
      -1,    25,    -1,    26,    -1,    27,    -1,    30,    -1,   131,
      74,   116,    81,     4,    75,    -1,   131,    74,   116,    81,
     116,    81,     4,    75,    -1,   131,    74,   116,    81,     5,
      75,    -1,   131,    74,   116,    81,   116,    81,     5,    75,
      -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short int yyrline[] =
{
       0,   172,   172,   173,   178,   179,   184,   191,   204,   220,
     227,   240,   279,   302,   310,   318,   331,   347,   350,   353,
     356,   359,   362,   368,   381,   392,   396,   478,   565,   651,
     702,   706,   710,   716,   724,   733,   740,   747,   756,   763,
     777,   787,   797,   809,   822,   828,   843,   849,   857,   858,
     862,   866,   870,   874,   875,   876,   877,   878,   882,   886,
     893,   897,   904,   908,   915,   919,   926,   930,   937,   941,
     947,   955,   956,   964,   972,   977,   986,   987,   988,  1014,
    1016,  1023,  1015,  1029,  1030,  1031,  1039,  1054,  1063,  1082,
    1088,  1100,  1115,  1136,  1142,  1156,  1165,  1181,  1194,  1208,
    1225,  1246,  1247,  1251,  1255,  1263,  1264,  1275,  1286,  1297,
    1308,  1319,  1330,  1340,  1341,  1354,  1400,  1404,  1405,  1409,
    1413,  1418,  1422,  1423,  1424,  1425,  1426,  1429,  1437,  1461,
    1462,  1463,  1464,  1465,  1466,  1470,  1473,  1480,  1487,  1494,
    1502,  1508,  1522,  1536,  1550,  1564,  1571,  1589,  1607,  1625,
    1646,  1656,  1667,  1689,  1705,  1711,  1719,  1733,  1747,  1753,
    1762,  1768,  1774,  1780,  1786,  1795,  1802,  1806,  1812,  1821,
    1826,  1827,  1828,  1829,  1830,  1831,  1832,  1833,  1834,  1835,
    1840,  1861,  1886,  1907
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "IDENTIFIER", "SYMBOL", "ARRAY_SYMBOL",
  "TYPE_FLOAT", "TYPE_POINT", "TYPE_STRING", "TYPE_COLOR", "TYPE_NORMAL",
  "TYPE_VECTOR", "TYPE_VOID", "TYPE_MATRIX", "TYPE_UNIFORM",
  "TYPE_VARYING", "SHADER_TYPE_SURFACE", "SHADER_TYPE_VOLUME",
  "SHADER_TYPE_IMAGER", "SHADER_TYPE_TRANSFORMATION",
  "SHADER_TYPE_DISPLACEMENT", "SHADER_TYPE_LIGHT",
  "SHADER_TYPE_ATMOSPHERE", "ATTRIBUTE", "OPTION", "RENDERERINFO",
  "INCIDENT", "OPPOSITE", "LIGHTSOURCE", "EXTERN", "TEXTUREINFO", "OUTPUT",
  "IF", "ELSE", "WHILE", "FOR", "CONTINUE", "BREAK", "RETURN",
  "ILLUMINATE", "ILLUMINANCE", "SOLAR", "TEXTUREMAP", "ENVIRONMENT",
  "BUMP", "SHADOW", "OCCLUSION", "SETXCOMP", "SETYCOMP", "SETZCOMP",
  "SETCOMP", "'='", "DIV_ASSIGN", "MUL_ASSIGN", "SUB_ASSIGN", "ADD_ASSIGN",
  "'?'", "':'", "OR_OP", "AND_OP", "'>'", "'<'", "NE_OP", "EQ_OP", "LE_OP",
  "GE_OP", "'+'", "'-'", "'^'", "'/'", "'*'", "'.'", "'!'", "NEG", "'('",
  "')'", "FLOAT_CONSTANT", "STRING_LITERAL", "'{'", "'}'", "';'", "','",
  "'['", "']'", "$accept", "file", "definitions", "get_filepos",
  "shader_definition", "function_definition", "function_declaration",
  "shader_type", "formals", "formal_variable_definitions",
  "variable_definitions", "typespec", "def_expressions", "def_expression",
  "def_init", "def_array_initialisers", "array_initialisers", "detail",
  "type", "pspace", "cspace", "vspace", "nspace", "mspace", "spacetype",
  "statements", "statement", "@1", "@2", "loop_control", "loop_modstmt",
  "loop_mod", "expression", "cast_expr", "primary", "relational_operator",
  "relation", "assignexpression", "procedurecall", "unresolvedcall",
  "proc_arguments", "texture", "texture_type", "texture_filename",
  "channel", "texture_arguments", "number", "comm_type", "comm_function", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short int yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,    61,   306,   307,   308,   309,    63,    58,   310,   311,
      62,    60,   312,   313,   314,   315,    43,    45,    94,    47,
      42,    46,    33,   316,    40,    41,   317,   318,   123,   125,
      59,    44,    91,    93
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned char yyr1[] =
{
       0,    84,    85,    85,    86,    86,    87,    88,    88,    88,
      88,    89,    89,    90,    90,    90,    90,    91,    91,    91,
      91,    91,    91,    92,    92,    92,    93,    93,    94,    94,
      95,    95,    96,    96,    97,    97,    97,    97,    97,    97,
      97,    97,    97,    97,    98,    99,   100,   100,   101,   101,
     102,   102,   102,   102,   102,   102,   102,   102,   103,   103,
     104,   104,   105,   105,   106,   106,   107,   107,   108,   109,
     109,   110,   110,   110,   110,   110,   110,   110,   110,   110,
     111,   112,   110,   110,   110,   110,   110,   110,   110,   113,
     113,   113,   113,   113,   113,   113,   113,   113,   113,   113,
     113,   114,   114,   115,   115,   116,   116,   116,   116,   116,
     116,   116,   116,   116,   116,   117,   118,   118,   118,   118,
     118,   118,   118,   118,   118,   118,   118,   118,   118,   119,
     119,   119,   119,   119,   119,   120,   120,   120,   120,   120,
     121,   121,   121,   121,   121,   121,   121,   121,   121,   121,
     122,   122,   123,   123,   124,   124,   125,   125,   125,   125,
     126,   126,   126,   126,   126,   127,   128,   129,   129,   130,
     131,   131,   131,   131,   131,   131,   131,   131,   131,   131,
     132,   132,   132,   132
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     2,     1,     1,     0,     9,     9,     8,
       8,     6,     5,     3,     2,     3,     2,     1,     1,     1,
       1,     1,     1,     1,     3,     2,     2,     3,     2,     3,
       2,     1,     1,     3,     2,     1,     4,     5,     3,     2,
       1,     4,     5,     3,     2,     4,     1,     3,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     1,
       2,     1,     2,     1,     2,     1,     2,     1,     1,     1,
       2,     2,     2,     2,     2,     3,     2,     1,     2,     1,
       0,     0,     5,     2,     1,     3,     3,     5,     5,     3,
       3,     9,     9,     4,     7,     5,     9,     5,     7,     9,
      11,     2,     1,     1,     1,     1,     3,     3,     3,     3,
       3,     3,     2,     1,     5,     2,     1,     1,     1,     1,
       4,     1,     1,     1,     1,     1,     3,     7,    33,     1,
       1,     1,     1,     1,     1,     3,     3,     3,     3,     2,
       3,     3,     3,     3,     3,     6,     6,     6,     6,     6,
       4,     3,     4,     3,     1,     3,     6,     5,     5,     4,
       1,     1,     1,     1,     1,     1,     3,     2,     3,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       6,     8,     6,     8
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned char yydefact[] =
{
       0,     0,     0,    50,    59,    51,    61,    65,    63,    52,
      67,    49,    48,    18,    19,    22,    21,    20,    17,     0,
       2,     4,     5,     0,     0,     0,     0,    31,    53,    54,
      55,    56,    57,    14,    16,    68,    58,    60,    64,    62,
      66,     1,     3,     0,     0,     0,    23,     0,     6,     6,
       0,     0,    30,     0,     0,     0,    25,    35,    40,    26,
      32,     0,     0,    13,    15,    27,     0,     0,     0,   173,
     171,   170,   174,   175,   176,   177,   178,   172,     0,   179,
       0,     0,     0,   104,   103,     0,     0,     0,     0,    80,
      84,    79,     0,     0,     0,    69,    77,     0,   102,     0,
       0,     0,     0,     0,     0,    24,     0,     0,    34,     0,
      39,     0,     0,     0,    14,     0,     0,     0,     0,     0,
      16,     0,     0,     0,   118,   119,   160,   161,   162,   163,
     164,     0,     0,     0,   169,   121,     0,     0,   113,   105,
       0,   125,   122,   123,   117,     0,   116,   124,     0,     0,
       0,     0,     0,     0,     0,     0,    83,     0,    78,    35,
      40,    28,    12,    70,    76,   101,    71,    72,    73,     0,
      74,     0,    44,    38,     0,    43,     0,    33,     0,     0,
       0,     0,   153,   154,     0,   140,   144,   143,   142,   141,
     151,     0,     0,    29,     0,     0,     0,   112,     0,   139,
       0,     0,   115,   129,   131,   134,   133,   132,   130,     0,
       0,     0,     0,     0,     0,    86,     0,     0,     0,     0,
      85,     0,    90,    89,     0,    75,     0,     0,     0,     0,
      81,     0,    11,    36,    41,     0,     0,     0,     0,   152,
       0,   150,     0,     0,   126,     0,   135,   110,   111,   109,
     107,   108,   106,     0,   136,     0,   138,   137,     0,   165,
       0,     0,     0,     0,     0,     0,    93,     0,     0,     0,
       0,    37,    42,     0,     0,     0,     0,   155,     0,     0,
       0,     0,     0,   120,     0,    88,     0,    87,   159,     0,
       0,     0,     0,     0,     0,    95,     0,    97,     0,     0,
      82,   118,   119,     0,     0,     9,     0,    10,     0,   145,
     149,   148,   147,   146,     0,   114,   167,     0,   158,     0,
     157,     0,     0,     0,     0,     0,     0,     0,   180,   182,
       0,     0,    46,     7,     8,     0,   166,   156,   168,     0,
       0,     0,    98,     0,    94,     0,     0,    45,     0,   127,
       0,     0,     0,     0,     0,     0,   181,   183,    47,     0,
      92,    91,    96,    99,     0,     0,     0,     0,   100,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   128
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short int yydefgoto[] =
{
      -1,    19,    20,    61,    21,    91,    23,    24,    45,    46,
      92,    93,    59,    60,   108,   271,   331,    26,   136,    28,
      29,    30,    31,    32,    36,    94,    95,   157,   268,    96,
      97,    98,   183,   138,   139,   216,   152,   141,   142,   143,
     184,   144,   145,   260,   291,   292,   146,   102,   147
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -117
static const short int yypact[] =
{
    2084,   -35,     1,  -117,   -60,  -117,   -60,   -60,   -60,  -117,
     -60,  -117,  -117,  -117,  -117,  -117,  -117,  -117,  -117,  1132,
    -117,  -117,  -117,    59,    46,    89,   291,  -117,  -117,  -117,
    -117,  -117,  -117,  -117,  -117,  -117,  -117,  -117,  -117,  -117,
    -117,  -117,  -117,   447,     5,    34,  -117,   135,  -117,  -117,
      11,    31,  -117,   135,  1456,    37,   211,   -48,   -40,    38,
    -117,    43,    58,  -117,  -117,    38,    68,    44,    74,  -117,
    -117,  -117,  -117,  -117,  -117,  -117,  -117,  -117,   447,  -117,
    1720,  1720,    90,  -117,  -117,  1720,   118,   120,   121,    94,
    -117,  -117,   117,   142,  1090,  -117,  -117,   119,   122,   123,
     127,   134,   128,   149,  1456,  -117,  1720,   -24,  -117,   -23,
    -117,   135,   116,   169,  1720,  1720,  1720,  1720,  1720,  1720,
    1720,  1720,   135,   141,   157,   150,  -117,  -117,  -117,  -117,
    -117,  1720,  1720,  1720,  -117,  -117,  1720,   953,  -117,  -117,
    1031,  -117,  -117,  -117,  -117,   159,  -117,  -117,   953,  1031,
    1720,  1967,   129,  1720,  1720,  1495,  -117,  1456,  -117,   -42,
     -41,    38,  -117,  -117,  -117,  -117,  -117,  -117,  -117,  1720,
    -117,  1151,  2122,  -117,   151,  -117,   153,  -117,   160,    36,
     161,    61,  -117,  2122,     6,  2122,  2122,  2122,  2122,  2122,
    -117,     7,   363,    38,  1570,  1645,  1720,  -117,  2122,  -117,
     566,   -38,  -117,  -117,  -117,  -117,  -117,  -117,  -117,  1720,
    1720,  1720,  1720,  1720,  1720,   168,  1720,  1720,  1720,  1720,
     207,  1720,  -117,  -117,  1988,  -117,   701,   723,  1456,  1133,
    1456,  1194,  -117,   190,   190,  1456,   165,  1456,   167,  -117,
    1720,  -117,   100,   460,  -117,  1720,  -117,    99,    99,    -8,
     175,   175,  -117,  1456,  2122,  2110,   188,  -117,  1456,  2122,
     -37,  1720,  1456,  1720,  1456,  1720,  -117,  1720,   171,  1795,
     170,  -117,  -117,  1212,  1456,  1273,  1456,  2122,  1720,  1720,
    1720,  1720,  1720,   100,  1255,  -117,  1720,  -117,  -117,  1720,
    1720,    25,    26,  2009,   -34,  -117,  1316,  -117,   765,   935,
    -117,   -39,     2,  1377,  1720,  -117,  1334,  -117,  1395,  2122,
    2122,  2122,  2122,  2122,  1720,  2122,  2122,   491,  -117,    27,
    -117,  1720,  1720,  1720,  1720,  1456,  1720,  1456,  -117,  -117,
     154,   -51,  2122,  -117,  -117,   805,  -117,  -117,  2122,  1013,
    2046,  2062,  -117,   864,  -117,   176,   179,  -117,  1720,  -117,
    1720,  1456,  1456,  1456,  1456,  1720,  -117,  -117,  2122,  1482,
    -117,  -117,  -117,  -117,  2078,  1720,  1456,  1557,  -117,  1720,
    1632,  1720,  1707,  1720,  1782,  1720,  1813,  1720,  1835,  1720,
    1857,  1720,  1879,  1720,  1901,  1720,  1923,  1720,  1945,  1720,
    2094,  -117
};

/* YYPGOTO[NTERM-NUM].  */
static const short int yypgoto[] =
{
    -117,  -117,   236,   208,  -117,    29,  -117,  -117,    77,   200,
    -117,     8,   -46,   148,   -57,    32,  -117,  -117,     0,  -117,
    -117,  -117,  -117,  -117,   155,  -102,   589,  -117,  -117,  -117,
    -117,  -117,   534,  -117,  -117,  -117,   -75,    56,   112,   242,
    -116,  -117,  -117,  -117,  -117,   -28,   -18,  -117,   348
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1
static const unsigned short int yytable[] =
{
      27,   110,   171,   106,   191,   140,   149,    65,    25,   106,
     106,   106,   115,   116,   117,   118,   119,    35,   217,    27,
     218,   219,   217,    27,   218,   219,    52,    25,   347,    22,
     348,    47,    63,    64,   107,   195,   328,   246,   288,    33,
     107,   109,   109,    27,   289,   290,   323,   161,    22,    48,
      49,    53,   134,   134,    27,   230,    27,   199,   201,   173,
     175,   212,   213,   214,    47,     3,     4,     5,     6,     7,
       8,     9,    10,    11,    12,    34,   193,   329,    27,   191,
     165,   239,   241,    54,   196,    63,   122,   240,   240,   174,
      43,   176,    50,    51,    27,   115,   116,   117,   118,   119,
     318,   320,   337,   110,    27,    64,   289,   321,   321,    55,
      99,   236,    27,    27,    56,   104,    56,   112,   120,   111,
      47,    47,     3,     4,     5,     6,     7,     8,     9,    10,
      11,    12,   113,   273,    44,   275,   238,    27,    57,    58,
      27,    56,   114,   256,   257,   159,   160,    43,    27,    27,
      99,   278,   279,   280,   281,   282,   121,    27,   345,   346,
      99,    37,    38,    39,   150,    40,   100,   211,   212,   213,
     214,    27,   306,   156,   308,     3,     4,     5,     6,     7,
       8,     9,    10,    11,    12,   217,   294,   218,   219,   179,
     181,   178,   153,    99,   154,   155,    99,   158,   134,   164,
      43,   253,   169,   166,    99,    99,   100,   167,   115,   116,
     117,   118,   119,    99,   168,   194,   100,     3,     4,     5,
       6,     7,     8,     9,    10,    11,    12,    99,    27,   170,
      27,   195,   196,   221,   233,    27,   234,    27,   235,   237,
     258,   270,    43,   274,   180,   276,   214,   219,   304,   100,
     300,   356,   100,    27,   357,    42,   105,    62,    27,   177,
     100,   100,    27,   319,    27,     0,   272,     0,     0,   100,
       0,     0,     0,    27,    27,    27,    27,     0,     0,     0,
       0,     0,     0,   100,    99,     0,    99,     0,     0,     0,
       0,    99,     0,    99,     0,     0,   101,     3,     4,     5,
       6,     7,     8,     9,    10,     0,    27,     0,    27,    99,
       0,     0,     0,     0,    99,     0,     0,     0,    99,     0,
      99,     0,     0,     0,     0,    27,     0,    27,     0,    99,
      99,    99,    99,     0,     0,     0,   101,     0,     0,     0,
     100,     0,   100,     0,     0,     0,   101,   100,     0,   100,
       0,    27,    27,    27,    27,     0,     0,     0,     0,     0,
       0,     0,    99,     0,    99,   100,    27,     0,     0,     0,
     100,     0,     0,     0,   100,     0,   100,     0,     0,   101,
       0,    99,   101,    99,     0,   100,   100,   100,   100,     0,
     101,   101,     0,     0,     0,     0,     0,     0,     0,   101,
       0,     0,   103,     0,     0,     0,     0,    99,    99,    99,
      99,     0,     0,   101,     0,     0,     0,     0,   100,     0,
     100,     0,    99,   203,   204,   205,   206,   207,   208,   209,
     210,   211,   212,   213,   214,     0,     0,   100,     0,   100,
       0,     0,   103,     0,     0,     0,   242,     0,     0,     0,
       0,     0,   103,     3,     4,     5,     6,     7,     8,     9,
      10,    11,    12,   100,   100,   100,   100,     0,     0,     0,
     101,     0,   101,     0,     0,     0,     0,   101,   100,   101,
       0,     0,     0,     0,     0,   103,     0,     0,   103,     0,
       0,     0,     0,     0,     0,   101,   103,   103,     0,     0,
     101,     0,     0,     0,   101,   103,   101,     0,     0,     0,
       0,     0,     0,     0,     0,   101,   101,   101,   101,   103,
     203,   204,   205,   206,   207,   208,   209,   210,   211,   212,
     213,   214,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   283,     0,     0,     0,     0,   101,     0,
     101,   203,   204,   205,   206,   207,   208,   209,   210,   211,
     212,   213,   214,     0,     0,     0,     0,   101,     0,   101,
       0,     0,     0,     0,   336,     0,   103,     0,   103,     0,
       0,     0,     0,   103,     0,   103,     0,     0,     0,     0,
       0,     0,     0,   101,   101,   101,   101,     0,     0,     0,
       0,   103,     0,     0,     0,     0,   103,     0,   101,     0,
     103,     0,   103,     0,   137,   148,     0,     0,     0,   151,
       0,   103,   103,   103,   103,     0,   203,   204,   205,   206,
     207,   208,   209,   210,   211,   212,   213,   214,     0,     0,
     172,   244,     0,     0,     0,     0,     0,   245,     0,   185,
     186,   187,   188,   189,   103,   192,   103,     0,     0,     0,
       0,     0,     0,     0,     0,   197,   198,   200,     0,     0,
     202,     0,     0,   103,     0,   103,     0,     0,     0,     0,
       0,     0,     0,   163,   224,     0,     0,   226,   227,   229,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   103,
     103,   103,   103,   231,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   103,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   215,     0,     0,   220,
     243,     0,     0,     0,     0,     0,     0,   222,   223,     0,
       0,     0,     0,   247,   248,   249,   250,   251,   252,     0,
     254,   255,   198,   198,     0,   259,     0,     0,     0,     0,
     163,   203,   204,   205,   206,   207,   208,   209,   210,   211,
     212,   213,   214,     0,   277,     0,   262,     0,     0,   284,
       0,     0,   263,   203,   204,   205,   206,   207,   208,   209,
     210,   211,   212,   213,   214,   293,     0,   296,   264,   298,
       0,   299,     0,   303,   265,     0,     0,     0,     0,     0,
       0,     0,   309,   310,   311,   312,   313,   266,     0,   163,
     315,     0,     0,   316,   317,   203,   204,   205,   206,   207,
     208,   209,   210,   211,   212,   213,   214,     0,   332,     0,
     325,     0,   285,     0,     0,     0,   326,   287,   335,     0,
       0,   295,     0,   297,     0,   338,   339,   340,   341,     0,
     343,     0,   163,     0,   163,   203,   204,   205,   206,   207,
     208,   209,   210,   211,   212,   213,   214,     0,     0,     0,
     349,     0,   358,     0,   359,     0,   350,     0,     0,   364,
       0,     0,     0,     0,     0,   163,     0,   163,     0,   367,
       0,     0,     0,   370,     0,   372,     0,   374,     0,   376,
       0,   378,     0,   380,   342,   382,   344,   384,     0,   386,
       0,   388,     0,   390,   203,   204,   205,   206,   207,   208,
     209,   210,   211,   212,   213,   214,     0,     0,     0,   354,
     360,   361,   362,   363,     0,   355,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   368,    66,    67,    68,     3,
       4,     5,     6,     7,     8,     9,    10,    11,    12,    69,
       0,     0,     0,    70,     0,    71,    72,    73,    74,    75,
      76,    77,    78,    79,     0,    80,     0,    81,    82,    83,
      84,    85,    86,    87,    88,   203,   204,   205,   206,   207,
     208,   209,   210,   211,   212,   213,   214,     0,     0,     0,
     327,     0,     0,   203,   204,   205,   206,   207,   208,   209,
     210,   211,   212,   213,   214,     0,     0,     0,     0,     0,
       0,    89,     0,    90,    66,    67,    68,     3,     4,     5,
       6,     7,     8,     9,    10,    11,    12,    69,     0,     0,
       0,    70,     0,    71,    72,    73,    74,    75,    76,    77,
      78,    79,     0,    80,     0,    81,    82,    83,    84,    85,
      86,    87,    88,   203,   204,   205,   206,   207,   208,   209,
     210,   211,   212,   213,   214,     0,     0,   217,   351,   218,
     219,     0,     0,    66,    67,    68,     3,     4,     5,     6,
       7,     8,     9,    10,    11,    12,    69,     0,     0,    89,
      70,    90,    71,    72,    73,    74,    75,    76,    77,    78,
      79,     0,    80,     0,    81,    82,    83,    84,    85,    86,
      87,    88,    41,     0,     0,     1,     2,     0,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    66,    67,    68,     3,     4,     5,
       6,     7,     8,     9,    10,    11,    12,    69,    89,   162,
      90,    70,     0,    71,    72,    73,    74,    75,    76,    77,
      78,    79,     0,    80,     0,    81,    82,    83,    84,    85,
      86,    87,    88,   203,   204,   205,   206,   207,   208,   209,
     210,   211,   212,   213,   214,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   267,    66,    67,    68,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    69,    89,
     232,    90,    70,     0,    71,    72,    73,    74,    75,    76,
      77,    78,    79,     0,    80,     0,    81,    82,    83,    84,
      85,    86,    87,    88,   203,   204,   205,   206,   207,   208,
     209,   210,   211,   212,   213,   214,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   269,    66,    67,    68,     3,
       4,     5,     6,     7,     8,     9,    10,    11,    12,    69,
      89,   305,    90,    70,     0,    71,    72,    73,    74,    75,
      76,    77,    78,    79,     0,    80,     0,    81,    82,    83,
      84,    85,    86,    87,    88,   203,   204,   205,   206,   207,
     208,   209,   210,   211,   212,   213,   214,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   314,    66,    67,    68,
       3,     4,     5,     6,     7,     8,     9,    10,    11,    12,
      69,    89,   307,    90,    70,     0,    71,    72,    73,    74,
      75,    76,    77,    78,    79,     0,    80,     0,    81,    82,
      83,    84,    85,    86,    87,    88,   203,   204,   205,   206,
     207,   208,   209,   210,   211,   212,   213,   214,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   324,    66,    67,
      68,     3,     4,     5,     6,     7,     8,     9,    10,    11,
      12,    69,    89,   333,    90,    70,     0,    71,    72,    73,
      74,    75,    76,    77,    78,    79,     0,    80,     0,    81,
      82,    83,    84,    85,    86,    87,    88,   203,   204,   205,
     206,   207,   208,   209,   210,   211,   212,   213,   214,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   330,    66,
      67,    68,     3,     4,     5,     6,     7,     8,     9,    10,
      11,    12,    69,    89,   334,    90,    70,     0,    71,    72,
      73,    74,    75,    76,    77,    78,    79,     0,    80,     0,
      81,    82,    83,    84,    85,    86,    87,    88,   123,   124,
     125,     3,     4,     5,     6,     7,     8,     9,    10,     0,
       0,    69,     0,     0,     0,    70,     0,    71,    72,    73,
      74,    75,    76,    77,     0,    79,     0,     0,     0,     0,
       0,     0,     0,     0,    89,     0,    90,   126,   127,   128,
     129,   130,   203,   204,   205,   206,   207,   208,   209,   210,
     211,   212,   213,   214,     0,     0,     0,     0,     0,     0,
       0,     0,   131,   365,     0,     0,     0,   132,     0,   133,
     228,   134,   135,   123,   124,   125,     3,     4,     5,     6,
       7,     8,     9,    10,     0,     0,    69,     0,     0,     0,
      70,     0,    71,    72,    73,    74,    75,    76,    77,     0,
      79,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   126,   127,   128,   129,   130,   203,   204,   205,
     206,   207,   208,   209,   210,   211,   212,   213,   214,     0,
       0,     0,     0,     0,     0,     0,     0,   131,   369,     0,
       0,     0,   132,     0,   133,   182,   134,   135,   123,   124,
     125,     3,     4,     5,     6,     7,     8,     9,    10,     0,
       0,    69,     0,     0,     0,    70,     0,    71,    72,    73,
      74,    75,    76,    77,     0,    79,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   126,   127,   128,
     129,   130,   203,   204,   205,   206,   207,   208,   209,   210,
     211,   212,   213,   214,     0,     0,     0,     0,     0,     0,
       0,     0,   131,   371,     0,     0,     0,   132,     0,   133,
     190,   134,   135,   123,   124,   125,     3,     4,     5,     6,
       7,     8,     9,    10,     0,     0,    69,     0,     0,     0,
      70,     0,    71,    72,    73,    74,    75,    76,    77,     0,
      79,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   126,   127,   128,   129,   130,   203,   204,   205,
     206,   207,   208,   209,   210,   211,   212,   213,   214,     0,
       0,     0,     0,     0,     0,     0,     0,   131,   373,     0,
       0,     0,   132,     0,   133,     0,   134,   135,   123,   301,
     302,     3,     4,     5,     6,     7,     8,     9,    10,     0,
       0,    69,     0,     0,     0,    70,     0,    71,    72,    73,
      74,    75,    76,    77,     0,    79,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   126,   127,   128,
     129,   130,   203,   204,   205,   206,   207,   208,   209,   210,
     211,   212,   213,   214,     0,     0,     0,     0,     0,     0,
       0,     0,   131,   375,     0,     0,     0,   132,     0,   133,
       0,   134,   135,   203,   204,   205,   206,   207,   208,   209,
     210,   211,   212,   213,   214,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   377,   203,   204,   205,   206,   207,
     208,   209,   210,   211,   212,   213,   214,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   379,   203,   204,   205,
     206,   207,   208,   209,   210,   211,   212,   213,   214,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   381,   203,
     204,   205,   206,   207,   208,   209,   210,   211,   212,   213,
     214,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     383,   203,   204,   205,   206,   207,   208,   209,   210,   211,
     212,   213,   214,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   385,   203,   204,   205,   206,   207,   208,   209,
     210,   211,   212,   213,   214,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   387,   203,   204,   205,   206,   207,
     208,   209,   210,   211,   212,   213,   214,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   389,   203,   204,   205,
     206,   207,   208,   209,   210,   211,   212,   213,   214,     0,
       0,     0,     0,     0,     0,     0,     0,   225,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
       0,     0,     0,     0,     0,     0,     0,     0,   261,   203,
     204,   205,   206,   207,   208,   209,   210,   211,   212,   213,
     214,     0,     0,     0,     0,     0,     0,     1,     2,   322,
       3,     4,     5,     6,     7,     8,     9,    10,    11,    12,
      13,    14,    15,    16,    17,    18,   203,   204,   205,   206,
     207,   208,   209,   210,   211,   212,   213,   214,     0,     0,
       0,   352,   203,   204,   205,   206,   207,   208,   209,   210,
     211,   212,   213,   214,     0,     0,     0,   353,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
       0,     0,     0,   366,   203,   204,   205,   206,   207,   208,
     209,   210,   211,   212,   213,   214,     0,   286,     0,   391,
     203,   204,   205,   206,   207,   208,   209,   210,   211,   212,
     213,   214,   203,   204,   205,   206,   207,   208,   209,   210,
     211,   212,   213,   214
};

static const short int yycheck[] =
{
       0,    58,   104,    51,   120,    80,    81,    53,     0,    51,
      51,    51,    51,    52,    53,    54,    55,    77,    56,    19,
      58,    59,    56,    23,    58,    59,    26,    19,    79,     0,
      81,    23,    74,    74,    82,    74,    75,    75,    75,    74,
      82,    82,    82,    43,    81,    82,    80,    93,    19,     3,
       4,    43,    76,    76,    54,   157,    56,   132,   133,    83,
      83,    69,    70,    71,    56,     6,     7,     8,     9,    10,
      11,    12,    13,    14,    15,    74,   122,    75,    78,   195,
      98,    75,    75,    78,    82,    74,    78,    81,    81,   107,
      31,   109,     3,     4,    94,    51,    52,    53,    54,    55,
      75,    75,    75,   160,   104,    74,    81,    81,    81,    75,
      54,    75,   112,   113,    80,    78,    80,    74,    74,    81,
     112,   113,     6,     7,     8,     9,    10,    11,    12,    13,
      14,    15,    74,   235,    75,   237,    75,   137,     3,     4,
     140,    80,    74,   218,   219,     3,     4,    31,   148,   149,
      94,    51,    52,    53,    54,    55,    82,   157,     4,     5,
     104,     6,     7,     8,    74,    10,    54,    68,    69,    70,
      71,   171,   274,    79,   276,     6,     7,     8,     9,    10,
      11,    12,    13,    14,    15,    56,   261,    58,    59,   112,
     113,    75,    74,   137,    74,    74,   140,    80,    76,    80,
      31,    33,    74,    80,   148,   149,    94,    80,    51,    52,
      53,    54,    55,   157,    80,    74,   104,     6,     7,     8,
       9,    10,    11,    12,    13,    14,    15,   171,   228,    80,
     230,    74,    82,    74,    83,   235,    83,   237,    78,    78,
      33,    51,    31,    78,    75,    78,    71,    59,    78,   137,
      79,    75,   140,   253,    75,    19,    56,    49,   258,   111,
     148,   149,   262,   291,   264,    -1,   234,    -1,    -1,   157,
      -1,    -1,    -1,   273,   274,   275,   276,    -1,    -1,    -1,
      -1,    -1,    -1,   171,   228,    -1,   230,    -1,    -1,    -1,
      -1,   235,    -1,   237,    -1,    -1,    54,     6,     7,     8,
       9,    10,    11,    12,    13,    -1,   306,    -1,   308,   253,
      -1,    -1,    -1,    -1,   258,    -1,    -1,    -1,   262,    -1,
     264,    -1,    -1,    -1,    -1,   325,    -1,   327,    -1,   273,
     274,   275,   276,    -1,    -1,    -1,    94,    -1,    -1,    -1,
     228,    -1,   230,    -1,    -1,    -1,   104,   235,    -1,   237,
      -1,   351,   352,   353,   354,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   306,    -1,   308,   253,   366,    -1,    -1,    -1,
     258,    -1,    -1,    -1,   262,    -1,   264,    -1,    -1,   137,
      -1,   325,   140,   327,    -1,   273,   274,   275,   276,    -1,
     148,   149,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   157,
      -1,    -1,    54,    -1,    -1,    -1,    -1,   351,   352,   353,
     354,    -1,    -1,   171,    -1,    -1,    -1,    -1,   306,    -1,
     308,    -1,   366,    60,    61,    62,    63,    64,    65,    66,
      67,    68,    69,    70,    71,    -1,    -1,   325,    -1,   327,
      -1,    -1,    94,    -1,    -1,    -1,    83,    -1,    -1,    -1,
      -1,    -1,   104,     6,     7,     8,     9,    10,    11,    12,
      13,    14,    15,   351,   352,   353,   354,    -1,    -1,    -1,
     228,    -1,   230,    -1,    -1,    -1,    -1,   235,   366,   237,
      -1,    -1,    -1,    -1,    -1,   137,    -1,    -1,   140,    -1,
      -1,    -1,    -1,    -1,    -1,   253,   148,   149,    -1,    -1,
     258,    -1,    -1,    -1,   262,   157,   264,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,   171,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    69,
      70,    71,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    83,    -1,    -1,    -1,    -1,   306,    -1,
     308,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    -1,    -1,    -1,    -1,   325,    -1,   327,
      -1,    -1,    -1,    -1,    83,    -1,   228,    -1,   230,    -1,
      -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,   354,    -1,    -1,    -1,
      -1,   253,    -1,    -1,    -1,    -1,   258,    -1,   366,    -1,
     262,    -1,   264,    -1,    80,    81,    -1,    -1,    -1,    85,
      -1,   273,   274,   275,   276,    -1,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    -1,    -1,
     106,    75,    -1,    -1,    -1,    -1,    -1,    81,    -1,   115,
     116,   117,   118,   119,   306,   121,   308,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   131,   132,   133,    -1,    -1,
     136,    -1,    -1,   325,    -1,   327,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    94,   150,    -1,    -1,   153,   154,   155,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,   354,   169,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   366,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   137,    -1,    -1,   140,
     196,    -1,    -1,    -1,    -1,    -1,    -1,   148,   149,    -1,
      -1,    -1,    -1,   209,   210,   211,   212,   213,   214,    -1,
     216,   217,   218,   219,    -1,   221,    -1,    -1,    -1,    -1,
     171,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    -1,   240,    -1,    75,    -1,    -1,   245,
      -1,    -1,    81,    60,    61,    62,    63,    64,    65,    66,
      67,    68,    69,    70,    71,   261,    -1,   263,    75,   265,
      -1,   267,    -1,   269,    81,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   278,   279,   280,   281,   282,   228,    -1,   230,
     286,    -1,    -1,   289,   290,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    -1,   304,    -1,
      75,    -1,   253,    -1,    -1,    -1,    81,   258,   314,    -1,
      -1,   262,    -1,   264,    -1,   321,   322,   323,   324,    -1,
     326,    -1,   273,    -1,   275,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    -1,    -1,    -1,
      75,    -1,   348,    -1,   350,    -1,    81,    -1,    -1,   355,
      -1,    -1,    -1,    -1,    -1,   306,    -1,   308,    -1,   365,
      -1,    -1,    -1,   369,    -1,   371,    -1,   373,    -1,   375,
      -1,   377,    -1,   379,   325,   381,   327,   383,    -1,   385,
      -1,   387,    -1,   389,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    69,    70,    71,    -1,    -1,    -1,    75,
     351,   352,   353,   354,    -1,    81,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   366,     3,     4,     5,     6,
       7,     8,     9,    10,    11,    12,    13,    14,    15,    16,
      -1,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    -1,    32,    -1,    34,    35,    36,
      37,    38,    39,    40,    41,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    -1,    -1,    -1,
      75,    -1,    -1,    60,    61,    62,    63,    64,    65,    66,
      67,    68,    69,    70,    71,    -1,    -1,    -1,    -1,    -1,
      -1,    78,    -1,    80,     3,     4,     5,     6,     7,     8,
       9,    10,    11,    12,    13,    14,    15,    16,    -1,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    -1,    32,    -1,    34,    35,    36,    37,    38,
      39,    40,    41,    60,    61,    62,    63,    64,    65,    66,
      67,    68,    69,    70,    71,    -1,    -1,    56,    75,    58,
      59,    -1,    -1,     3,     4,     5,     6,     7,     8,     9,
      10,    11,    12,    13,    14,    15,    16,    -1,    -1,    78,
      20,    80,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    -1,    32,    -1,    34,    35,    36,    37,    38,    39,
      40,    41,     0,    -1,    -1,     3,     4,    -1,     6,     7,
       8,     9,    10,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,     3,     4,     5,     6,     7,     8,
       9,    10,    11,    12,    13,    14,    15,    16,    78,    79,
      80,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    -1,    32,    -1,    34,    35,    36,    37,    38,
      39,    40,    41,    60,    61,    62,    63,    64,    65,    66,
      67,    68,    69,    70,    71,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    81,     3,     4,     5,     6,     7,
       8,     9,    10,    11,    12,    13,    14,    15,    16,    78,
      79,    80,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    -1,    32,    -1,    34,    35,    36,    37,
      38,    39,    40,    41,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    69,    70,    71,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    81,     3,     4,     5,     6,
       7,     8,     9,    10,    11,    12,    13,    14,    15,    16,
      78,    79,    80,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    -1,    32,    -1,    34,    35,    36,
      37,    38,    39,    40,    41,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    81,     3,     4,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      16,    78,    79,    80,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    -1,    32,    -1,    34,    35,
      36,    37,    38,    39,    40,    41,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    81,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    78,    79,    80,    20,    -1,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    -1,    32,    -1,    34,
      35,    36,    37,    38,    39,    40,    41,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    69,    70,    71,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    81,     3,
       4,     5,     6,     7,     8,     9,    10,    11,    12,    13,
      14,    15,    16,    78,    79,    80,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    -1,    32,    -1,
      34,    35,    36,    37,    38,    39,    40,    41,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    -1,
      -1,    16,    -1,    -1,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    78,    -1,    80,    42,    43,    44,
      45,    46,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    69,    70,    71,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    67,    81,    -1,    -1,    -1,    72,    -1,    74,
      75,    76,    77,     3,     4,     5,     6,     7,     8,     9,
      10,    11,    12,    13,    -1,    -1,    16,    -1,    -1,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    42,    43,    44,    45,    46,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    69,    70,    71,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    67,    81,    -1,
      -1,    -1,    72,    -1,    74,    75,    76,    77,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    -1,
      -1,    16,    -1,    -1,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    42,    43,    44,
      45,    46,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    69,    70,    71,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    67,    81,    -1,    -1,    -1,    72,    -1,    74,
      75,    76,    77,     3,     4,     5,     6,     7,     8,     9,
      10,    11,    12,    13,    -1,    -1,    16,    -1,    -1,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    42,    43,    44,    45,    46,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    69,    70,    71,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    67,    81,    -1,
      -1,    -1,    72,    -1,    74,    -1,    76,    77,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    -1,
      -1,    16,    -1,    -1,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    42,    43,    44,
      45,    46,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    69,    70,    71,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    67,    81,    -1,    -1,    -1,    72,    -1,    74,
      -1,    76,    77,    60,    61,    62,    63,    64,    65,    66,
      67,    68,    69,    70,    71,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    81,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    81,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    69,    70,    71,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    81,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    69,    70,
      71,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      81,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    81,    60,    61,    62,    63,    64,    65,    66,
      67,    68,    69,    70,    71,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    81,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    81,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    69,    70,    71,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    80,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    69,    70,    71,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    80,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    69,    70,
      71,    -1,    -1,    -1,    -1,    -1,    -1,     3,     4,    80,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    -1,    -1,
      -1,    75,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    69,    70,    71,    -1,    -1,    -1,    75,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    69,    70,    71,
      -1,    -1,    -1,    75,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    69,    70,    71,    -1,    57,    -1,    75,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    69,
      70,    71,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    69,    70,    71
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned char yystos[] =
{
       0,     3,     4,     6,     7,     8,     9,    10,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    85,
      86,    88,    89,    90,    91,    95,   101,   102,   103,   104,
     105,   106,   107,    74,    74,    77,   108,   108,   108,   108,
     108,     0,    86,    31,    75,    92,    93,    95,     3,     4,
       3,     4,   102,    95,    78,    75,    80,     3,     4,    96,
      97,    87,    87,    74,    74,    96,     3,     4,     5,    16,
      20,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      32,    34,    35,    36,    37,    38,    39,    40,    41,    78,
      80,    89,    94,    95,   109,   110,   113,   114,   115,   121,
     122,   123,   131,   132,    78,    93,    51,    82,    98,    82,
      98,    81,    74,    74,    74,    51,    52,    53,    54,    55,
      74,    82,    95,     3,     4,     5,    42,    43,    44,    45,
      46,    67,    72,    74,    76,    77,   102,   116,   117,   118,
     120,   121,   122,   123,   125,   126,   130,   132,   116,   120,
      74,   116,   120,    74,    74,    74,    79,   111,    80,     3,
       4,    96,    79,   110,    80,   130,    80,    80,    80,    74,
      80,   109,   116,    83,   130,    83,   130,    97,    75,    92,
      75,    92,    75,   116,   124,   116,   116,   116,   116,   116,
      75,   124,   116,    96,    74,    74,    82,   116,   116,   120,
     116,   120,   116,    60,    61,    62,    63,    64,    65,    66,
      67,    68,    69,    70,    71,   110,   119,    56,    58,    59,
     110,    74,   110,   110,   116,    80,   116,   116,    75,   116,
     109,   116,    79,    83,    83,    78,    75,    78,    75,    75,
      81,    75,    83,   116,    75,    81,    75,   116,   116,   116,
     116,   116,   116,    33,   116,   116,   120,   120,    33,   116,
     127,    80,    75,    81,    75,    81,   110,    81,   112,    81,
      51,    99,    99,   109,    78,   109,    78,   116,    51,    52,
      53,    54,    55,    83,   116,   110,    57,   110,    75,    81,
      82,   128,   129,   116,   120,   110,   116,   110,   116,   116,
      79,     4,     5,   116,    78,    79,   109,    79,   109,   116,
     116,   116,   116,   116,    81,   116,   116,   116,    75,   129,
      75,    81,    80,    80,    81,    75,    81,    75,    75,    75,
      81,   100,   116,    79,    79,   116,    83,    75,   116,   116,
     116,   116,   110,   116,   110,     4,     5,    79,    81,    75,
      81,    75,    75,    75,    75,    81,    75,    75,   116,   116,
     110,   110,   110,   110,   116,    81,    75,   116,   110,    81,
     116,    81,   116,    81,   116,    81,   116,    81,   116,    81,
     116,    81,   116,    81,   116,    81,   116,    81,   116,    81,
     116,    75
};

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    {								\
      yyerror (YY_("syntax error: cannot back up")); \
      YYERROR;							\
    }								\
while (0)


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (N)								\
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (0)
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
              (Loc).first_line, (Loc).first_column,	\
              (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr,					\
                  Type, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short int *bottom, short int *top)
#else
static void
yy_stack_print (bottom, top)
    short int *bottom;
    short int *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned long int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu), ",
             yyrule - 1, yylno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname[yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname[yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      size_t yyn = 0;
      char const *yyp = yystr;

      for (;;)
	switch (*++yyp)
	  {
	  case '\'':
	  case ',':
	    goto do_not_strip_quotes;

	  case '\\':
	    if (*++yyp != '\\')
	      goto do_not_strip_quotes;
	    /* Fall through.  */
	  default:
	    if (yyres)
	      yyres[yyn] = *yyp;
	    yyn++;
	    break;

	  case '"':
	    if (yyres)
	      yyres[yyn] = '\0';
	    return yyn;
	  }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

#endif /* YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);


# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yymsg, yytype, yyvaluep)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The look-ahead symbol.  */
int yychar;

/* The semantic value of the look-ahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()
    ;
#endif
#endif
{
  
  int yystate;
  int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Look-ahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short int yyssa[YYINITDEPTH];
  short int *yyss = yyssa;
  short int *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short int *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow (YY_("memory exhausted"),
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short int *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyexhaustedlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a look-ahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to look-ahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a look-ahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid look-ahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the look-ahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:

    {ParseTreePointer=(yyvsp[0].m_pParseNode);;}
    break;

  case 3:

    {ParseTreePointer->AddLastChild((yyvsp[0].m_pParseNode));;}
    break;

  case 6:

    {
			(yyval.m_Pos).m_LineNo = ParseLineNumber;
			(yyval.m_Pos).m_strFileName = ParseStreamName.c_str();
		;}
    break;

  case 7:

    {
								// Store a pointer to the actual shader.
								(yyval.m_pParseNode)=new CqParseNodeShader((yyvsp[-7].m_Identifier)->c_str(),(yyvsp[-8].m_ShaderType));
								(yyval.m_pParseNode)->SetPos((yyvsp[-6].m_Pos));
								(yyval.m_pParseNode)->AddLastChild((yyvsp[-1].m_pParseNode));

								// Now copy any initialisers from the formals list to their respective
								// local variable definitions.
								CqParseNode* pArgs=(yyvsp[-4].m_pParseNode);
								ProcessShaderArguments( pArgs );
								(yyval.m_pParseNode)->AddLastChild( (yyvsp[-4].m_pParseNode) );
							;}
    break;

  case 8:

    {
								// Store a pointer to the actual shader.
								CqString strName;
								if((yyvsp[-7].m_pSymbol).eType&1)	strName=CqVarDef::GetVariablePtr((yyvsp[-7].m_pSymbol).VarRef)->strName();
								else			strName=CqFuncDef::GetFunctionPtr((yyvsp[-7].m_pSymbol).FuncRef)->strName();
								(yyval.m_pParseNode)=new CqParseNodeShader(strName.c_str(),(yyvsp[-8].m_ShaderType));
								(yyval.m_pParseNode)->SetPos((yyvsp[-6].m_Pos));
								(yyval.m_pParseNode)->AddLastChild((yyvsp[-1].m_pParseNode));

								// Now copy any initialisers from the formals list to their respective
								// local variable definitions.
								CqParseNode* pArgs=(yyvsp[-4].m_pParseNode);
								ProcessShaderArguments( pArgs );
								(yyval.m_pParseNode)->AddLastChild( (yyvsp[-4].m_pParseNode) );
							;}
    break;

  case 9:

    {
								// Store a pointer to the actual shader.
								(yyval.m_pParseNode)=new CqParseNodeShader((yyvsp[-6].m_Identifier)->c_str(), (yyvsp[-7].m_ShaderType));
								(yyval.m_pParseNode)->SetPos((yyvsp[-5].m_Pos));
								(yyval.m_pParseNode)->AddLastChild((yyvsp[-1].m_pParseNode));
							;}
    break;

  case 10:

    {
								// Store a pointer to the actual shader.
								CqString strName;
								if((yyvsp[-6].m_pSymbol).eType&1)	strName=CqVarDef::GetVariablePtr((yyvsp[-6].m_pSymbol).VarRef)->strName();
								else			strName=CqFuncDef::GetFunctionPtr((yyvsp[-6].m_pSymbol).FuncRef)->strName();
								(yyval.m_pParseNode)=new CqParseNodeShader(strName.c_str(),(yyvsp[-7].m_ShaderType));
								(yyval.m_pParseNode)->SetPos((yyvsp[-5].m_Pos));
								(yyval.m_pParseNode)->AddLastChild((yyvsp[-1].m_pParseNode));
							;}
    break;

  case 11:

    {
								CqParseNodeDeclaration* pDecl=static_cast<CqParseNodeDeclaration*>((yyvsp[-5].m_pParseNode));

								// If no return/or multiple returns, then this is not a valid function.
								if((pDecl->Type()!=Type_Void) &&
								   (FunctionReturnCountStack.size() <=0 ||
								    FunctionReturnCountStack.back() != 1))
									yyerror("Must have one return in function");
								
								// Make a string of the parameter types.
								CqParseNode* pArgs=(yyvsp[-4].m_pParseNode);
								CqString strArgTypes("");
								if(pArgs)
								{
									// Each child of the variable_definitions is a CqParseNodeVariable
									CqParseNodeVariable* pVar=static_cast<CqParseNodeVariable*>(pArgs->pFirstChild());
									while(pVar)
									{
										// If storage is not specified, a function parameter defaults to varying.
										pVar->SetDefaultStorage(Type_Varying);
										// Get the type from the variable
										strArgTypes+=CqParseNode::TypeIdentifier(pVar->ResType());
										// TODO: Find out if local function arguments can have default values.
										// If so, they can be found as the child of pVar.
										pVar=static_cast<CqParseNodeVariable*>(pVar->pNext());
									}
								}

								// Add the function declaration to the list of local functions.
								CqFuncDef funcdef(pDecl->Type(), pDecl->strName(), pDecl->strName(), strArgTypes.c_str(), (yyvsp[-1].m_pParseNode), pArgs);
								CqFuncDef::AddFunction(funcdef);
								(yyval.m_pParseNode)=new CqParseNode();
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								delete(pDecl);
								// Function level namespace is now defunct.
								popScope();
								FunctionReturnCountStack.erase(FunctionReturnCountStack.end()-1);
							;}
    break;

  case 12:

    {
								CqParseNodeDeclaration* pDecl=static_cast<CqParseNodeDeclaration*>((yyvsp[-4].m_pParseNode));

								// If no return/or multiple returns, then this is not a valid function.
								if((pDecl->Type()!=Type_Void) &&
								   (FunctionReturnCountStack.size() <=0 ||
								    FunctionReturnCountStack.back() != 1))
									yyerror("Must have one return in function");

								// Add the function declaration to the list of local functions.
								CqFuncDef funcdef(pDecl->Type(), pDecl->strName(), pDecl->strName(), "", (yyvsp[-1].m_pParseNode), 0);
								CqFuncDef::AddFunction(funcdef);
								(yyval.m_pParseNode)=new CqParseNode();
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								delete(pDecl);
								// Function level namespace is now defunct.
								popScope();
								FunctionReturnCountStack.erase(FunctionReturnCountStack.end()-1);
							;}
    break;

  case 13:

    {
								(yyval.m_pParseNode)=new CqParseNodeDeclaration((strNameSpace()+*(yyvsp[-1].m_Identifier)).c_str(),(yyvsp[-2].m_TypeAndSpace).Type);
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								// Store the name of the function being defined for use in variable namespacing.
								pushScope(*(yyvsp[-1].m_Identifier),TqTrue);
								// Push a new level onto the FunctionReturnCountStack.
								FunctionReturnCountStack.push_back(0);
							;}
    break;

  case 14:

    {	
								(yyval.m_pParseNode)=new CqParseNodeDeclaration((strNameSpace()+*(yyvsp[-1].m_Identifier)).c_str(),Type_Void);
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								// Store the name of the function being defined for use in variable namespacing.
								pushScope(*(yyvsp[-1].m_Identifier),TqTrue);
								// Push a new level onto the FunctionReturnCountStack.
								FunctionReturnCountStack.push_back(0);
							;}
    break;

  case 15:

    {
								// TODO: Should warn about duplicate declarations.
								CqString strName(strNameSpace());
								if((yyvsp[-1].m_pSymbol).eType&1)	strName+=CqVarDef::GetVariablePtr((yyvsp[-1].m_pSymbol).VarRef)->strName();
								else			strName+=CqFuncDef::GetFunctionPtr((yyvsp[-1].m_pSymbol).FuncRef)->strName();

								(yyval.m_pParseNode)=new CqParseNodeDeclaration(strName.c_str(),(yyvsp[-2].m_TypeAndSpace).Type);
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								// Store the name of the function being defined for use in variable namespacing.
								pushScope(strName,TqTrue);
								// Push a new level onto the FunctionReturnCountStack.
								FunctionReturnCountStack.push_back(0);
							;}
    break;

  case 16:

    {	
								// TODO: Should warn about duplicate declarations.
								CqString strName(strNameSpace());
								if((yyvsp[-1].m_pSymbol).eType&1)	strName+=CqVarDef::GetVariablePtr((yyvsp[-1].m_pSymbol).VarRef)->strName();
								else			strName+=CqFuncDef::GetFunctionPtr((yyvsp[-1].m_pSymbol).FuncRef)->strName();

								(yyval.m_pParseNode)=new CqParseNodeDeclaration(strName.c_str(),Type_Void);
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								// Store the name of the function being defined for use in variable namespacing.
								pushScope(strName,TqTrue);
								// Push a new level onto the FunctionReturnCountStack.
								FunctionReturnCountStack.push_back(0);
							;}
    break;

  case 17:

    { 
								(yyval.m_ShaderType) = Type_Lightsource;
							;}
    break;

  case 18:

    { 
								(yyval.m_ShaderType) = Type_Surface;
							;}
    break;

  case 19:

    { 
								(yyval.m_ShaderType) = Type_Volume;
							;}
    break;

  case 20:

    { 
								(yyval.m_ShaderType) = Type_Displacement;
							;}
    break;

  case 21:

    { 
								(yyval.m_ShaderType) = Type_Transformation;
							;}
    break;

  case 22:

    { 
								(yyval.m_ShaderType) = Type_Imager;
							;}
    break;

  case 23:

    {
								// Create a list header, and add the first entry to it.
								(yyval.m_pParseNode)=new CqParseNode();
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								CqParseNodeVariable* pVarNode=static_cast<CqParseNodeVariable*>((yyvsp[0].m_pParseNode)->pFirstChild());
								while(pVarNode!=0)
								{
									CqParseNodeVariable* pVarNext=static_cast<CqParseNodeVariable*>(pVarNode->pNext());
									(yyval.m_pParseNode)->AddLastChild(pVarNode);
									pVarNode=pVarNext;
								}
							;}
    break;

  case 24:

    {
								// Add this one to the list.
								CqParseNodeVariable* pVarNode=static_cast<CqParseNodeVariable*>((yyvsp[0].m_pParseNode)->pFirstChild());
								while(pVarNode!=0)
								{
									CqParseNodeVariable* pVarNext=static_cast<CqParseNodeVariable*>(pVarNode->pNext());
									(yyval.m_pParseNode)->AddLastChild(pVarNode);
									pVarNode=pVarNext;
								}
							;}
    break;

  case 26:

    {
								(yyval.m_pParseNode)=new CqParseNode();
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								CqParseNodeDeclaration* pDecl=static_cast<CqParseNodeDeclaration*>((yyvsp[0].m_pParseNode)->pFirstChild());
								while(pDecl)
								{
									TqInt Type=((yyvsp[-1].m_TypeAndSpace).Type);
									TqInt arrayLength = 0;
									
									SqVarRef var;
									TqBool fv=CqVarDef::FindVariable((strNameSpace()+pDecl->strName()).c_str(), var);
									if(fv)
									{
										CqVarDef* pVar=CqVarDef::GetVariablePtr(var);
										// Check if the declaration marked it as an arry
										if(pVar->Type()&Type_Array)
											Type=(TqInt)(Type|Type_Array);
										arrayLength = pVar->ArrayLength();

										pVar->SetType(Type);
										// Create a variable node, in the case of local variable definition, these nodes will be removed, 
										// and only the intitialisers kept.
										// In the case of function parameters, the variables will be needed for type string construction.
										CqParseNode* pVarNode=new CqParseNodeVariable(var);
										pVarNode->SetPos(ParseLineNumber,ParseStreamName.c_str());
										(yyval.m_pParseNode)->AddLastChild(pVarNode);

										// Copy any initialisers
										if(pDecl->pFirstChild())
										{
											if(Type&Type_Array)
											{
												CqParseNode* pArrayInit=new CqParseNode();

												CqParseNode* pInitList=pDecl->pFirstChild();
												CqParseNode* pInit=pInitList->pFirstChild();
												TqInt i=0;
												while(pInit!=0)
												{
													CqParseNode* pInit2=pInit->pNext();
													CqParseNodeAssignArray* pInitFunc=new CqParseNodeAssignArray(var);
													pInitFunc->NoDup();
													CqParseNodeFloatConst* pIndex=new CqParseNodeFloatConst(i);

													pInitFunc->AddLastChild(pInit);
													pInitFunc->AddLastChild(pIndex);
													pArrayInit->AddLastChild(pInitFunc);

													i++;
													pInit=pInit2;
												}
												// Check if the right number of initialisers has been specified.
												if(i != arrayLength)
												{
													CqString strError("Error: expected exactly ");
													strError += arrayLength;
													strError += " initialisers, got ";
													strError += i;
													yyerror(strError);
												}
												pVarNode->AddLastChild(pArrayInit);
											}
											else
											{
												// Create an assign operator to initialise the variable.
												CqParseNode* pV=new CqParseNodeAssign(var);
												pV->SetPos(ParseLineNumber,ParseStreamName.c_str());
												pV->NoDup();
												pV->AddLastChild(pDecl->pFirstChild());

												pVarNode->AddLastChild(pV);
												pDecl->ClearChild();
											}
										}
									}

									CqParseNode* pTemp=pDecl;
									pDecl=static_cast<CqParseNodeDeclaration*>(pDecl->pNext());
									delete(pTemp);
								}
							;}
    break;

  case 27:

    {
								(yyval.m_pParseNode)=new CqParseNode();
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								CqParseNodeDeclaration* pDecl=static_cast<CqParseNodeDeclaration*>((yyvsp[0].m_pParseNode)->pFirstChild());
								while(pDecl)
								{
									TqInt Type=((yyvsp[-1].m_TypeAndSpace).Type);
									TqInt arrayLength = 0;
									
									SqVarRef var;
									TqBool fv=CqVarDef::FindVariable((strNameSpace()+pDecl->strName()).c_str(), var);
									if(fv)
									{
										CqVarDef* pVar=CqVarDef::GetVariablePtr(var);
										// Check if the declaration marked it as an arry
										if(pVar->Type()&Type_Array)
											Type=(TqInt)(Type|Type_Array);
										arrayLength = pVar->ArrayLength();

										pVar->SetType(Type);
										// Create a variable node, in the case of local variable definition, these nodes will be removed, 
										// and only the intitialisers kept.
										// In the case of function parameters, the variables will be needed for type string construction.
										CqParseNodeVariable* pVarNode=new CqParseNodeVariable(var);
										pVarNode->SetOutput();
										pVarNode->SetPos(ParseLineNumber,ParseStreamName.c_str());
										(yyval.m_pParseNode)->AddLastChild(pVarNode);

										// Copy any initialisers
										if(pDecl->pFirstChild())
										{
											if(Type&Type_Array)
											{
												CqParseNode* pArrayInit=new CqParseNode();

												CqParseNode* pInitList=pDecl->pFirstChild();
												CqParseNode* pInit=pInitList->pFirstChild();
												TqInt i=0;
												while(pInit!=0)
												{
													CqParseNode* pInit2=pInit->pNext();
													CqParseNodeAssignArray* pInitFunc=new CqParseNodeAssignArray(var);
													pInitFunc->NoDup();
													CqParseNodeFloatConst* pIndex=new CqParseNodeFloatConst(i);

													pInitFunc->AddLastChild(pInit);
													pInitFunc->AddLastChild(pIndex);
													pArrayInit->AddLastChild(pInitFunc);

													i++;
													pInit=pInit2;
												}
												// Check if the right number of initialisers has been specified.
												if(i != arrayLength)
												{
													CqString strError("Error: expected exactly ");
													strError += arrayLength;
													strError += " initialisers, got ";
													strError += i;
													yyerror(strError);
												}
												pVarNode->AddLastChild(pArrayInit);
											}
											else
											{
												// Create an assign operator to initialise the variable.
												CqParseNode* pV=new CqParseNodeAssign(var);
												pV->SetPos(ParseLineNumber,ParseStreamName.c_str());
												pV->NoDup();
												pV->AddLastChild(pDecl->pFirstChild());

												pVarNode->AddLastChild(pV);
												pDecl->ClearChild();
											}
										}
									}

									CqParseNode* pTemp=pDecl;
									pDecl=static_cast<CqParseNodeDeclaration*>(pDecl->pNext());
									delete(pTemp);
								}
							;}
    break;

  case 28:

    {
								(yyval.m_pParseNode)=new CqParseNode();
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								CqParseNodeDeclaration* pDecl=static_cast<CqParseNodeDeclaration*>((yyvsp[0].m_pParseNode)->pFirstChild());
								while(pDecl)
								{
									TqInt Type=((yyvsp[-1].m_TypeAndSpace).Type);
									TqInt arrayLength = 0;
									
									SqVarRef var;
									TqBool fv=CqVarDef::FindVariable((strNameSpace()+pDecl->strName()).c_str(), var);
									if(fv)
									{
										CqVarDef* pVar=CqVarDef::GetVariablePtr(var);
										// Check if the declaration marked it as an arry
										if(pVar->Type()&Type_Array)
										{
											Type=(TqInt)(Type|Type_Array);
											if( pVar->ArrayLength() <= 0 )
												yyerror("Array length must be specified.");
										}
										arrayLength = pVar->ArrayLength();

										pVar->SetType(Type);
										// Create a variable node, in the case of local variable definition, these nodes will be removed, 
										// and only the intitialisers kept.
										// In the case of function parameters, the variables will be needed for type string construction.
										CqParseNode* pVarNode=new CqParseNodeVariable(var);
										pVarNode->SetPos(ParseLineNumber,ParseStreamName.c_str());
										(yyval.m_pParseNode)->AddLastChild(pVarNode);

										// Copy any initialisers
										if(pDecl->pFirstChild())
										{
											if(Type&Type_Array)
											{
												CqParseNode* pArrayInit=new CqParseNode();

												CqParseNode* pInitList=pDecl->pFirstChild();
												CqParseNode* pInit=pInitList->pFirstChild();
												TqInt i=0;
												while(pInit!=0)
												{
													CqParseNode* pInit2=pInit->pNext();
													CqParseNodeAssignArray* pInitFunc=new CqParseNodeAssignArray(var);
													pInitFunc->NoDup();
													CqParseNodeFloatConst* pIndex=new CqParseNodeFloatConst(i);

													pInitFunc->AddLastChild(pInit);
													pInitFunc->AddLastChild(pIndex);
													pArrayInit->AddLastChild(pInitFunc);

													i++;
													pInit=pInit2;
												}
												// Check if the right number of initialisers has been specified.
												if(i != arrayLength)
												{
													CqString strError("Error: expected exactly ");
													strError += arrayLength;
													strError += " initialisers, got ";
													strError += i;
													yyerror(strError);
												}
												pVarNode->AddLastChild(pArrayInit);
											}
											else
											{
												// Create an assign operator to initialise the variable.
												CqParseNode* pV=new CqParseNodeAssign(var);
												pV->SetPos(ParseLineNumber,ParseStreamName.c_str());
												pV->NoDup();
												pV->AddLastChild(pDecl->pFirstChild());

												pVarNode->AddLastChild(pV);
												pDecl->ClearChild();
											}
										}
									}

									CqParseNode* pTemp=pDecl;
									pDecl=static_cast<CqParseNodeDeclaration*>(pDecl->pNext());
									delete(pTemp);
								}
							;}
    break;

  case 29:

    {
								(yyval.m_pParseNode)=new CqParseNode();
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								CqParseNodeDeclaration* pDecl=static_cast<CqParseNodeDeclaration*>((yyvsp[0].m_pParseNode)->pFirstChild());
								while(pDecl)
								{
									SqVarRef varLocal, varExtern;
									TqBool fvl=CqVarDef::FindVariable((strNameSpace()+pDecl->strName()).c_str(), varLocal);

									// As this is an extern, we need to repeatedly check in the previous namespaces
									// until we find the variable they are referring to.
									TqBool fve=TqFalse;
									if(!ParseNameSpaceStack.empty())
									{
										std::vector<std::pair<TqBool,CqString> >::reverse_iterator i=ParseNameSpaceStack.rbegin()+1;
										while(!fve && i!=ParseNameSpaceStack.rend())
										{
											CqString strNS=i->second;
											fve=CqVarDef::FindVariable((strNS+pDecl->strName()).c_str(), varExtern);
											i++;
										}
									}
									if(!fve)
									{
										// If not found in the namespaces defined in the code, check the global namespace.
										fve=CqVarDef::FindStandardVariable(pDecl->strName(), varExtern);
									}

									// If we found a candidate...
									if(fve && fvl)
									{
										CqVarDef* pvarLocal=CqVarDef::GetVariablePtr(varLocal);
										CqVarDef* pvarExtern=CqVarDef::GetVariablePtr(varExtern);
										CqParseNode* pVarNode=new CqParseNodeVariable(varLocal);
										pvarLocal->SetExtern(TqTrue, varExtern);
										pvarLocal->SetType(pvarExtern->Type());
										pVarNode->SetPos(ParseLineNumber,ParseStreamName.c_str());
										(yyval.m_pParseNode)->AddLastChild(pVarNode);
									}
									else
										yyerror("extern not found");

									CqParseNode* pTemp=pDecl;
									pDecl=static_cast<CqParseNodeDeclaration*>(pDecl->pNext());
									delete(pTemp);
								}
							;}
    break;

  case 30:

    {
								(yyval.m_TypeAndSpace).Type=(TqInt)((yyvsp[0].m_TypeAndSpace).Type|(yyvsp[-1].m_VarType));
								(yyval.m_TypeAndSpace).Space=(yyvsp[0].m_TypeAndSpace).Space;
							;}
    break;

  case 32:

    {
								// Create a list header and add the first element.
								(yyval.m_pParseNode)=new CqParseNode();
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								(yyval.m_pParseNode)->AddLastChild((yyvsp[0].m_pParseNode));
							;}
    break;

  case 33:

    {
								// This one to the list.
								(yyval.m_pParseNode)->AddLastChild((yyvsp[0].m_pParseNode));
							;}
    break;

  case 34:

    {
								// Create a new variable declaration based on the specified name.
								(yyval.m_pParseNode)=new CqParseNodeDeclaration((yyvsp[-1].m_Identifier)->c_str());
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								CqVarDef vardef(Type_Void, (strNameSpace()+*(yyvsp[-1].m_Identifier)).c_str());
								CqVarDef::AddVariable(vardef);
								// Add the initialiser as the first child of the declaration.
								(yyval.m_pParseNode)->AddLastChild((yyvsp[0].m_pParseNode));
							;}
    break;

  case 35:

    {
								// Create a new variable declaration based on the specified name.
								(yyval.m_pParseNode)=new CqParseNodeDeclaration((yyvsp[0].m_Identifier)->c_str());
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								CqVarDef vardef(Type_Void, (strNameSpace()+*(yyvsp[0].m_Identifier)).c_str());
								CqVarDef::AddVariable(vardef);
							;}
    break;

  case 36:

    {
								// Create a new variable declaration based on the specified name.
								(yyval.m_pParseNode)=new CqParseNodeDeclaration((yyvsp[-3].m_Identifier)->c_str());
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								CqVarDef vardef(Type_Array, (strNameSpace()+*(yyvsp[-3].m_Identifier)).c_str(), static_cast<TqInt>((yyvsp[-1].m_FloatConst)));
								CqVarDef::AddVariable(vardef);
							;}
    break;

  case 37:

    {
								// Create a new variable declaration based on the specified name.
								(yyval.m_pParseNode)=new CqParseNodeDeclaration((yyvsp[-4].m_Identifier)->c_str());
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								CqVarDef vardef(Type_Array, (strNameSpace()+*(yyvsp[-4].m_Identifier)).c_str(), static_cast<TqInt>((yyvsp[-2].m_FloatConst)));
								CqVarDef::AddVariable(vardef);
								(yyval.m_pParseNode)->AddLastChild((yyvsp[0].m_pParseNode));
							;}
    break;

  case 38:

    {
								// Create a new variable declaration based on the specified name.
								(yyval.m_pParseNode)=new CqParseNodeDeclaration((yyvsp[-2].m_Identifier)->c_str());
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								CqVarDef vardef(Type_Array, (strNameSpace()+*(yyvsp[-2].m_Identifier)).c_str(), 0);
								CqVarDef::AddVariable(vardef);
							;}
    break;

  case 39:

    {
								// Create a new declaration based on the name.
								// TODO: Should warn about duplicate declarations.
								CqString strName("");
								if((yyvsp[-1].m_pSymbol).eType&1)	strName=CqVarDef::GetVariablePtr((yyvsp[-1].m_pSymbol).VarRef)->strName();
								else			strName=CqFuncDef::GetFunctionPtr((yyvsp[-1].m_pSymbol).FuncRef)->strName();

								(yyval.m_pParseNode)=new CqParseNodeDeclaration(strName.c_str());
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								CqVarDef vardef(Type_Void, (strNameSpace()+strName).c_str());
								CqVarDef::AddVariable(vardef);
								// Add the initialiser as the first child of the declaration.
								(yyval.m_pParseNode)->AddLastChild((yyvsp[0].m_pParseNode));
							;}
    break;

  case 40:

    {
								CqString strName("");
								if((yyvsp[0].m_pSymbol).eType&1)	strName=CqVarDef::GetVariablePtr((yyvsp[0].m_pSymbol).VarRef)->strName();
								else			strName=CqFuncDef::GetFunctionPtr((yyvsp[0].m_pSymbol).FuncRef)->strName();

								(yyval.m_pParseNode)=new CqParseNodeDeclaration(strName.c_str());
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								CqVarDef vardef(Type_Void, (strNameSpace()+strName).c_str());
								CqVarDef::AddVariable(vardef);
							;}
    break;

  case 41:

    {
								CqString strName("");
								if((yyvsp[-3].m_pSymbol).eType&1)	strName=CqVarDef::GetVariablePtr((yyvsp[-3].m_pSymbol).VarRef)->strName();
								else			strName=CqFuncDef::GetFunctionPtr((yyvsp[-3].m_pSymbol).FuncRef)->strName();

								(yyval.m_pParseNode)=new CqParseNodeDeclaration(strName.c_str());
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								CqVarDef vardef(Type_Array, (strNameSpace()+strName).c_str(), static_cast<TqInt>((yyvsp[-1].m_FloatConst)));
								CqVarDef::AddVariable(vardef);
							;}
    break;

  case 42:

    {
								CqString strName("");
								if((yyvsp[-4].m_pSymbol).eType&1)	strName=CqVarDef::GetVariablePtr((yyvsp[-4].m_pSymbol).VarRef)->strName();
								else			strName=CqFuncDef::GetFunctionPtr((yyvsp[-4].m_pSymbol).FuncRef)->strName();

								(yyval.m_pParseNode)=new CqParseNodeDeclaration(strName.c_str());
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								CqVarDef vardef(Type_Array, (strNameSpace()+strName).c_str(), static_cast<TqInt>((yyvsp[-2].m_FloatConst)));
								CqVarDef::AddVariable(vardef);
								(yyval.m_pParseNode)->AddLastChild((yyvsp[0].m_pParseNode));
							;}
    break;

  case 43:

    {
								CqString strName("");
								if((yyvsp[-2].m_pSymbol).eType&1)	strName=CqVarDef::GetVariablePtr((yyvsp[-2].m_pSymbol).VarRef)->strName();
								else			strName=CqFuncDef::GetFunctionPtr((yyvsp[-2].m_pSymbol).FuncRef)->strName();

								(yyval.m_pParseNode)=new CqParseNodeDeclaration(strName.c_str());
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								CqVarDef vardef(Type_Array, (strNameSpace()+strName).c_str(), 0);
								CqVarDef::AddVariable(vardef);
							;}
    break;

  case 44:

    {
								(yyval.m_pParseNode)=(yyvsp[0].m_pParseNode);
							;}
    break;

  case 45:

    {
								CqParseNode* pArrayInit=new CqParseNode();
								CqParseNode* pInit=(yyvsp[-1].m_pParseNode)->pFirstChild();
								while(pInit)
								{
									CqParseNode* pInit2=pInit->pNext();
									pArrayInit->AddLastChild(pInit);
									pInit=pInit2;
								}
								(yyval.m_pParseNode)=pArrayInit;
							;}
    break;

  case 46:

    {
								// Create a list header and add the first element.
								(yyval.m_pParseNode)=new CqParseNode();
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								(yyval.m_pParseNode)->AddLastChild((yyvsp[0].m_pParseNode));
							;}
    break;

  case 47:

    {
								// This one to the list.
								(yyval.m_pParseNode)->AddLastChild((yyvsp[0].m_pParseNode));
							;}
    break;

  case 48:

    {	(yyval.m_VarType)=Type_Varying;	;}
    break;

  case 49:

    {	(yyval.m_VarType)=Type_Uniform;	;}
    break;

  case 50:

    {	
								(yyval.m_TypeAndSpace).Type=Type_Float;		
								(yyval.m_TypeAndSpace).Space=0;
							;}
    break;

  case 51:

    {
								(yyval.m_TypeAndSpace).Type=Type_String;	
								(yyval.m_TypeAndSpace).Space=0;
							;}
    break;

  case 52:

    {
								(yyval.m_TypeAndSpace).Type=Type_Void;
								(yyval.m_TypeAndSpace).Space=0;
							;}
    break;

  case 58:

    {
								(yyval.m_TypeAndSpace).Type=Type_Point;		
								(yyval.m_TypeAndSpace).Space=(yyvsp[0].m_Identifier);
							;}
    break;

  case 59:

    {
								(yyval.m_TypeAndSpace).Type=Type_Point;		
								(yyval.m_TypeAndSpace).Space=0;
							;}
    break;

  case 60:

    {
								(yyval.m_TypeAndSpace).Type=Type_Color;		
								(yyval.m_TypeAndSpace).Space=(yyvsp[0].m_Identifier);
							;}
    break;

  case 61:

    {
								(yyval.m_TypeAndSpace).Type=Type_Color;		
								(yyval.m_TypeAndSpace).Space=0;
							;}
    break;

  case 62:

    {
								(yyval.m_TypeAndSpace).Type=Type_Vector;		
								(yyval.m_TypeAndSpace).Space=(yyvsp[0].m_Identifier);
							;}
    break;

  case 63:

    {
								(yyval.m_TypeAndSpace).Type=Type_Vector;		
								(yyval.m_TypeAndSpace).Space=0;
							;}
    break;

  case 64:

    {
								(yyval.m_TypeAndSpace).Type=Type_Normal;		
								(yyval.m_TypeAndSpace).Space=(yyvsp[0].m_Identifier);
							;}
    break;

  case 65:

    {
								(yyval.m_TypeAndSpace).Type=Type_Normal;		
								(yyval.m_TypeAndSpace).Space=0;
							;}
    break;

  case 66:

    {
								(yyval.m_TypeAndSpace).Type=Type_Matrix;		
								(yyval.m_TypeAndSpace).Space=(yyvsp[0].m_Identifier);
							;}
    break;

  case 67:

    {
								(yyval.m_TypeAndSpace).Type=Type_Matrix;		
								(yyval.m_TypeAndSpace).Space=0;
							;}
    break;

  case 69:

    {
								// Create a list header and add the first element.
								(yyval.m_pParseNode)=new CqParseNode();
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								(yyval.m_pParseNode)->AddFirstChild((yyvsp[0].m_pParseNode));
							;}
    break;

  case 70:

    {
								// Add this one to the list.
								(yyval.m_pParseNode)->AddLastChild((yyvsp[0].m_pParseNode));
							;}
    break;

  case 71:

    {(yyval.m_pParseNode)->NoDup();;}
    break;

  case 72:

    {
								if((yyval.m_pParseNode)->ResType()!=Type_Void)
								{
									(yyval.m_pParseNode)=new CqParseNodeDrop();
									(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
									(yyval.m_pParseNode)->AddLastChild((yyvsp[-1].m_pParseNode));
								}
							;}
    break;

  case 73:

    {
								if((yyval.m_pParseNode)->ResType()!=Type_Void)
								{
									(yyval.m_pParseNode)=new CqParseNodeDrop();
									(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
									(yyval.m_pParseNode)->AddLastChild((yyvsp[-1].m_pParseNode));
								}
							;}
    break;

  case 74:

    {
								(yyval.m_pParseNode)=new CqParseNodeDrop();
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								(yyval.m_pParseNode)->AddLastChild((yyvsp[-1].m_pParseNode));
							;}
    break;

  case 75:

    {
								(yyval.m_pParseNode)=new CqParseNode();
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								(yyval.m_pParseNode)->AddLastChild((yyvsp[-1].m_pParseNode));
								// Increment the count of returns for the current function.
								if(FunctionReturnCountStack.size() > 0)
									FunctionReturnCountStack.back()++;
							;}
    break;

  case 78:

    {
								// Remove the variable nodes from these leaving just the 
								// intialisation code.
								// Each child of the variable_definitions is a CqParseNodeVariable
								CqParseNodeVariable* pVar=static_cast<CqParseNodeVariable*>((yyvsp[-1].m_pParseNode)->pFirstChild());
								while(pVar)
								{
									CqParseNodeVariable* pTemp=static_cast<CqParseNodeVariable*>(pVar->pNext());

									// If storage is not specified, local variable defaults to varying.
									pVar->SetDefaultStorage(Type_Varying);
									
									// Relink the initialisers, if any, after the variable.
									if(pVar->pFirstChild())
									{
										// Make sure that any change in the storage type is communicated to the initialiser
										pVar->pFirstChild()->UpdateStorageStatus();
										CqParseNode* pVarying=pVar->pFirstChild();
										pVarying->LinkAfter(pVar);
									}
									pVar->UnLink();
									delete(pVar);
									pVar=pTemp;
								}
							;}
    break;

  case 80:

    {
								// Introduce a new scope for the block
								CqString scopeName("b");
								scopeName += blockID++;
								pushScope(scopeName);
							;}
    break;

  case 81:

    {
								popScope();
							;}
    break;

  case 82:

    {	
								(yyval.m_pParseNode)=(yyvsp[-2].m_pParseNode);	
							;}
    break;

  case 83:

    {	(yyval.m_pParseNode)=new CqParseNode(); ;}
    break;

  case 84:

    {	(yyval.m_pParseNode)=new CqParseNode(); ;}
    break;

  case 85:

    {
								CqParseNode* pNew=new CqParseNodeConditional();
								pNew->SetPos(ParseLineNumber,ParseStreamName.c_str());
								pNew->AddLastChild((yyvsp[-1].m_pParseNode));
								pNew->AddLastChild((yyvsp[0].m_pParseNode));
								(yyval.m_pParseNode)=pNew;
							;}
    break;

  case 86:

    {
								CqParseNode* relation=new CqParseNodeRelOp(Op_NE);
								relation->SetPos(ParseLineNumber,ParseStreamName.c_str());
								relation->AddFirstChild((yyvsp[-1].m_pParseNode));
								CqParseNode* pcomp=new CqParseNodeFloatConst(0);
								relation->AddLastChild(pcomp);

								CqParseNode* pNew=new CqParseNodeConditional();
								pNew->SetPos(ParseLineNumber,ParseStreamName.c_str());
								pNew->AddLastChild(relation);
								pNew->AddLastChild((yyvsp[0].m_pParseNode));
								(yyval.m_pParseNode)=pNew;

							;}
    break;

  case 87:

    {
								CqParseNode* pNew=new CqParseNodeConditional();
								pNew->SetPos(ParseLineNumber,ParseStreamName.c_str());
								pNew->AddLastChild((yyvsp[-3].m_pParseNode));
								pNew->AddLastChild((yyvsp[-2].m_pParseNode));
								pNew->AddLastChild((yyvsp[0].m_pParseNode));
								(yyval.m_pParseNode)=pNew;
							;}
    break;

  case 88:

    {
								CqParseNode* relation=new CqParseNodeRelOp(Op_NE);
								relation->SetPos(ParseLineNumber,ParseStreamName.c_str());
								relation->AddFirstChild((yyvsp[-3].m_pParseNode));
								CqParseNode* pcomp=new CqParseNodeFloatConst(0);
								relation->AddLastChild(pcomp);
								CqParseNode* pNew=new CqParseNodeConditional();
								
								pNew->SetPos(ParseLineNumber,ParseStreamName.c_str());
								pNew->AddLastChild(relation);
								pNew->AddLastChild((yyvsp[-2].m_pParseNode));
								pNew->AddLastChild((yyvsp[0].m_pParseNode));
								(yyval.m_pParseNode)=pNew;
							;}
    break;

  case 89:

    {
								(yyval.m_pParseNode)=new CqParseNodeWhileConstruct();
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								(yyval.m_pParseNode)->AddLastChild((yyvsp[-1].m_pParseNode));
								(yyval.m_pParseNode)->AddLastChild((yyvsp[0].m_pParseNode));
							;}
    break;

  case 90:

    {
								CqParseNode* relation=new CqParseNodeRelOp(Op_NE);
								relation->SetPos(ParseLineNumber,ParseStreamName.c_str());
								relation->AddFirstChild((yyvsp[-1].m_pParseNode));
								CqParseNode* pcomp=new CqParseNodeFloatConst(0);
								relation->AddLastChild(pcomp);

								(yyval.m_pParseNode)=new CqParseNodeWhileConstruct();
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								(yyval.m_pParseNode)->AddLastChild(relation);
								(yyval.m_pParseNode)->AddLastChild((yyvsp[0].m_pParseNode));
							;}
    break;

  case 91:

    {
								(yyval.m_pParseNode)=new CqParseNode();
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								(yyval.m_pParseNode)->AddLastChild((yyvsp[-6].m_pParseNode));
								CqParseNode* pW=new CqParseNodeWhileConstruct();
								pW->SetPos(ParseLineNumber,ParseStreamName.c_str());
								(yyval.m_pParseNode)->AddLastChild(pW);
								pW->AddLastChild((yyvsp[-4].m_pParseNode));
								pW->AddLastChild((yyvsp[0].m_pParseNode));
								pW->AddLastChild((yyvsp[-2].m_pParseNode));
								// Make sure that any assigns in the two expressions don't dup
								(yyvsp[-6].m_pParseNode)->NoDup();
								(yyvsp[-2].m_pParseNode)->NoDup();
							;}
    break;

  case 92:

    {
								CqParseNode* relation=new CqParseNodeRelOp(Op_NE);
								relation->SetPos(ParseLineNumber,ParseStreamName.c_str());
								relation->AddFirstChild((yyvsp[-4].m_pParseNode));
								CqParseNode* pcomp=new CqParseNodeFloatConst(0);
								relation->AddLastChild(pcomp);

								(yyval.m_pParseNode)=new CqParseNode();
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								(yyval.m_pParseNode)->AddLastChild((yyvsp[-6].m_pParseNode));
								CqParseNode* pW=new CqParseNodeWhileConstruct();
								pW->SetPos(ParseLineNumber,ParseStreamName.c_str());
								(yyval.m_pParseNode)->AddLastChild(pW);
								pW->AddLastChild(relation);
								pW->AddLastChild((yyvsp[0].m_pParseNode));
								pW->AddLastChild((yyvsp[-2].m_pParseNode));
								// Make sure that any assigns in the two expressions don't dup
								(yyvsp[-6].m_pParseNode)->NoDup();
								(yyvsp[-2].m_pParseNode)->NoDup();
							;}
    break;

  case 93:

    {
								(yyval.m_pParseNode)=new CqParseNodeSolarConstruct();
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								(yyval.m_pParseNode)->AddLastChild((yyvsp[0].m_pParseNode));
							;}
    break;

  case 94:

    {
								(yyval.m_pParseNode)=new CqParseNodeSolarConstruct(TqTrue);
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								CqParseNode* pArg=new CqParseNode();
								pArg->SetPos(ParseLineNumber,ParseStreamName.c_str());
								pArg->AddFirstChild((yyvsp[-4].m_pParseNode));
								pArg->AddFirstChild((yyvsp[-2].m_pParseNode));
								(yyval.m_pParseNode)->AddLastChild(pArg);
								(yyval.m_pParseNode)->AddLastChild((yyvsp[0].m_pParseNode));
								// Make sure that any assigns in the two expressions don't dup
								(yyvsp[-4].m_pParseNode)->NoDup();
								(yyvsp[-2].m_pParseNode)->NoDup();
							;}
    break;

  case 95:

    {
								(yyval.m_pParseNode)=new CqParseNodeIlluminateConstruct();
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								(yyval.m_pParseNode)->AddLastChild((yyvsp[-2].m_pParseNode));
								(yyval.m_pParseNode)->AddLastChild((yyvsp[0].m_pParseNode));
								// Make sure that any assigns in the two expressions don't dup
								(yyvsp[-2].m_pParseNode)->NoDup();
							;}
    break;

  case 96:

    {
								(yyval.m_pParseNode)=new CqParseNodeIlluminateConstruct(TqTrue);
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								CqParseNode* pArg=new CqParseNode();
								pArg->SetPos(ParseLineNumber,ParseStreamName.c_str());
								pArg->AddFirstChild((yyvsp[-6].m_pParseNode));
								pArg->AddFirstChild((yyvsp[-4].m_pParseNode));
								pArg->AddFirstChild((yyvsp[-2].m_pParseNode));
								(yyval.m_pParseNode)->AddLastChild(pArg);
								(yyval.m_pParseNode)->AddLastChild((yyvsp[0].m_pParseNode));
								// Make sure that any assigns in the two expressions don't dup
								(yyvsp[-6].m_pParseNode)->NoDup();
								(yyvsp[-4].m_pParseNode)->NoDup();
								(yyvsp[-2].m_pParseNode)->NoDup();
							;}
    break;

  case 97:

    {
								(yyval.m_pParseNode)=new CqParseNodeIlluminanceConstruct();
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								CqParseNode* pArg=new CqParseNode();
								pArg->SetPos(ParseLineNumber,ParseStreamName.c_str());
								pArg->AddFirstChild(new CqParseNodeStringConst(""));	// [category]
								pArg->AddFirstChild((yyvsp[-2].m_pParseNode));
								(yyval.m_pParseNode)->AddLastChild(pArg);
								(yyval.m_pParseNode)->AddLastChild((yyvsp[0].m_pParseNode));
								// Make sure that any assigns in the two expressions don't dup
								(yyvsp[-2].m_pParseNode)->NoDup();
							;}
    break;

  case 98:

    {
								(yyval.m_pParseNode)=new CqParseNodeIlluminanceConstruct();
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								CqParseNode* pArg=new CqParseNode();
								pArg->SetPos(ParseLineNumber,ParseStreamName.c_str());
								pArg->AddFirstChild((yyvsp[-4].m_pParseNode));
								pArg->AddFirstChild((yyvsp[-2].m_pParseNode));
								(yyval.m_pParseNode)->AddLastChild(pArg);
								(yyval.m_pParseNode)->AddLastChild((yyvsp[0].m_pParseNode));
								// Make sure that any assigns in the two expressions don't dup
								(yyvsp[-4].m_pParseNode)->NoDup();
								(yyvsp[-2].m_pParseNode)->NoDup();
							;}
    break;

  case 99:

    {
								(yyval.m_pParseNode)=new CqParseNodeIlluminanceConstruct(TqTrue);
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								CqParseNode* pArg=new CqParseNode();
								pArg->SetPos(ParseLineNumber,ParseStreamName.c_str());
								pArg->AddFirstChild(new CqParseNodeStringConst(""));	// [category]
								pArg->AddFirstChild((yyvsp[-6].m_pParseNode));
								pArg->AddFirstChild((yyvsp[-4].m_pParseNode));
								pArg->AddFirstChild((yyvsp[-2].m_pParseNode));
								(yyval.m_pParseNode)->AddLastChild(pArg);
								(yyval.m_pParseNode)->AddLastChild((yyvsp[0].m_pParseNode));
								// Make sure that any assigns in the two expressions don't dup
								(yyvsp[-6].m_pParseNode)->NoDup();
								(yyvsp[-4].m_pParseNode)->NoDup();
								(yyvsp[-2].m_pParseNode)->NoDup();
							;}
    break;

  case 100:

    {
								(yyval.m_pParseNode)=new CqParseNodeIlluminanceConstruct(TqTrue);
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								CqParseNode* pArg=new CqParseNode();
								pArg->SetPos(ParseLineNumber,ParseStreamName.c_str());
								pArg->AddFirstChild((yyvsp[-8].m_pParseNode));
								pArg->AddFirstChild((yyvsp[-6].m_pParseNode));
								pArg->AddFirstChild((yyvsp[-4].m_pParseNode));
								pArg->AddFirstChild((yyvsp[-2].m_pParseNode));
								(yyval.m_pParseNode)->AddLastChild(pArg);
								(yyval.m_pParseNode)->AddLastChild((yyvsp[0].m_pParseNode));
								// Make sure that any assigns in the two expressions don't dup
								(yyvsp[-8].m_pParseNode)->NoDup();
								(yyvsp[-6].m_pParseNode)->NoDup();
								(yyvsp[-4].m_pParseNode)->NoDup();
								(yyvsp[-2].m_pParseNode)->NoDup();
							;}
    break;

  case 103:

    {	
								(yyval.m_pParseNode)=new CqParseNode();	
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
							;}
    break;

  case 104:

    {
								(yyval.m_pParseNode)=new CqParseNode();	
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
							;}
    break;

  case 106:

    {
								std::vector<SqFuncRef> func;
								CqFuncDef::FindFunction("operator.", func);
								CqParseNodeFunctionCall* pFunc=new CqParseNodeFunctionCall(func);
								pFunc->SetPos(ParseLineNumber,ParseStreamName.c_str());
								pFunc->AddLastChild((yyvsp[-2].m_pParseNode));
								pFunc->AddLastChild((yyvsp[0].m_pParseNode));

								(yyval.m_pParseNode)=pFunc;
							;}
    break;

  case 107:

    {
								std::vector<SqFuncRef> func;
								CqFuncDef::FindFunction("operator/", func);
								CqParseNodeFunctionCall* pFunc=new CqParseNodeFunctionCall(func);
								pFunc->SetPos(ParseLineNumber,ParseStreamName.c_str());
								pFunc->AddLastChild((yyvsp[-2].m_pParseNode));
								pFunc->AddLastChild((yyvsp[0].m_pParseNode));

								(yyval.m_pParseNode)=pFunc;
							;}
    break;

  case 108:

    {
								std::vector<SqFuncRef> func;
								CqFuncDef::FindFunction("operator*", func);
								CqParseNodeFunctionCall* pFunc=new CqParseNodeFunctionCall(func);
								pFunc->SetPos(ParseLineNumber,ParseStreamName.c_str());
								pFunc->AddLastChild((yyvsp[-2].m_pParseNode));
								pFunc->AddLastChild((yyvsp[0].m_pParseNode));

								(yyval.m_pParseNode)=pFunc;
							;}
    break;

  case 109:

    {
								std::vector<SqFuncRef> func;
								CqFuncDef::FindFunction("operator^", func);
								CqParseNodeFunctionCall* pFunc=new CqParseNodeFunctionCall(func);
								pFunc->SetPos(ParseLineNumber,ParseStreamName.c_str());
								pFunc->AddLastChild((yyvsp[-2].m_pParseNode));
								pFunc->AddLastChild((yyvsp[0].m_pParseNode));

								(yyval.m_pParseNode)=pFunc;
							;}
    break;

  case 110:

    {
								std::vector<SqFuncRef> func;
								CqFuncDef::FindFunction("operator+", func);
								CqParseNodeFunctionCall* pFunc=new CqParseNodeFunctionCall(func);
								pFunc->SetPos(ParseLineNumber,ParseStreamName.c_str());
								pFunc->AddLastChild((yyvsp[-2].m_pParseNode));
								pFunc->AddLastChild((yyvsp[0].m_pParseNode));

								(yyval.m_pParseNode)=pFunc;
							;}
    break;

  case 111:

    {
								std::vector<SqFuncRef> func;
								CqFuncDef::FindFunction("operator-", func);
								CqParseNodeFunctionCall* pFunc=new CqParseNodeFunctionCall(func);
								pFunc->SetPos(ParseLineNumber,ParseStreamName.c_str());
								pFunc->AddLastChild((yyvsp[-2].m_pParseNode));
								pFunc->AddLastChild((yyvsp[0].m_pParseNode));

								(yyval.m_pParseNode)=pFunc;
							;}
    break;

  case 112:

    {
								std::vector<SqFuncRef> func;
								CqFuncDef::FindFunction("operatorneg", func);
								CqParseNodeFunctionCall* pFunc=new CqParseNodeFunctionCall(func);
								pFunc->SetPos(ParseLineNumber,ParseStreamName.c_str());
								pFunc->AddFirstChild((yyvsp[0].m_pParseNode));

								(yyval.m_pParseNode)=pFunc;
							;}
    break;

  case 114:

    {
								CqParseNode* pNew=new CqParseNodeQCond();
								pNew->SetPos(ParseLineNumber,ParseStreamName.c_str());
								pNew->AddLastChild((yyvsp[-4].m_pParseNode));
								pNew->AddLastChild((yyvsp[-2].m_pParseNode));
								pNew->AddLastChild((yyvsp[0].m_pParseNode));
								(yyval.m_pParseNode)=pNew;
							;}
    break;

  case 115:

    {
								(yyval.m_pParseNode)=new CqParseNode();
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								CqParseNode* pCast=new CqParseNodeCast((yyvsp[-1].m_TypeAndSpace).Type);
								pCast->SetPos(ParseLineNumber,ParseStreamName.c_str());
								pCast->AddFirstChild((yyvsp[0].m_pParseNode));
								
								TqInt Type=(TqInt)((yyvsp[-1].m_TypeAndSpace).Type&Type_Mask);
								CqString* pSpace=(yyvsp[-1].m_TypeAndSpace).Space;
								// Check if the type has a valid space associated
								if(pSpace!=0 && pSpace->compare("")!=0 && 
								  ((Type==Type_Point) ||
								   (Type==Type_Normal) ||
								   (Type==Type_Vector) ||
								   (Type==Type_Matrix) ||
								   (Type==Type_Color) ))
								{
									// Create a transform function.
									std::vector<SqFuncRef> funcTrans;
									CqString strTrans("transform");;
									if(Type==Type_Normal)	strTrans="ntransform";
									else if(Type==Type_Vector)	strTrans="vtransform";
									else if(Type==Type_Matrix)	strTrans="mtransform";
									else if(Type==Type_Color)	strTrans="ctransform";
									if(FindFunction(strTrans.c_str(), funcTrans))
									{
										(yyval.m_pParseNode)=new CqParseNodeFunctionCall(funcTrans);
										(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
									
										// And create a holder for the arguments.
										CqParseNode* pFromSpace=new CqParseNodeStringConst((*(yyvsp[-1].m_TypeAndSpace).Space).c_str());
										CqParseNode* pToSpace;
										if(Type != Type_Color)	pToSpace = new CqParseNodeStringConst("current");
										else					pToSpace = new CqParseNodeStringConst("rgb");
										(yyval.m_pParseNode)->AddLastChild(pFromSpace);
										(yyval.m_pParseNode)->AddLastChild(pToSpace);
										(yyval.m_pParseNode)->AddLastChild(pCast);
									}
								}
								else
									(yyval.m_pParseNode)->AddFirstChild(pCast);
							;}
    break;

  case 116:

    {	
								(yyval.m_pParseNode)=new CqParseNodeFloatConst((yyvsp[0].m_FloatConst));
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
							;}
    break;

  case 118:

    {
								(yyval.m_pParseNode)=new CqParseNodeVariable((yyvsp[0].m_pSymbol).VarRef);	
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
							;}
    break;

  case 119:

    {
								(yyval.m_pParseNode)=new CqParseNodeVariable((yyvsp[0].m_pSymbol).VarRef);	
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
							;}
    break;

  case 120:

    {
								(yyval.m_pParseNode)=new CqParseNodeVariableArray((yyvsp[-3].m_pSymbol).VarRef);
								(yyval.m_pParseNode)->AddLastChild((yyvsp[-1].m_pParseNode));
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
							;}
    break;

  case 121:

    {
								(yyval.m_pParseNode)=new CqParseNodeStringConst((yyvsp[0].m_Identifier)->c_str());
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
							;}
    break;

  case 126:

    {	
								(yyval.m_pParseNode)=(yyvsp[-1].m_pParseNode);
							;}
    break;

  case 127:

    {
								(yyval.m_pParseNode)=new CqParseNodeTriple();
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								(yyval.m_pParseNode)->AddLastChild((yyvsp[-5].m_pParseNode));
								(yyval.m_pParseNode)->AddLastChild((yyvsp[-3].m_pParseNode));
								(yyval.m_pParseNode)->AddLastChild((yyvsp[-1].m_pParseNode));
							;}
    break;

  case 128:

    {
								(yyval.m_pParseNode)=new CqParseNodeHexTuple();
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								(yyval.m_pParseNode)->AddLastChild((yyvsp[-31].m_pParseNode));
								(yyval.m_pParseNode)->AddLastChild((yyvsp[-29].m_pParseNode));
								(yyval.m_pParseNode)->AddLastChild((yyvsp[-27].m_pParseNode));
								(yyval.m_pParseNode)->AddLastChild((yyvsp[-25].m_pParseNode));
								(yyval.m_pParseNode)->AddLastChild((yyvsp[-23].m_pParseNode));
								(yyval.m_pParseNode)->AddLastChild((yyvsp[-21].m_pParseNode));
								(yyval.m_pParseNode)->AddLastChild((yyvsp[-19].m_pParseNode));
								(yyval.m_pParseNode)->AddLastChild((yyvsp[-17].m_pParseNode));
								(yyval.m_pParseNode)->AddLastChild((yyvsp[-15].m_pParseNode));
								(yyval.m_pParseNode)->AddLastChild((yyvsp[-13].m_pParseNode));
								(yyval.m_pParseNode)->AddLastChild((yyvsp[-11].m_pParseNode));
								(yyval.m_pParseNode)->AddLastChild((yyvsp[-9].m_pParseNode));
								(yyval.m_pParseNode)->AddLastChild((yyvsp[-7].m_pParseNode));
								(yyval.m_pParseNode)->AddLastChild((yyvsp[-5].m_pParseNode));
								(yyval.m_pParseNode)->AddLastChild((yyvsp[-3].m_pParseNode));
								(yyval.m_pParseNode)->AddLastChild((yyvsp[-1].m_pParseNode));
							;}
    break;

  case 129:

    {	(yyval.m_pParseNode)=new CqParseNodeRelOp(Op_G);	;}
    break;

  case 130:

    {	(yyval.m_pParseNode)=new CqParseNodeRelOp(Op_GE);	;}
    break;

  case 131:

    {	(yyval.m_pParseNode)=new CqParseNodeRelOp(Op_L);	;}
    break;

  case 132:

    {	(yyval.m_pParseNode)=new CqParseNodeRelOp(Op_LE);	;}
    break;

  case 133:

    {	(yyval.m_pParseNode)=new CqParseNodeRelOp(Op_EQ);	;}
    break;

  case 134:

    {	(yyval.m_pParseNode)=new CqParseNodeRelOp(Op_NE);	;}
    break;

  case 135:

    {
								(yyval.m_pParseNode)=(yyvsp[-1].m_pParseNode);
							;}
    break;

  case 136:

    {
								(yyval.m_pParseNode)=(yyvsp[-1].m_pParseNode);
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								(yyval.m_pParseNode)->AddFirstChild((yyvsp[-2].m_pParseNode));
								(yyval.m_pParseNode)->AddFirstChild((yyvsp[0].m_pParseNode));
							;}
    break;

  case 137:

    {
								(yyval.m_pParseNode)=new CqParseNodeLogicalOp(Op_LogAnd);
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								(yyval.m_pParseNode)->AddFirstChild((yyvsp[-2].m_pParseNode));
								(yyval.m_pParseNode)->AddLastChild((yyvsp[0].m_pParseNode));
							;}
    break;

  case 138:

    {
								(yyval.m_pParseNode)=new CqParseNodeLogicalOp(Op_LogOr);
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								(yyval.m_pParseNode)->AddFirstChild((yyvsp[-2].m_pParseNode));
								(yyval.m_pParseNode)->AddLastChild((yyvsp[0].m_pParseNode));
							;}
    break;

  case 139:

    {
								(yyval.m_pParseNode)=new CqParseNodeUnaryOp(Op_LogicalNot);
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								(yyval.m_pParseNode)->AddLastChild((yyvsp[0].m_pParseNode));
							;}
    break;

  case 140:

    {
								(yyval.m_pParseNode)=new CqParseNodeAssign((yyvsp[-2].m_pSymbol).VarRef);
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								(yyval.m_pParseNode)->AddLastChild((yyvsp[0].m_pParseNode));
							;}
    break;

  case 141:

    {
								(yyval.m_pParseNode)=new CqParseNodeAssign((yyvsp[-2].m_pSymbol).VarRef);
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								
								std::vector<SqFuncRef> func;
								CqFuncDef::FindFunction("operator+", func);
								CqParseNodeFunctionCall* pFunc=new CqParseNodeFunctionCall(func);
								pFunc->SetPos(ParseLineNumber,ParseStreamName.c_str());
								pFunc->AddLastChild(new CqParseNodeVariable((yyvsp[-2].m_pSymbol).VarRef));
								pFunc->AddLastChild((yyvsp[0].m_pParseNode));

								(yyval.m_pParseNode)->AddLastChild(pFunc);
							;}
    break;

  case 142:

    {
								(yyval.m_pParseNode)=new CqParseNodeAssign((yyvsp[-2].m_pSymbol).VarRef);
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								
								std::vector<SqFuncRef> func;
								CqFuncDef::FindFunction("operator-", func);
								CqParseNodeFunctionCall* pFunc=new CqParseNodeFunctionCall(func);
								pFunc->SetPos(ParseLineNumber,ParseStreamName.c_str());
								pFunc->AddLastChild(new CqParseNodeVariable((yyvsp[-2].m_pSymbol).VarRef));
								pFunc->AddLastChild((yyvsp[0].m_pParseNode));

								(yyval.m_pParseNode)->AddLastChild(pFunc);
							;}
    break;

  case 143:

    {
								(yyval.m_pParseNode)=new CqParseNodeAssign((yyvsp[-2].m_pSymbol).VarRef);
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								
								std::vector<SqFuncRef> func;
								CqFuncDef::FindFunction("operator*", func);
								CqParseNodeFunctionCall* pFunc=new CqParseNodeFunctionCall(func);
								pFunc->SetPos(ParseLineNumber,ParseStreamName.c_str());
								pFunc->AddLastChild(new CqParseNodeVariable((yyvsp[-2].m_pSymbol).VarRef));
								pFunc->AddLastChild((yyvsp[0].m_pParseNode));

								(yyval.m_pParseNode)->AddLastChild(pFunc);
							;}
    break;

  case 144:

    {
								(yyval.m_pParseNode)=new CqParseNodeAssign((yyvsp[-2].m_pSymbol).VarRef);
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								
								std::vector<SqFuncRef> func;
								CqFuncDef::FindFunction("operator/", func);
								CqParseNodeFunctionCall* pFunc=new CqParseNodeFunctionCall(func);
								pFunc->SetPos(ParseLineNumber,ParseStreamName.c_str());
								pFunc->AddLastChild(new CqParseNodeVariable((yyvsp[-2].m_pSymbol).VarRef));
								pFunc->AddLastChild((yyvsp[0].m_pParseNode));

								(yyval.m_pParseNode)->AddLastChild(pFunc);
							;}
    break;

  case 145:

    {
								(yyval.m_pParseNode)=new CqParseNodeAssignArray((yyvsp[-5].m_pSymbol).VarRef);
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								(yyval.m_pParseNode)->AddLastChild((yyvsp[0].m_pParseNode));
								(yyval.m_pParseNode)->AddLastChild((yyvsp[-3].m_pParseNode));
							;}
    break;

  case 146:

    {
								(yyval.m_pParseNode)=new CqParseNodeAssignArray((yyvsp[-5].m_pSymbol).VarRef);
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								
								std::vector<SqFuncRef> func;
								CqFuncDef::FindFunction("operator+", func);
								CqParseNodeFunctionCall* pFunc=new CqParseNodeFunctionCall(func);
								pFunc->SetPos(ParseLineNumber,ParseStreamName.c_str());
								CqParseNodeVariableArray* pVar=new CqParseNodeVariableArray((yyvsp[-5].m_pSymbol).VarRef);
								pVar->AddLastChild((yyvsp[-3].m_pParseNode)->Clone());
								pFunc->AddLastChild(pVar);

								pFunc->AddLastChild((yyvsp[0].m_pParseNode));

								(yyval.m_pParseNode)->AddLastChild(pFunc);
								(yyval.m_pParseNode)->AddLastChild((yyvsp[-3].m_pParseNode));
							;}
    break;

  case 147:

    {
								(yyval.m_pParseNode)=new CqParseNodeAssignArray((yyvsp[-5].m_pSymbol).VarRef);
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								
								std::vector<SqFuncRef> func;
								CqFuncDef::FindFunction("operator-", func);
								CqParseNodeFunctionCall* pFunc=new CqParseNodeFunctionCall(func);
								pFunc->SetPos(ParseLineNumber,ParseStreamName.c_str());
								CqParseNodeVariableArray* pVar=new CqParseNodeVariableArray((yyvsp[-5].m_pSymbol).VarRef);
								pVar->AddLastChild((yyvsp[-3].m_pParseNode)->Clone());
								pFunc->AddLastChild(pVar);

								pFunc->AddLastChild((yyvsp[0].m_pParseNode));

								(yyval.m_pParseNode)->AddLastChild(pFunc);
								(yyval.m_pParseNode)->AddLastChild((yyvsp[-3].m_pParseNode));
							;}
    break;

  case 148:

    {
								(yyval.m_pParseNode)=new CqParseNodeAssignArray((yyvsp[-5].m_pSymbol).VarRef);
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								
								std::vector<SqFuncRef> func;
								CqFuncDef::FindFunction("operator*", func);
								CqParseNodeFunctionCall* pFunc=new CqParseNodeFunctionCall(func);
								pFunc->SetPos(ParseLineNumber,ParseStreamName.c_str());
								CqParseNodeVariableArray* pVar=new CqParseNodeVariableArray((yyvsp[-5].m_pSymbol).VarRef);
								pVar->AddLastChild((yyvsp[-3].m_pParseNode)->Clone());
								pFunc->AddLastChild(pVar);

								pFunc->AddLastChild((yyvsp[0].m_pParseNode));

								(yyval.m_pParseNode)->AddLastChild(pFunc);
								(yyval.m_pParseNode)->AddLastChild((yyvsp[-3].m_pParseNode));
							;}
    break;

  case 149:

    {
								(yyval.m_pParseNode)=new CqParseNodeAssignArray((yyvsp[-5].m_pSymbol).VarRef);
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								
								std::vector<SqFuncRef> func;
								CqFuncDef::FindFunction("operator/", func);
								CqParseNodeFunctionCall* pFunc=new CqParseNodeFunctionCall(func);
								pFunc->SetPos(ParseLineNumber,ParseStreamName.c_str());
								CqParseNodeVariableArray* pVar=new CqParseNodeVariableArray((yyvsp[-5].m_pSymbol).VarRef);
								pVar->AddLastChild((yyvsp[-3].m_pParseNode)->Clone());
								pFunc->AddLastChild(pVar);

								pFunc->AddLastChild((yyvsp[0].m_pParseNode));

								(yyval.m_pParseNode)->AddLastChild(pFunc);
								(yyval.m_pParseNode)->AddLastChild((yyvsp[-3].m_pParseNode));
							;}
    break;

  case 150:

    {
								std::vector<SqFuncRef> func;
								CqFuncDef::FindFunction(CqFuncDef::GetFunctionPtr((yyvsp[-3].m_pSymbol).FuncRef)->strName(), func);
								CqParseNodeFunctionCall* pFunc=new CqParseNodeFunctionCall(func);
								pFunc->SetPos(ParseLineNumber,ParseStreamName.c_str());
								while((yyvsp[-1].m_pParseNode)->pFirstChild()!=0)	pFunc->AddLastChild((yyvsp[-1].m_pParseNode)->pFirstChild());

								(yyval.m_pParseNode)=pFunc;
							;}
    break;

  case 151:

    {
								std::vector<SqFuncRef> func;
								CqFuncDef::FindFunction(CqFuncDef::GetFunctionPtr((yyvsp[-2].m_pSymbol).FuncRef)->strName(), func);
								CqParseNodeFunctionCall* pFunc=new CqParseNodeFunctionCall(func);
								pFunc->SetPos(ParseLineNumber,ParseStreamName.c_str());

								(yyval.m_pParseNode)=pFunc;
							;}
    break;

  case 152:

    {
								Aqsis::log() << warning << "Unresolved function " << (yyvsp[-3].m_Identifier)->c_str() << " will be treated as a DSO at runtime" << std::endl;
								CqParseNode* pArgs=(yyvsp[-1].m_pParseNode);
								CqString strArgTypes("");
								if(pArgs)
								{
									CqParseNode* pArg=static_cast<CqParseNode*>(pArgs->pFirstChild());
									while(pArg)
									{
										strArgTypes+=CqParseNode::TypeIdentifier(pArg->ResType());
										pArg=static_cast<CqParseNode*>(pArg->pNext());
									}
								};

								CqFuncDef func_spec(Type_Nil,(yyvsp[-3].m_Identifier)->c_str(),"unresolved",strArgTypes.c_str(), (CqParseNode*)NULL, pArgs);
								CqParseNodeUnresolvedCall* pUFunc=new CqParseNodeUnresolvedCall(func_spec);
								pUFunc->SetPos(ParseLineNumber,ParseStreamName.c_str());
								while((yyvsp[-1].m_pParseNode)->pFirstChild()!=0)	pUFunc->AddLastChild((yyvsp[-1].m_pParseNode)->pFirstChild());

								(yyval.m_pParseNode)=pUFunc;
							;}
    break;

  case 153:

    {
								// Need to emit a warning.
								// This should in theory be the eaiest case to handle
								// since there are no arguments that might need casting
								// later.
								Aqsis::log() << warning << "Unresolved function " << (yyvsp[-2].m_Identifier)->c_str() << " will be treated as a DSO at runtime" << std::endl;
								CqFuncDef func_spec(Type_Nil, (yyvsp[-2].m_Identifier)->c_str(), "unresolved","");
								CqParseNodeUnresolvedCall* pUFunc=new CqParseNodeUnresolvedCall(func_spec);
								pUFunc->SetPos(ParseLineNumber,ParseStreamName.c_str());

								(yyval.m_pParseNode)=pUFunc;
							;}
    break;

  case 154:

    {
								// Create a list header, and add the first entry.
									(yyval.m_pParseNode)=new CqParseNode();
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								(yyval.m_pParseNode)->AddLastChild((yyvsp[0].m_pParseNode));
							;}
    break;

  case 155:

    {
								// Add this entry to the list.
								(yyval.m_pParseNode)->AddLastChild((yyvsp[0].m_pParseNode));
							;}
    break;

  case 156:

    {	
								// Add the texture_filename as the first argument
								(yyval.m_pParseNode)->AddFirstChild((yyvsp[-3].m_pParseNode));
								(yyval.m_pParseNode)->AddLastChild((yyvsp[-2].m_pParseNode));
								// Add all texture_arguments as further arguments to the function.
								CqParseNode* pParam=(yyvsp[-1].m_pParseNode)->pFirstChild();
								while(pParam!=0)
								{
									CqParseNode* pTemp=pParam->pNext();
									(yyval.m_pParseNode)->AddLastChild(pParam);
									pParam=pTemp;
								}
							;}
    break;

  case 157:

    {	
								// Add the texture_filename as the first argument
								(yyval.m_pParseNode)->AddFirstChild((yyvsp[-2].m_pParseNode));
								(yyval.m_pParseNode)->AddLastChild(new CqParseNodeFloatConst(0));
								// Add all texture_arguments as further arguments to the function.
								CqParseNode* pParam=(yyvsp[-1].m_pParseNode)->pFirstChild();
								while(pParam!=0)
								{
									CqParseNode* pTemp=pParam->pNext();
									(yyval.m_pParseNode)->AddLastChild(pParam);
									pParam=pTemp;
								}
							;}
    break;

  case 158:

    {	
								// Add the texture_filename as the first argument
								(yyval.m_pParseNode)->AddFirstChild((yyvsp[-2].m_pParseNode));
								(yyval.m_pParseNode)->AddLastChild((yyvsp[-1].m_pParseNode));
							;}
    break;

  case 159:

    {	
								// Add the texture_filename as the first argument
								(yyval.m_pParseNode)->AddFirstChild((yyvsp[-1].m_pParseNode));
								(yyval.m_pParseNode)->AddLastChild(new CqParseNodeFloatConst(0));
							;}
    break;

  case 160:

    {
								std::vector<SqFuncRef> func;
								CqFuncDef::FindFunction("texture", func);
								(yyval.m_pParseNode)=new CqParseNodeFunctionCall(func);
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
							;}
    break;

  case 161:

    {
								std::vector<SqFuncRef> func;
								CqFuncDef::FindFunction("environment", func);
								(yyval.m_pParseNode)=new CqParseNodeFunctionCall(func);
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
							;}
    break;

  case 162:

    {
								std::vector<SqFuncRef> func;
								CqFuncDef::FindFunction("bump", func);
								(yyval.m_pParseNode)=new CqParseNodeFunctionCall(func);
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
							;}
    break;

  case 163:

    {
								std::vector<SqFuncRef> func;
								CqFuncDef::FindFunction("shadow", func);
								(yyval.m_pParseNode)=new CqParseNodeFunctionCall(func);
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
							;}
    break;

  case 164:

    {
								std::vector<SqFuncRef> func;
								CqFuncDef::FindFunction("occlusion", func);
								(yyval.m_pParseNode)=new CqParseNodeFunctionCall(func);
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
							;}
    break;

  case 165:

    {	
								(yyval.m_pParseNode)=(yyvsp[0].m_pParseNode);	
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
							;}
    break;

  case 166:

    {	(yyval.m_pParseNode)=(yyvsp[-1].m_pParseNode); ;}
    break;

  case 167:

    {
								// Create a list header and add the first entry.
								(yyval.m_pParseNode)=new CqParseNode();
								(yyval.m_pParseNode)->SetPos(ParseLineNumber,ParseStreamName.c_str());
								(yyval.m_pParseNode)->AddFirstChild((yyvsp[0].m_pParseNode));
							;}
    break;

  case 168:

    {
								// Add this entry to the list.
								(yyval.m_pParseNode)->AddLastChild((yyvsp[0].m_pParseNode));
							;}
    break;

  case 170:

    {(yyval.m_CommType)=CommTypeAtmosphere;;}
    break;

  case 171:

    {(yyval.m_CommType)=CommTypeDisplacement;;}
    break;

  case 172:

    {(yyval.m_CommType)=CommTypeLightsource;;}
    break;

  case 173:

    {(yyval.m_CommType)=CommTypeSurface;;}
    break;

  case 174:

    {(yyval.m_CommType)=CommTypeAttribute;;}
    break;

  case 175:

    {(yyval.m_CommType)=CommTypeOption;;}
    break;

  case 176:

    {(yyval.m_CommType)=CommTypeRendererInfo;;}
    break;

  case 177:

    {(yyval.m_CommType)=CommTypeIncident;;}
    break;

  case 178:

    {(yyval.m_CommType)=CommTypeOpposite;;}
    break;

  case 179:

    {(yyval.m_CommType)=CommTypeTextureInfo;;}
    break;

  case 180:

    {
								CqVarDef* pVD=0;
								TqBool fError=TqFalse;
								
								if(((yyvsp[-3].m_pParseNode)->ResType()&Type_Mask)!=Type_String)	fError=TqTrue;

								// Get the variable, error if not a variable.
								if((yyvsp[-1].m_pSymbol).eType&1)	pVD=CqVarDef::GetVariablePtr((yyvsp[-1].m_pSymbol).VarRef);
								
								if(pVD!=0 && !fError)
								{
									(yyval.m_pParseNode)=new CqParseNodeCommFunction((yyvsp[-5].m_CommType), (yyvsp[-1].m_pSymbol).VarRef);
									(yyval.m_pParseNode)->AddLastChild((yyvsp[-3].m_pParseNode));
								}
								else
								{
									yyerror("invalid variable reference");
									(yyval.m_pParseNode)=new CqParseNode();
								}
							;}
    break;

  case 181:

    {
								CqVarDef* pVD=0;
								TqBool fError=TqFalse;
								
                                if(((yyvsp[-5].m_pParseNode)->ResType()&Type_Mask)!=Type_String)	fError=TqTrue;

							    if(((yyvsp[-3].m_pParseNode)->ResType()&Type_Mask)!=Type_String)	fError=TqTrue;

								// Get the variable, error if not a variable.
								if((yyvsp[-1].m_pSymbol).eType&1)	pVD=CqVarDef::GetVariablePtr((yyvsp[-1].m_pSymbol).VarRef);
								
								if(pVD!=0 && !fError)
								{
									(yyval.m_pParseNode)=new CqParseNodeCommFunction((yyvsp[-7].m_CommType), (yyvsp[-1].m_pSymbol).VarRef);
								    (yyval.m_pParseNode)->AddLastChild((yyvsp[-3].m_pParseNode));
								    (yyval.m_pParseNode)->AddLastChild((yyvsp[-5].m_pParseNode));
								}
								else
								{
									yyerror("invalid variable reference");
									(yyval.m_pParseNode)=new CqParseNode();
								}
							;}
    break;

  case 182:

    {
								CqVarDef* pVD=0;
								TqBool fError=TqFalse;
								
								if(((yyvsp[-3].m_pParseNode)->ResType()&Type_Mask)!=Type_String)	fError=TqTrue;

								// Get the variable, error if not a variable.
								if((yyvsp[-1].m_pSymbol).eType&1)	pVD=CqVarDef::GetVariablePtr((yyvsp[-1].m_pSymbol).VarRef);
								
								if(pVD!=0 && !fError)
								{
									(yyval.m_pParseNode)=new CqParseNodeCommFunction((yyvsp[-5].m_CommType), (yyvsp[-1].m_pSymbol).VarRef);
									(yyval.m_pParseNode)->AddLastChild((yyvsp[-3].m_pParseNode));
								}
								else
								{
									yyerror("invalid variable reference");
									(yyval.m_pParseNode)=new CqParseNode();
								}
							;}
    break;

  case 183:

    {
								CqVarDef* pVD=0;
								TqBool fError=TqFalse;
								
                                if(((yyvsp[-5].m_pParseNode)->ResType()&Type_Mask)!=Type_String)	fError=TqTrue;

							    if(((yyvsp[-3].m_pParseNode)->ResType()&Type_Mask)!=Type_String)	fError=TqTrue;

								// Get the variable, error if not a variable.
								if((yyvsp[-1].m_pSymbol).eType&1)	pVD=CqVarDef::GetVariablePtr((yyvsp[-1].m_pSymbol).VarRef);
								
								if(pVD!=0 && !fError)
								{
									(yyval.m_pParseNode)=new CqParseNodeCommFunction((yyvsp[-7].m_CommType), (yyvsp[-1].m_pSymbol).VarRef);
								    (yyval.m_pParseNode)->AddLastChild((yyvsp[-3].m_pParseNode));
								    (yyval.m_pParseNode)->AddLastChild((yyvsp[-5].m_pParseNode));
								}
								else
								{
									yyerror("invalid variable reference");
									(yyval.m_pParseNode)=new CqParseNode();
								}
							;}
    break;


      default: break;
    }

/* Line 1126 of yacc.c.  */


  yyvsp -= yylen;
  yyssp -= yylen;


  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (YYPACT_NINF < yyn && yyn < YYLAST)
	{
	  int yytype = YYTRANSLATE (yychar);
	  YYSIZE_T yysize0 = yytnamerr (0, yytname[yytype]);
	  YYSIZE_T yysize = yysize0;
	  YYSIZE_T yysize1;
	  int yysize_overflow = 0;
	  char *yymsg = 0;
#	  define YYERROR_VERBOSE_ARGS_MAXIMUM 5
	  char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
	  int yyx;

#if 0
	  /* This is so xgettext sees the translatable formats that are
	     constructed on the fly.  */
	  YY_("syntax error, unexpected %s");
	  YY_("syntax error, unexpected %s, expecting %s");
	  YY_("syntax error, unexpected %s, expecting %s or %s");
	  YY_("syntax error, unexpected %s, expecting %s or %s or %s");
	  YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s");
#endif
	  char *yyfmt;
	  char const *yyf;
	  static char const yyunexpected[] = "syntax error, unexpected %s";
	  static char const yyexpecting[] = ", expecting %s";
	  static char const yyor[] = " or %s";
	  char yyformat[sizeof yyunexpected
			+ sizeof yyexpecting - 1
			+ ((YYERROR_VERBOSE_ARGS_MAXIMUM - 2)
			   * (sizeof yyor - 1))];
	  char const *yyprefix = yyexpecting;

	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  int yyxbegin = yyn < 0 ? -yyn : 0;

	  /* Stay within bounds of both yycheck and yytname.  */
	  int yychecklim = YYLAST - yyn;
	  int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
	  int yycount = 1;

	  yyarg[0] = yytname[yytype];
	  yyfmt = yystpcpy (yyformat, yyunexpected);

	  for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	      {
		if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
		  {
		    yycount = 1;
		    yysize = yysize0;
		    yyformat[sizeof yyunexpected - 1] = '\0';
		    break;
		  }
		yyarg[yycount++] = yytname[yyx];
		yysize1 = yysize + yytnamerr (0, yytname[yyx]);
		yysize_overflow |= yysize1 < yysize;
		yysize = yysize1;
		yyfmt = yystpcpy (yyfmt, yyprefix);
		yyprefix = yyor;
	      }

	  yyf = YY_(yyformat);
	  yysize1 = yysize + yystrlen (yyf);
	  yysize_overflow |= yysize1 < yysize;
	  yysize = yysize1;

	  if (!yysize_overflow && yysize <= YYSTACK_ALLOC_MAXIMUM)
	    yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg)
	    {
	      /* Avoid sprintf, as that infringes on the user's name space.
		 Don't have undefined behavior even if the translation
		 produced a string with the wrong number of "%s"s.  */
	      char *yyp = yymsg;
	      int yyi = 0;
	      while ((*yyp = *yyf))
		{
		  if (*yyp == '%' && yyf[1] == 's' && yyi < yycount)
		    {
		      yyp += yytnamerr (yyp, yyarg[yyi++]);
		      yyf += 2;
		    }
		  else
		    {
		      yyp++;
		      yyf++;
		    }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    {
	      yyerror (YY_("syntax error"));
	      goto yyexhaustedlab;
	    }
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror (YY_("syntax error"));
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse look-ahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
        {
	  /* Return failure if at end of input.  */
	  if (yychar == YYEOF)
	    YYABORT;
        }
      else
	{
	  yydestruct ("Error: discarding", yytoken, &yylval);
	  yychar = YYEMPTY;
	}
    }

  /* Else will try to reuse look-ahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (0)
     goto yyerrorlab;

yyvsp -= yylen;
  yyssp -= yylen;
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;


      yydestruct ("Error: popping", yystos[yystate], yyvsp);
      YYPOPSTACK;
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  *++yyvsp = yylval;


  /* Shift the error token. */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEOF && yychar != YYEMPTY)
     yydestruct ("Cleanup: discarding lookahead",
		 yytoken, &yylval);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
		  yystos[*yyssp], yyvsp);
      YYPOPSTACK;
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}





namespace Aqsis
{

TqBool FindVariable(const char* name, SqVarRef& Ref)
{
	// First search in the current namespace, then in the global namespace.
	CqString strLocalVar(strNameSpace()+name);
	
	if(CqVarDef::FindVariable(strLocalVar.c_str(), Ref))	return(TqTrue);
	else	return(CqVarDef::FindVariable(name, Ref));

	
}


TqBool FindFunction(const char* name, std::vector<SqFuncRef>& Ref)
{
	// Search in the namespaces from local to global in order.
	CqString strNS(strNameSpace());
	
	do
	{
		CqString strLocalFunc(strNS+name);
		if(CqFuncDef::FindFunction(strLocalFunc.c_str(), Ref))
			return(TqTrue);

		// Extract the next namespace up.
		if( ( strNS.size() > 2 ) && ( strNS.substr( strNS.size()-2 ) == "::" ) )
		{
			strNS = strNS.substr( 0, strNS.size()-2 );
			strNS = strNS.substr(0, strNS.rfind("::")+strlen("::"));
		}

	}while( strNS.find_last_of("::") != std::string::npos );
	
	return(CqFuncDef::FindFunction(name, Ref));
}


void TypeCheck()
{
	// Typecheck any declared variables.
	TqUint i;
	for(i=0; i<gLocalVars.size(); i++)
	{
		TqBool needsCast = TqFalse;
		if(gLocalVars[i].pDefValue()!=0)
			gLocalVars[i].pDefValue()->TypeCheck(CqParseNode::pAllTypes(), Type_Last-1, needsCast, TqFalse);
	}

	// Typecheck any local functions.
	for(i=0; i<gLocalFuncs.size(); i++)
	{
		if(gLocalFuncs[i].pDef()!=0)
		{
			TqBool needsCast = TqFalse;
//			TqInt RetType=gLocalFuncs[i].Type();
			gLocalFuncs[i].pDefNode()->TypeCheck(CqParseNode::pAllTypes(), Type_Last-1, needsCast, TqFalse);
		}
	}

	TqBool needsCast = TqFalse;
	if(ParseTreePointer)
		ParseTreePointer->TypeCheck(CqParseNode::pAllTypes(), Type_Last-1, needsCast, TqFalse);
}


void Optimise()
{
	// Optimise any local functions.
	TqUint i;
	for(i=0; i<gLocalFuncs.size(); i++)
	{
		if(gLocalFuncs[i].pDef()!=0)
			gLocalFuncs[i].pDefNode()->Optimise();
	}

	if(ParseTreePointer)
		ParseTreePointer->Optimise();
}


CqString strNameSpace()	
{
	CqString strRes("");

	if(!ParseNameSpaceStack.empty())
		strRes=ParseNameSpaceStack.back().second;

	return(strRes);
}

void pushScope(CqString name, TqBool terminal)
{
	std::pair<TqBool,CqString> n;
	n.first = terminal;
	n.second = strNameSpace()+name+"::";
	ParseNameSpaceStack.push_back(n);
}

CqString popScope()
{
	CqString old = ParseNameSpaceStack.back().second;
	ParseNameSpaceStack.erase(ParseNameSpaceStack.end()-1);
	return old;
}

void InitStandardNamespace()
{
	std::pair<TqBool,CqString> n;
	n.first = TqFalse;
	n.second = "";
	ParseNameSpaceStack.push_back(n);
}

void ProcessShaderArguments( CqParseNode* pArgs )
{
	if(pArgs)
	{
		// Each child of the variable_definitions is a CqParseNodeVariable
		CqParseNodeVariable* pVar=static_cast<CqParseNodeVariable*>(pArgs->pFirstChild());

		while(pVar)
		{
			// If storage is not specified, a shader parameter defaults to uniform.
			pVar->SetDefaultStorage(Type_Uniform);
			// Force the variable to be a parameter.
			pVar->SetParam();

			// Check if a default value has been specified.
			CqParseNode* pDefValue=pVar->pFirstChild();
			if(pDefValue!=0)
			{
				// Get a pointer to the local variable.
				CqVarDef* pVarDef=CqVarDef::GetVariablePtr(pVar->VarRef());
				if(pVarDef!=0)
				{
					CqParseNode Node;
					pDefValue->UnLink();
					CqParseNodeCast* pCast=new CqParseNodeCast(pVarDef->Type());
					Node.AddLastChild(pCast);
					pCast->AddLastChild(pDefValue);
					Node.Optimise();
					pVarDef->SetpDefValue(Node.pFirstChild());
					pVar->AddFirstChild( Node.pFirstChild() );
				}
			}
			pVar=static_cast<CqParseNodeVariable*>(pVar->pNext());
		}
	}
}


} // End Namespace

static void yyerror(const CqString Message)
{
	ParseSucceeded = false;
	//(*ParseErrorStream) << "libslparse > parser > error: " << Message.c_str() << " at " << ParseStreamName.c_str() << " line " << ParseLineNumber << std::endl;
	CqString strErr( ParseStreamName.c_str() );
	strErr += " : ";
	strErr += ParseLineNumber;
	strErr += " : ";
	strErr += Message.c_str();
	throw( strErr );
}

