/* whats-new.c:
 *
 ****************************************************************
 * Copyright (C) 2003 Tom Lord
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */


#include "hackerlab/bugs/panic.h"
#include "hackerlab/char/str.h"
#include "libarch/namespace.h"
#include "libarch/patch-logs.h"
#include "libarch/whats-new.h"



rel_table
arch_whats_new (t_uchar const * tree_root, struct arch_archive * arch, t_uchar const * version)
{
  t_uchar * latest_applied = 0;
  rel_table available = 0;
  rel_table answer = 0;
  int x;

  invariant (arch_valid_package_name (version, arch_no_archive, arch_req_version, 0));

  latest_applied = arch_highest_patch_level (tree_root, arch->official_name, version);

  available = arch_archive_revisions (arch, version, 0);

  for (x = 0; x < rel_n_records (available); ++x)
    {
      if (!str_cmp (latest_applied, available[x][0]))
        {
          ++x;
          break;
        }
    }

  while (x < rel_n_records (available))
    {
      rel_add_records (&answer, rel_make_record (available[x][0], 0), 0);
      ++x;
    }

  lim_free (0, latest_applied);
  rel_free_table (available);
  return answer;
}




/* tag: Tom Lord Thu Jun  5 00:53:51 2003 (whats-new.c)
 */
