"""
Report from a cobbler master.

Copyright 2007-2008, Red Hat, Inc
Anderson Silva <ansilva@redhat.com>


This software may be freely redistributed under the terms of the GNU
general public license.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
"""

import os
import os.path
import xmlrpclib
import api as cobbler_api
from utils import _


class Report:

    def __init__(self, config):
        """
        Constructor
        """
        self.config = config
        self.settings = config.settings()
        self.api = config.api
        self.remote = None
        self.uri = None

    def reporting_csv(self, info, order):
        """
        Formats data on 'info' for csv output
        """
        outputheaders = ''
        outputbody = ''
        sep = ','

        info_count = 0
        for item in info:

            item_count = 0
            for key in order:

                if info_count == 0:
                    outputheaders += str(key) + sep

                outputbody += str(item[key]) + sep

                item_count = item_count + 1

            info_count = info_count + 1
            outputbody += '\n'

        outputheaders += '\n'
        return outputheaders + outputbody

    def reporting_trac(self, info, order):
        """
        Formats data on 'info' for trac wiki table output
        """
        outputheaders = ''
        outputbody = ''
        sep = '||'

        info_count = 0
        for item in info:

            item_count = 0
            for key in order:

                if info_count == 0:
                    outputheaders += sep + str(key)

                outputbody += sep + str(item[key])

                item_count = item_count + 1

            info_count = info_count + 1
            outputbody += '||\n'

        outputheaders += '||\n'
        return outputheaders + outputbody

    def reporting_doku(self, info, order):
        """
        Formats data on 'info' for doku wiki table output
        """      
        outputheaders = ''
        outputbody = ''
        sep1 = '^'
        sep2 = '|'


        info_count = 0
        for item in info:
            
            item_count = 0
            for key in order:

                if info_count == 0:
                    outputheaders += sep1 + key

                outputbody += sep2 + item[key]

                item_count = item_count + 1

            info_count = info_count + 1
            outputbody += sep2 + '\n'

        outputheaders += sep1 + '\n'
        return outputheaders + outputbody

    
    def reporting_mediawiki(self, info, order):
        """
        Formats data on 'info' for mediawiki table output
        """
        outputheaders = ''
        outputbody = ''
        opentable = '{| border="1"\n'
        closetable = '|}\n'
        sep1 = '||'
        sep2 = '|'
        sep3 = '|-'


        info_count = 0
        for item in info:
            
            item_count = 0
            for key in order:

                if info_count == 0 and item_count == 0:
                    outputheaders += sep2 + key
                elif info_count == 0:
                    outputheaders += sep1 + key

                if item_count == 0:
                    outputbody += sep2 + item[key]
                else:
                    outputbody += sep1 + item[key]

                item_count = item_count + 1

            info_count = info_count + 1
            outputbody += '\n' + sep3 + '\n'

        outputheaders += '\n' + sep3 + '\n'
        return opentable + outputheaders + outputbody + closetable
    
    def print_formatted_data(self, data, order, report_type):
        """
        Used for picking the correct format to output data as
        """
        if report_type == "csv":
            print self.reporting_csv(data, order)
        if report_type == "mediawiki":
            print self.reporting_mediawiki(data, order)
        if report_type == "trac":
            print self.reporting_trac(data, order)
        if report_type == "doku":
            print self.reporting_doku(data, order)

        return True

    def reporting_sorter(self, a, b):
        """
        Used for sorting cobbler objects for report commands
        """
        return cmp(a.name, b.name)

    def reporting_print_sorted(self, collection):
        """
        Prints all objects in a collection sorted by name
        """
        collection = [x for x in collection]
        collection.sort(self.reporting_sorter)
        for x in collection:
            print x.printable()
        return True

    def reporting_list_names2(self, collection, name):
        """
        Prints a specific object in a collection.
        """
        obj = collection.find(name=name)
        if obj is not None:
            print obj.printable()
        return True
    
    def reporting_print_all_fields(self, collection, report_type):
        """
        Prints all fields in a collection as a table given the report type
        """
        collection = [x for x in collection]
        collection.sort(self.reporting_sorter)
        data = []
        for x in collection:
            structure = x.to_datastruct()
            data.append(structure)
                
        self.print_formatted_data(data = data, order = None, report_type = report_type)
        
        return True
    
    def reporting_print_x_fields(self, collection, report_type, report_fields):
        """
        Prints specific fields in a collection as a table given the report type
        """
        collection = [x for x in collection]
        collection.sort(self.reporting_sorter)
        data = []
        for x in collection:
            structure = x.to_datastruct()
            item = {}
            for field in report_fields:
                if field in structure.keys():
                    item[field] = structure[field]
            data.append(item)
            
        self.print_formatted_data(data = data, order = report_fields, report_type = report_type)
                        
        return True
        
    # -------------------------------------------------------

    def run(self, report_what = None, report_name = None, report_type = None, report_fields = None):
        """
        Get remote profiles and distros and sync them locally
        """
               
        """
        1. Handles original report output
        2. Handles all fields of report outputs as table given a format
        3. Handles specific fields of report outputs as table given a format
        """        
 
        if report_type is "text" and report_fields is "all":

            if report_what in [ "all", "distros" ]:
                if report_name:
                    self.reporting_list_names2(self.api.distros(), report_name)
                else:
                    self.reporting_print_sorted(self.api.distros())

            if report_what in [ "all", "profiles" ]:
                if report_name:
                    self.reporting_list_names2(self.api.profiles(), report_name)
                else:
                    self.reporting_print_sorted(self.api.profiles())

            if report_what in [ "all", "systems"  ]:
                if report_name:
                    self.reporting_list_names2(self.api.systems(), report_name)
                else:
                    self.reporting_print_sorted(self.api.systems())

            if report_what in [ "all", "repos"    ]:
                if report_name:
                    self.reporting_list_names2(self.api.repos(), report_name)
                else:
                    self.reporting_print_sorted(self.api.repos())
                    
        elif report_type is not "text" and report_fields is "all":
            
            if report_what in [ "all", "distros"  ]:
                self.reporting_print_all_fields(self.api.distros(), report_type)

            if report_what in [ "all", "profiles" ]:
                self.reporting_print_all_fields(self.api.profiles(), report_type)

            if report_what in [ "all", "systems"  ]:
                self.reporting_print_all_fields(self.api.systems(), report_type)

            if report_what in [ "all", "repos"    ]:
                self.reporting_print_all_fields(self.api.repos(), report_type) 
        
        else:
            
            if report_what in [ "all", "distros"  ]:
                self.reporting_print_x_fields(self.api.distros(), report_type, report_fields)

            if report_what in [ "all", "profiles" ]:
                self.reporting_print_x_fields(self.api.profiles(), report_type, report_fields)

            if report_what in [ "all", "systems"  ]:
                self.reporting_print_x_fields(self.api.systems(), report_type, report_fields)

            if report_what in [ "all", "repos"    ]:
                self.reporting_print_x_fields(self.api.repos(), report_type, report_fields)
"""
Report from a cobbler master.

Copyright 2007-2008, Red Hat, Inc
Anderson Silva <ansilva@redhat.com>


This software may be freely redistributed under the terms of the GNU
general public license.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
"""

import os
import os.path
import xmlrpclib
import api as cobbler_api
from utils import _


class Report:

    def __init__(self, config):
        """
        Constructor
        """
        self.config = config
        self.settings = config.settings()
        self.api = config.api
        self.remote = None
        self.uri = None

    def reporting_csv(self, info, order):
        """
        Formats data on 'info' for csv output
        """
        outputheaders = ''
        outputbody = ''
        sep = ','

        info_count = 0
        for item in info:

            item_count = 0
            for key in order:

                if info_count == 0:
                    outputheaders += str(key) + sep

                outputbody += str(item[key]) + sep

                item_count = item_count + 1

            info_count = info_count + 1
            outputbody += '\n'

        outputheaders += '\n'
        return outputheaders + outputbody

    def reporting_trac(self, info, order):
        """
        Formats data on 'info' for trac wiki table output
        """
        outputheaders = ''
        outputbody = ''
        sep = '||'

        info_count = 0
        for item in info:

            item_count = 0
            for key in order:

                if info_count == 0:
                    outputheaders += sep + str(key)

                outputbody += sep + str(item[key])

                item_count = item_count + 1

            info_count = info_count + 1
            outputbody += '||\n'

        outputheaders += '||\n'
        return outputheaders + outputbody

    def reporting_doku(self, info, order):
        """
        Formats data on 'info' for doku wiki table output
        """      
        outputheaders = ''
        outputbody = ''
        sep1 = '^'
        sep2 = '|'


        info_count = 0
        for item in info:
            
            item_count = 0
            for key in order:

                if info_count == 0:
                    outputheaders += sep1 + key

                outputbody += sep2 + item[key]

                item_count = item_count + 1

            info_count = info_count + 1
            outputbody += sep2 + '\n'

        outputheaders += sep1 + '\n'
        return outputheaders + outputbody

    
    def reporting_mediawiki(self, info, order):
        """
        Formats data on 'info' for mediawiki table output
        """
        outputheaders = ''
        outputbody = ''
        opentable = '{| border="1"\n'
        closetable = '|}\n'
        sep1 = '||'
        sep2 = '|'
        sep3 = '|-'


        info_count = 0
        for item in info:
            
            item_count = 0
            for key in order:

                if info_count == 0 and item_count == 0:
                    outputheaders += sep2 + key
                elif info_count == 0:
                    outputheaders += sep1 + key

                if item_count == 0:
                    outputbody += sep2 + item[key]
                else:
                    outputbody += sep1 + item[key]

                item_count = item_count + 1

            info_count = info_count + 1
            outputbody += '\n' + sep3 + '\n'

        outputheaders += '\n' + sep3 + '\n'
        return opentable + outputheaders + outputbody + closetable
    
    def print_formatted_data(self, data, order, report_type):
        """
        Used for picking the correct format to output data as
        """
        if report_type == "csv":
            print self.reporting_csv(data, order)
        if report_type == "mediawiki":
            print self.reporting_mediawiki(data, order)
        if report_type == "trac":
            print self.reporting_trac(data, order)
        if report_type == "doku":
            print self.reporting_doku(data, order)

        return True

    def reporting_sorter(self, a, b):
        """
        Used for sorting cobbler objects for report commands
        """
        return cmp(a.name, b.name)

    def reporting_print_sorted(self, collection):
        """
        Prints all objects in a collection sorted by name
        """
        collection = [x for x in collection]
        collection.sort(self.reporting_sorter)
        for x in collection:
            print x.printable()
        return True

    def reporting_list_names2(self, collection, name):
        """
        Prints a specific object in a collection.
        """
        obj = collection.find(name=name)
        if obj is not None:
            print obj.printable()
        return True
    
    def reporting_print_all_fields(self, collection, report_type):
        """
        Prints all fields in a collection as a table given the report type
        """
        collection = [x for x in collection]
        collection.sort(self.reporting_sorter)
        data = []
        for x in collection:
            structure = x.to_datastruct()
            data.append(structure)
                
        self.print_formatted_data(data = data, order = None, report_type = report_type)
        
        return True
    
    def reporting_print_x_fields(self, collection, report_type, report_fields):
        """
        Prints specific fields in a collection as a table given the report type
        """
        collection = [x for x in collection]
        collection.sort(self.reporting_sorter)
        data = []
        for x in collection:
            structure = x.to_datastruct()
            item = {}
            for field in report_fields:
                if field in structure.keys():
                    item[field] = structure[field]
            data.append(item)
            
        self.print_formatted_data(data = data, order = report_fields, report_type = report_type)
                        
        return True
        
    # -------------------------------------------------------

    def run(self, report_what = None, report_name = None, report_type = None, report_fields = None):
        """
        Get remote profiles and distros and sync them locally
        """
               
        """
        1. Handles original report output
        2. Handles all fields of report outputs as table given a format
        3. Handles specific fields of report outputs as table given a format
        """        
 
        if report_type is "text" and report_fields is "all":

            if report_what in [ "all", "distros" ]:
                if report_name:
                    self.reporting_list_names2(self.api.distros(), report_name)
                else:
                    self.reporting_print_sorted(self.api.distros())

            if report_what in [ "all", "profiles" ]:
                if report_name:
                    self.reporting_list_names2(self.api.profiles(), report_name)
                else:
                    self.reporting_print_sorted(self.api.profiles())

            if report_what in [ "all", "systems"  ]:
                if report_name:
                    self.reporting_list_names2(self.api.systems(), report_name)
                else:
                    self.reporting_print_sorted(self.api.systems())

            if report_what in [ "all", "repos"    ]:
                if report_name:
                    self.reporting_list_names2(self.api.repos(), report_name)
                else:
                    self.reporting_print_sorted(self.api.repos())
                    
        elif report_type is not "text" and report_fields is "all":
            
            if report_what in [ "all", "distros"  ]:
                self.reporting_print_all_fields(self.api.distros(), report_type)

            if report_what in [ "all", "profiles" ]:
                self.reporting_print_all_fields(self.api.profiles(), report_type)

            if report_what in [ "all", "systems"  ]:
                self.reporting_print_all_fields(self.api.systems(), report_type)

            if report_what in [ "all", "repos"    ]:
                self.reporting_print_all_fields(self.api.repos(), report_type) 
        
        else:
            
            if report_what in [ "all", "distros"  ]:
                self.reporting_print_x_fields(self.api.distros(), report_type, report_fields)

            if report_what in [ "all", "profiles" ]:
                self.reporting_print_x_fields(self.api.profiles(), report_type, report_fields)

            if report_what in [ "all", "systems"  ]:
                self.reporting_print_x_fields(self.api.systems(), report_type, report_fields)

            if report_what in [ "all", "repos"    ]:
                self.reporting_print_x_fields(self.api.repos(), report_type, report_fields)
"""
Report from a cobbler master.

Copyright 2007-2008, Red Hat, Inc
Anderson Silva <ansilva@redhat.com>


This software may be freely redistributed under the terms of the GNU
general public license.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
"""

import os
import os.path
import xmlrpclib
import api as cobbler_api
from utils import _


class Report:

    def __init__(self, config):
        """
        Constructor
        """
        self.config = config
        self.settings = config.settings()
        self.api = config.api
        self.remote = None
        self.uri = None

    def reporting_csv(self, info, order):
        """
        Formats data on 'info' for csv output
        """
        outputheaders = ''
        outputbody = ''
        sep = ','

        info_count = 0
        for item in info:

            item_count = 0
            for key in order:

                if info_count == 0:
                    outputheaders += str(key) + sep

                outputbody += str(item[key]) + sep

                item_count = item_count + 1

            info_count = info_count + 1
            outputbody += '\n'

        outputheaders += '\n'
        return outputheaders + outputbody

    def reporting_trac(self, info, order):
        """
        Formats data on 'info' for trac wiki table output
        """
        outputheaders = ''
        outputbody = ''
        sep = '||'

        info_count = 0
        for item in info:

            item_count = 0
            for key in order:

                if info_count == 0:
                    outputheaders += sep + str(key)

                outputbody += sep + str(item[key])

                item_count = item_count + 1

            info_count = info_count + 1
            outputbody += '||\n'

        outputheaders += '||\n'
        return outputheaders + outputbody

    def reporting_doku(self, info, order):
        """
        Formats data on 'info' for doku wiki table output
        """      
        outputheaders = ''
        outputbody = ''
        sep1 = '^'
        sep2 = '|'


        info_count = 0
        for item in info:
            
            item_count = 0
            for key in order:

                if info_count == 0:
                    outputheaders += sep1 + key

                outputbody += sep2 + item[key]

                item_count = item_count + 1

            info_count = info_count + 1
            outputbody += sep2 + '\n'

        outputheaders += sep1 + '\n'
        return outputheaders + outputbody

    
    def reporting_mediawiki(self, info, order):
        """
        Formats data on 'info' for mediawiki table output
        """
        outputheaders = ''
        outputbody = ''
        opentable = '{| border="1"\n'
        closetable = '|}\n'
        sep1 = '||'
        sep2 = '|'
        sep3 = '|-'


        info_count = 0
        for item in info:
            
            item_count = 0
            for key in order:

                if info_count == 0 and item_count == 0:
                    outputheaders += sep2 + key
                elif info_count == 0:
                    outputheaders += sep1 + key

                if item_count == 0:
                    outputbody += sep2 + item[key]
                else:
                    outputbody += sep1 + item[key]

                item_count = item_count + 1

            info_count = info_count + 1
            outputbody += '\n' + sep3 + '\n'

        outputheaders += '\n' + sep3 + '\n'
        return opentable + outputheaders + outputbody + closetable
    
    def print_formatted_data(self, data, order, report_type):
        """
        Used for picking the correct format to output data as
        """
        if report_type == "csv":
            print self.reporting_csv(data, order)
        if report_type == "mediawiki":
            print self.reporting_mediawiki(data, order)
        if report_type == "trac":
            print self.reporting_trac(data, order)
        if report_type == "doku":
            print self.reporting_doku(data, order)

        return True

    def reporting_sorter(self, a, b):
        """
        Used for sorting cobbler objects for report commands
        """
        return cmp(a.name, b.name)

    def reporting_print_sorted(self, collection):
        """
        Prints all objects in a collection sorted by name
        """
        collection = [x for x in collection]
        collection.sort(self.reporting_sorter)
        for x in collection:
            print x.printable()
        return True

    def reporting_list_names2(self, collection, name):
        """
        Prints a specific object in a collection.
        """
        obj = collection.find(name=name)
        if obj is not None:
            print obj.printable()
        return True
    
    def reporting_print_all_fields(self, collection, report_type):
        """
        Prints all fields in a collection as a table given the report type
        """
        collection = [x for x in collection]
        collection.sort(self.reporting_sorter)
        data = []
        for x in collection:
            structure = x.to_datastruct()
            data.append(structure)
                
        self.print_formatted_data(data = data, order = None, report_type = report_type)
        
        return True
    
    def reporting_print_x_fields(self, collection, report_type, report_fields):
        """
        Prints specific fields in a collection as a table given the report type
        """
        collection = [x for x in collection]
        collection.sort(self.reporting_sorter)
        data = []
        for x in collection:
            structure = x.to_datastruct()
            item = {}
            for field in report_fields:
                if field in structure.keys():
                    item[field] = structure[field]
            data.append(item)
            
        self.print_formatted_data(data = data, order = report_fields, report_type = report_type)
                        
        return True
        
    # -------------------------------------------------------

    def run(self, report_what = None, report_name = None, report_type = None, report_fields = None):
        """
        Get remote profiles and distros and sync them locally
        """
               
        """
        1. Handles original report output
        2. Handles all fields of report outputs as table given a format
        3. Handles specific fields of report outputs as table given a format
        """        
 
        if report_type is "text" and report_fields is "all":

            if report_what in [ "all", "distros" ]:
                if report_name:
                    self.reporting_list_names2(self.api.distros(), report_name)
                else:
                    self.reporting_print_sorted(self.api.distros())

            if report_what in [ "all", "profiles" ]:
                if report_name:
                    self.reporting_list_names2(self.api.profiles(), report_name)
                else:
                    self.reporting_print_sorted(self.api.profiles())

            if report_what in [ "all", "systems"  ]:
                if report_name:
                    self.reporting_list_names2(self.api.systems(), report_name)
                else:
                    self.reporting_print_sorted(self.api.systems())

            if report_what in [ "all", "repos"    ]:
                if report_name:
                    self.reporting_list_names2(self.api.repos(), report_name)
                else:
                    self.reporting_print_sorted(self.api.repos())
                    
        elif report_type is not "text" and report_fields is "all":
            
            if report_what in [ "all", "distros"  ]:
                self.reporting_print_all_fields(self.api.distros(), report_type)

            if report_what in [ "all", "profiles" ]:
                self.reporting_print_all_fields(self.api.profiles(), report_type)

            if report_what in [ "all", "systems"  ]:
                self.reporting_print_all_fields(self.api.systems(), report_type)

            if report_what in [ "all", "repos"    ]:
                self.reporting_print_all_fields(self.api.repos(), report_type) 
        
        else:
            
            if report_what in [ "all", "distros"  ]:
                self.reporting_print_x_fields(self.api.distros(), report_type, report_fields)

            if report_what in [ "all", "profiles" ]:
                self.reporting_print_x_fields(self.api.profiles(), report_type, report_fields)

            if report_what in [ "all", "systems"  ]:
                self.reporting_print_x_fields(self.api.systems(), report_type, report_fields)

            if report_what in [ "all", "repos"    ]:
                self.reporting_print_x_fields(self.api.repos(), report_type, report_fields)
