#!/bin/sh
#
# Run this after 'install' completes to edit the bes.conf scrip so that it
# will be correctly configured for the handler and the sample data.
#
# Usage: bes-dap-data.sh [<bes.conf file to modify> [<bes modules dir>]]

bes_conf=${1:-"/usr/local/etc/bes/bes.conf"}
bes_modules_dir=${2:-"/usr/local/lib/bes"}
bes_help_dir=${3:-"/usr/local/share/bes"}

# This script should take care to not add multiple entries for a handler.
# For now, I'm going to hack it so that a comment is written at the start
# of the file. This could be replaced by a better scheme, but probably not
# without rewrinting this in Perl or ...

if grep '^# Modified by bes-dap-data\..*' $bes_conf >/dev/null 2>&1
then
	echo
	echo "The bes-dap-data script has already been run, not modifying"
	echo "$bes_conf"
	echo
	exit
else
	echo "# Modified by bes-dap-data.sh on `date`" >> $bes_conf
fi

# Add the handler name(s) to BES.modules
for handler in usage ascii www
do

sed "s%^\(BES.modules=.*\)%\1,$handler%" < $bes_conf > tmp.conf
mv tmp.conf $bes_conf

done

# Add the handler module line (e.g., BES.module.ff) to the conf file
for module in "BES.module.usage=$bes_modules_dir/libusage_module.so" \
		  "BES.module.ascii=$bes_modules_dir/libascii_module.so" \
		  "BES.module.www=$bes_modules_dir/libwww_module.so"
do

awk "BEGIN {bes_module_found=0}
	 /^BES\.module\./ {bes_module_found=1}
	 /^$/ && bes_module_found == 1 {print \"$module\"; bes_module_found=0}
	 {print}" \
	 < $bes_conf > tmp.conf
mv tmp.conf $bes_conf

done
# Set/append any handler-specific params.

help_txt="DAP-SERVER.Help.TXT=$bes_help_dir/dap-server_help.txt"
help_html="DAP-SERVER.Help.HTML=$bes_help_dir/dap-server_help.html"
help_xml="DAP-SERVER.Help.XML=$bes_help_dir/dap-server_help.html"

awk "BEGIN {dap_help_found=0}
	/^DAP\.Help\./ {dap_help_found=1}
	/^$/ && dap_help_found == 1 {print}
	/^$/ && dap_help_found == 1 {print \"$help_txt\"}
	/^$/ && dap_help_found == 1 {print \"$help_html\"}
	/^$/ && dap_help_found == 1 {print \"$help_xml\"; dap_help_found=0}
	{print}" \
	< $bes_conf > tmp.conf
mv tmp.conf $bes_conf

