// -*- C++ -*-
/*
#
# This Program is part of Dictionary Reader
# Copyright (C) 1999 Takashi Nemoto
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details. 
#
#    Send bugs and comments to tnemoto@mvi.biglobe.ne.jp
#
*/

#ifndef __PFILE_H__
#define __PFILE_H__

#include "ebzip.h"
#include "tag.h"
#include "filename.h"

enum { BFileTypeError=-1, BFileTypeDisk=0, BFileTypeNDTP=1 };

class DicCache;

class BlockIO {

protected:
  int type;              // Disk = 0,  Ndtp = 1
  TAG currentPoint;
  byte ibuffer[cBlockSize];

  DicCache* cache;

  virtual bool SeekWithoutCache(int block)=0;

public:
  BlockIO();
  virtual ~BlockIO();

  bool Initialized(){ return type>=0; };
  bool IsNDTPMode(){ return type==BFileTypeNDTP; };

  bool Seek(const TAG& t);
  bool Seek(int offset);
  bool Seek(int block,int offset);
  
  const TAG& Tell();
  int LTell();
  
  int Read(byte* buffer,int len);
  bool ReadBlock(int block,byte* buf);
  bool ReadBlock(int block,char* buf){
    return ReadBlock(block,reinterpret_cast<byte*>(buf));
  }
  byte GetByte();
  word GetWord();
  dword GetDWord();
  word GetRWord();
  dword GetRDWord();
  int GetBCD(int nDigits=2);
  TAG GetTag();
  TAG GetBCDTag();
  int GetLine(byte* buf,int len);
  int GetLine(char* buf,int len){ 
    return GetLine(reinterpret_cast<byte*>(buf),len);
  };
};

class DiskIO : public BlockIO {
  EBZip* pgLib;
public:
  DiskIO(const char* fileName);
  virtual ~DiskIO();

  virtual bool SeekWithoutCache(int block);
};

BlockIO* OpenDict(const char* path);
#endif
