// -*- C++ -*-
/*
#
# This Program is part of Dictionary Reader
# Copyright (C) 1999 Takashi Nemoto
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details. 
#
#    Send bugs and comments to tnemoto@mvi.biglobe.ne.jp
#
*/

#ifndef __DEBUG_H__
#define __DEBUG_H__

class Debug {
public:
  static void DebugOut(int level,const char *fmt, ...);
  static void ErrorOut(const char *fmt, ...);
  static void Level(int lv) { level=lv; };
  static int Level() { return level; };
  Debug(int lv=DEFAULT) { level=lv; };

  static const int LOW_LEVEL_FILE	=1;

  const static int FILE_CACHE		=2;
  const static int CATALOG_DECODE	=4;
  const static int GAIJI_DECODE		=8;
  const static int INDEX_DECODE		=16;
  const static int DICTIONARY		=32;
  const static int DISPLAY		=64;
  const static int MULTIMEDIA		=128;
  const static int HONMON_CONTROL	=256;
  const static int NDTP	                =512;
  const static int CODE	                =1024;
  const static int WARNINGS		=16384;
  const static int VERBOSE		=32768;
  const static int TEMP			=32767;
  const static int ALL			=32767;
  const static int DEFAULT=(FILE_CACHE|DICTIONARY|WARNINGS);

private:
  static int level;
};

#endif
