/*                                                            -*- C -*-
#
# This Program is part of ebutils
# Copyright (C) 2000, 2001  Takashi Nemoto
#
# eb-library supplement package for eb-3.0alpha4 or later.
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details. 
#
#    Send bugs and comments to tnemoto@mvi.biglobe.ne.jp
#
*/

#ifdef HAVE_CONFIG_H
#include "../config.h"
#endif

#include "eb_sup.h"

#include "filename.h"

#ifdef HAVE_IO_H
# include <io.h>
#endif

#ifdef HAVE_LIMITS_H
# include <limits.h>
#endif

#include <stdio.h>

#ifdef HAVE_FCNTL_H
# include <fcntl.h>
#endif

#ifndef O_RDONLY
#  define O_RDONLY 0
#endif

#ifndef O_BINARY
#  define O_BINARY 0
#endif

/*
 * Whence parameter for lseek().
 */
#ifndef SEEK_SET
#define SEEK_SET 0
#define SEEK_CUR 1
#define SEEK_END 2
#endif
#define EB_SIZE_PAGE 2048

static int eb_open_count=0;

static int eb_zio_open_auto(zip,fileName)
     Zio *zip;
     const char *fileName;
{
    int f;
    size_t flen;
    char buf[EB_SIZE_PAGE];

    if (fileName == NULL)
        return -1;

    if (strncasecmp(FileName(fileName),"honmon2",7) == 0) {
        f = zio_open(zip,FuzzyFindFile(fileName),ZIO_EPWING);
        if (f >= 0) {
	    zio_lseek(zip,0,SEEK_SET);
            if (zio_read(zip,buf,EB_SIZE_PAGE) == EB_SIZE_PAGE) 
	        return f;
            zio_close(zip);
	}
#ifndef DISABLE_EPWING6
	f = zio_open(zip,FuzzyFindFile(fileName),ZIO_EPWING6);
	if (f >= 0) {
	    zio_lseek(zip,0,SEEK_SET);
	    if (zio_read(zip,buf,EB_SIZE_PAGE)==EB_SIZE_PAGE) 
	        return f;
	    zio_close(zip);
	}
#endif
    }
    f = open(FuzzyFindFile(fileName), O_RDONLY | O_BINARY);
    if (f >= 0) {
        read(f,buf,5);
        close(f);
        if (strncmp(buf,"EBZip",5)==0) 
	    return zio_open(zip,FuzzyFindFile(fileName),ZIO_EBZIP1);
/*
 if (strncmp(buf,"EBBZ2",5)==0) 
	    return zio_open(zip,FuzzyFindFile(fileName),ZIO_EBBZIP2);
 */
    }
#if 0
#ifdef ZIO_SEBXA
    if (strncasecmp(FileName(fileName),"start",5) == 0) {
        f = zio_open(zip,FuzzyFindFile(fileName),ZIO_SEBXA);
        if (f >= 0) {
	    zio_lseek(zip,0,SEEK_SET);
            if (zio_read(zip,buf,EB_SIZE_PAGE) == EB_SIZE_PAGE) 
	        return f;
            zio_close(zip);
	}
    }
#endif
#endif
    return zio_open(zip,FuzzyFindFile(fileName),ZIO_PLAIN);
}


int eb_sup_zopen(zip,fileName)
Zio *zip;
const char *fileName;
{
    char fname0[PATH_MAX+10];
    char fname[PATH_MAX+10];
    int f;
    size_t flen;

    if (fileName==NULL) 
        return -1;

    strncpy(fname0,fileName,PATH_MAX);
    fname0[PATH_MAX]=0;

    flen=strlen(fname0);
    if (flen <= 0) 
        return -1;

    if (eb_open_count==0) {
        zio_initialize_library();
    }
    zio_initialize(zip);
    eb_open_count++;

    /* open "fileName" */
    f=eb_zio_open_auto(zip,fname0);
    if (f >= 0)
        return f;

    /* open "fileName.ebz" (honmon => honmon.ebz) */
    strcpy(fname,fname0);
    strcat(fname,".ebz");
    f=eb_zio_open_auto(zip,fname);
    if (f >= 0)
        return f;

    /* open "fileNam.ebz" (honmon2 => honmon.ebz) */
    strcpy(fname,fname0);
    fname[flen-1]=0;
    strcat(fname,".ebz");
    f=eb_zio_open_auto(zip,fname);
    if (f >= 0)
        return f;

    /* open "fileNam.ebz" (honmon2 => honmon2.ebz) */
    strcpy(fname,fname0);
    strcat(fname,".ebz");
    f=eb_zio_open_auto(zip,fname);
    if (f >= 0)
        return f;

    /* open "fileName2" (honmon => honmon2) */
    strcpy(fname,fname0);
    strcat(fname,"2");
    f=eb_zio_open_auto(zip,fname);
    if (f >= 0)
        return f;

    zio_finalize(zip);
    if (--eb_open_count<=0)
        zio_finalize_library();
    
    return -1;
}

int eb_sup_zclose(zip)
Zio* zip;
{
    zio_close(zip);
    zio_finalize(zip);
    if (--eb_open_count==0) {
	zio_finalize_library();
    }
    return 0;
}

