// -*- C++ -*-
/*
#
# This Program is part of Dictionary Reader
# Copyright (C) 2000 Takashi Nemoto
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details. 
#
#    Send bugs and comments to tnemoto@mvi.biglobe.ne.jp
#
*/

#ifndef __NDTP_H__
#define __NDTP_H__

#include "def.h"
#include "bfile.h"

#include <vector>
#include <string>
#include <cstdio>
#include <cstdarg>

class NdtpPath {
  void copy(const NdtpPath&);
public:
  char* host;
  int port;
  char* base;
  char* path;
  bool isEB;  // true: EB, false: EPWING, 
  NdtpPath(const char* URIpath);
  NdtpPath(const NdtpPath&);
  const NdtpPath& operator = (const NdtpPath&);
  virtual ~NdtpPath();
};

struct NdtpDicList;

class NdtpIO : public BlockIO {
  struct NdtpDicList {
    int number;
    std::string title;
    std::string path;
    NdtpDicList(int n,const char* t,const char* p) : 
      number(n),title(t),path(p) {};
  };

  FILE* ndtpSocket;
  
  int currentDict;

  std::vector<NdtpDicList> diclist;
  bool GetDictList();


 protected:
  bool ReadLine(char* buf,int maxChar);
  bool ReadRaw(char* buf,size_t len);
  bool SendCommand(const char* fmt, ...);
  
 public:
  NdtpIO(char* hostname=NULL, int port=-1);
  virtual ~NdtpIO();

  virtual bool SeekWithoutCache(int block);
  bool SelectDict(const char* path);
  std::string GetTitle(const char* path);

  friend class GAIJI;
};

#endif
