/*
 * Copyright (c) 2008 Internet Initiative Japan Inc. All rights reserved.
 *
 * The terms and conditions of the accompanying program
 * shall be provided separately by Internet Initiative Japan Inc.
 * Any use, reproduction or distribution of the program are permitted
 * provided that you agree to be bound to such terms and conditions.
 *
 * $Id: sidf.h 84 2008-06-20 06:33:52Z takahiko $
 */

#ifndef __SIDF_H__
#define __SIDF_H__

typedef enum SidfStat {
    SIDF_STAT_OK = 0,
    SIDF_STAT_NO_RESOURCE,
    SIDF_STAT_RECORD_VERSION_MISMATCH,
    SIDF_STAT_RECORD_UNSUPPORTED_MECHANISM,
    SIDF_STAT_RECORD_UNSUPPORTED_MODIFIER,
    SIDF_STAT_RECORD_UNSUPPORTED_QUALIFIER,
    SIDF_STAT_RECORD_UNSUPPORTED_MACRO,
    SIDF_STAT_RECORD_DELIMITER_DUPLICATED,
    SIDF_STAT_RECORD_SYNTAX_VIOLATION,  // 文法エラーとなる構文違反
    SIDF_STAT_RECORD_NOT_MATCH, // エラーではないが, 文法にマッチしなかった
    SIDF_STAT_RECORD_INVALID_CIDR_LENGTH,
    SIDF_STAT_MALICIOUS_MACRO_EXPANSION,
    SIDF_STAT_MECH_NOT_MATCH,   // エラーではないが, メカニズムにマッチしなかった
    SIDF_STAT_DNS_NO_DATA,
    SIDF_STAT_DNS_HOST_NOT_FOUND,
    SIDF_STAT_DNS_TRY_AGAIN,
    SIDF_STAT_DNS_NO_RECOVERY,
} SidfStat;

typedef enum SidfRecordScope {
    SIDF_RECORD_SCOPE_NULL = 0,
    SIDF_RECORD_SCOPE_SPF1 = 0x01,
    SIDF_RECORD_SCOPE_SPF2_MFROM = 0x02,
    SIDF_RECORD_SCOPE_SPF2_PRA = 0x04,
    SIDF_RECORD_SCOPE_UNKNOWN = 0x08,
} SidfRecordScope;

typedef enum SidfScore {
    SIDF_SCORE_NULL = 0,
    SIDF_SCORE_NONE,
    SIDF_SCORE_NEUTRAL,
    SIDF_SCORE_PASS,
    SIDF_SCORE_POLICY,
    SIDF_SCORE_HARDFAIL,
    SIDF_SCORE_SOFTFAIL,
    SIDF_SCORE_TEMPERROR,
    SIDF_SCORE_PERMERROR,
    SIDF_SCORE_SYSERROR,    // 事実上メモリ不足専用
    SIDF_SCORE_MAX, // スコアが何種類存在するかを数える
} SidfScore;

typedef enum SidfQualifier {
    SIDF_QUALIFIER_NULL = 0,
    SIDF_QUALIFIER_PLUS = SIDF_SCORE_PASS,
    SIDF_QUALIFIER_MINUS = SIDF_SCORE_HARDFAIL,
    SIDF_QUALIFIER_QUESTION = SIDF_SCORE_NEUTRAL,
    SIDF_QUALIFIER_TILDE = SIDF_SCORE_SOFTFAIL,
} SidfQualifier;

typedef enum SidfTermType {
    SIDF_TERM_MECH_NULL = 0,
    SIDF_TERM_MECH_ALL,
    SIDF_TERM_MECH_INCLUDE,
    SIDF_TERM_MECH_A,
    SIDF_TERM_MECH_MX,
    SIDF_TERM_MECH_PTR,
    SIDF_TERM_MECH_IP4,
    SIDF_TERM_MECH_IP6,
    SIDF_TERM_MECH_EXISTS,
    SIDF_TERM_MOD_REDIRECT,
    SIDF_TERM_MOD_EXPLANATION,
    SIDF_TERM_MOD_UNKNOWN,
} SidfTermType;

typedef enum SidfMechanismType {
    SIDF_MECHANISM_NULL = 0,
    SIDF_MECHANISM_ALL = SIDF_TERM_MECH_ALL,
    SIDF_MECHANISM_INCLUDE = SIDF_TERM_MECH_INCLUDE,
    SIDF_MECHANISM_A = SIDF_TERM_MECH_A,
    SIDF_MECHANISM_MX = SIDF_TERM_MECH_MX,
    SIDF_MECHANISM_PTR = SIDF_TERM_MECH_PTR,
    SIDF_MECHANISM_IP4 = SIDF_TERM_MECH_IP4,
    SIDF_MECHANISM_IP6 = SIDF_TERM_MECH_IP6,
    SIDF_MECHANISM_EXISTS = SIDF_TERM_MECH_EXISTS,
} SidfMechanism;

typedef enum SidfModifierType {
    SIDF_MODIFIER_NULL = 0,
    SIDF_MODIFIER_REDIRECT = SIDF_TERM_MOD_REDIRECT,
    SIDF_MODIFIER_EXPLANATION = SIDF_TERM_MOD_EXPLANATION,
    SIDF_MODIFIER_UNKNOWN = SIDF_TERM_MOD_UNKNOWN,
} SidfModifierType;

typedef enum SidfMacroLetter {
    SIDF_MACRO_NULL = 0,
    SIDF_MACRO_S_SENDER,
    SIDF_MACRO_L_SENDER_LOCALPART,
    SIDF_MACRO_O_SENDER_DOMAIN,
    SIDF_MACRO_D_DOMAIN,
    SIDF_MACRO_I_DOTTED_IPADDR,
    SIDF_MACRO_P_IPADDR_VALID_DOMAIN,
    SIDF_MACRO_V_REVADDR_SUFFIX,
    SIDF_MACRO_H_HELO_DOMAIN,
    SIDF_MACRO_C_TEXT_IPADDR,
    SIDF_MACRO_R_CHECKING_DOMAIN,
    SIDF_MACRO_T_TIMESTAMP,
} SidfMacroLetter;

typedef enum SidfTermParamType {
    SIDF_TERM_PARAM_NONE,
    SIDF_TERM_PARAM_DOMAINSPEC,
    SIDF_TERM_PARAM_IP4,
    SIDF_TERM_PARAM_IP6,
} SidfTermParamType;

#endif /* __SIDF_H__ */
