#!/bin/sh
#
# Run this after 'install' completes to edit the bes.conf scrip so that it
# will be correctly configured for the handler and the sample data.
#
# Usage: bes-ff-data.sh [<bes.conf file to modify> [<bes modules dir>]]

bes_conf=${1:-"/usr/local/etc/bes/bes.conf"}
bes_modules_dir=${2:-"/usr/local/lib/bes"}

# This script should take care to not add multiple entries for a handler.
# For now, I'm going to hack it so that a comment is written at the start
# of the file. This could be replaced by a better scheme, but probably not
# without rewrinting this in Perl or ...

if grep '^# Modified by bes-ff-data\..*' $bes_conf >/dev/null 2>&1
then
	echo
	echo "The bes-ff-data script has already been run, not modifying"
	echo "$bes_conf"
	echo
	exit
else
	echo "# Modified by bes-ff-data.sh on `date`" >> $bes_conf
fi

# Add the handler name(s) to BES.modules
handler=ff

sed "s%^\(BES.modules=.*\)%\1,$handler%" < $bes_conf > tmp.conf
mv tmp.conf $bes_conf

# Add the handler module line (e.g., BES.module.ff) to the conf file
module="BES.module.ff=$bes_modules_dir/libff_module.so"

awk "BEGIN {bes_module_found=0}
	 /^BES\.module\./ {bes_module_found=1}
	 /^$/ && bes_module_found == 1 {print \"$module\"; bes_module_found=0}
	 {print}" \
	 < $bes_conf > tmp.conf
mv tmp.conf $bes_conf

# Use awk here.

# Add the data path to the BES.Catalog.catalog.RootDirectory parameter, when 
# the BES can support more than one. For now, the BES default bes.conf file is
# preset to point at $datadir/hyrax and we put all of the sample data in 
# $datadir/hyrax/data/<somplace> so that the server presents a top-level
# directory named 'data' with various subdirectories of sample data from each
# handler.

# Add regular expressions to the BES.Catalog.catalog.TypeMatch parameter
type_match='ff:.*\.dat(\.bz2|\.gz|\.Z)?$'

sed "s%^\(BES.Catalog.catalog.TypeMatch=.*\)%\1$type_match;%" \
    < $bes_conf > tmp.conf
mv tmp.conf $bes_conf

# Set/append any handler-specific params.

