#ifndef LEVELSET_H
#define LEVELSET_H

#include <gnome.h>

GPtrArray* levelset_paths;
  /* A resizeable array storing the paths of level sets */

GPtrArray* levelset_names;
  /* A resizeable array storing the names of level sets */

gint num_levelsets;     /* How many levelsets we have */
gint current_levelset;  /* Which levelset we are using */

/* --- */

void levelset_setup();

void levelset_setup_process_dir( GDir* dir, GString* path );

void levelset_add_dir( GString* path, G_CONST_RETURN GString* name,
  gint counter );

void levelset_create_menu();

void levelset_on_menuitem_chosen( GtkWidget* menu_item,
   gpointer which_levelset_ptr );

GString* levelset_get_file_name( gchar* file_name );
GdkPixbuf* levelset_get_pixbuf( gchar* file_name, gboolean must_load );

/* Called on exit */
void levelset_quit();

/* ----------------------------------------------- */

GString* _search_dir( GDir* search_dir, gchar* file_name );

#endif
