/*
 * Gnome Attacks
 *
 * Copyright (c) 2003 by Andy Balaam
 *
 * Released under the GNU General Public License
 * with ABSOLUTELY NO WARRANTY.
 *
 * See the file COPYING for more information.
 *
 */

#include "hiscore.h"

#include <gnome.h>

#include "main.h"
#include "interface.h"
#include "game.h"

void hiscore_setup()
{
  
  gint i;
  
  conf_client = gconf_client_get_default();
  
  most_recent_name = g_string_new( g_get_real_name() );
  
  for( i=0; i<10; i++ )
    {
    
        high_score_names[i] = g_string_new( NULL );
    
    }
  
  _read_scores();
  
}

void _read_scores()
{
  
  GError* err;
  gboolean test;
  gchar key[100];
  int i;
  gchar* tmp_str;
  
  err = NULL;
  
  tmp_str = gconf_client_get_string( conf_client,
    "/apps/gnomeattacks/high_scores/name_00", &err );
  
  /* First test for an error reading the gconf config */
  if( err ) {
    fprintf(stderr, _("Failed to read high scores: %s\n"), err->message);
    g_error_free(err); 
    err = NULL;
  }
  
  /* Now if the top name is blank, we need to initialise */
  if( tmp_str == NULL ) {
    
    _init_scores();
    
    printf( _("Initialised high score table.\n") );
    
  }
  
  /* Now we read in the high scores */
  for( i=0; i<10; i++ ) {
  
    snprintf( key, 100, "/apps/gnomeattacks/high_scores/score_0%d", i );
   
    high_scores[i] = gconf_client_get_int( conf_client, key, &err );
    
    if( err ) {
      fprintf(stderr, _("Failed to read scores: %s\n"), err->message);
      g_error_free(err); 
      err = NULL;
    }
    
    snprintf( key, 100, "/apps/gnomeattacks/high_scores/name_0%d", i );
  
    g_string_assign( high_score_names[i], gconf_client_get_string( conf_client,
      key, &err ) );
    
    if( err ) {
      fprintf(stderr, _("Failed to read name: %s\n"), err->message);
      g_error_free(err); 
      err = NULL;
    }
    
  }
  
}

void hiscore_quit()
{
  
  GError* err;
  gboolean test;
  gchar key[100];
  int i;
  
  for( i=0; i<10; i++ ) {
  
    snprintf( key, 100, "/apps/gnomeattacks/high_scores/score_0%d", i );
  
    test = gconf_client_set_int( conf_client, key, high_scores[i], &err );
    
    if( !test ) {
      fprintf(stderr, _("Failed to write scores: %s\n"), err->message);
      g_error_free(err); 
      err = NULL;
    }
    
    snprintf( key, 100, "/apps/gnomeattacks/high_scores/name_0%d", i );
  
    test = gconf_client_set_string( conf_client, key, high_score_names[i]->str,
        &err );
    
    if( !test ) {
      fprintf(stderr, _("Failed to write name: %s\n"), err->message);
      g_error_free(err); 
      err = NULL;
    }
    
  }
  
  for( i=0; i<10; i++)
  {
    
    g_string_free( high_score_names[i], TRUE );
    
  }
  
  g_string_free( most_recent_name, TRUE );
  
}

void _init_scores()
{
  
  int i;
  GError* err;
  gboolean test;
  gchar key[100];
  
  for( i=0; i<10; i++ )
  {
    
    snprintf( key, 100, "/apps/gnomeattacks/high_scores/score_0%d", i );
    
    test = gconf_client_set_int( conf_client, key, 500 - (50*i), NULL );
    
    if( !test ) {
      fprintf(stderr, _("Failed to write score: %s\n"), err->message);
      g_error_free(err); 
      err = NULL;
    }
        
    snprintf( key, 100, "/apps/gnomeattacks/high_scores/name_0%d", i );
    
    test = gconf_client_set_string( conf_client, key, "andy", NULL );
    
    if( !test ) {
      fprintf(stderr, _("Failed to write name: %s\n"), err->message);
      g_error_free(err); 
      err = NULL;
    }
        
  }
  
}

void hiscore_reset_scores()
{
  
  int i, res;
  
  dialog1 = create_dialog1();
  
  res = gtk_dialog_run( GTK_DIALOG( dialog1 ) );
  
  gtk_widget_destroy( dialog1 );
  
  if( res == GTK_RESPONSE_YES )
  {
  
    for( i=0; i<10; i++ )
    {
    
        g_string_assign( high_score_names[i], "andy" );
        high_scores[i] = 500 - (50*i);
    
    }
    
  }
  
}

void hiscore_add_score()
{
  
  int i,j;
  GtkEntry* entry1;
  
  dialog3 = create_dialog3();
  
  entry1 = GTK_ENTRY( lookup_widget( dialog3, "entry1" ) );
  
  gtk_entry_set_text( entry1, most_recent_name->str );
  
  gtk_dialog_run( GTK_DIALOG( dialog3 ) );
  
  g_string_assign( most_recent_name, gtk_entry_get_text( entry1 ) );
  
  gtk_widget_destroy( dialog3 );
     
  for( i=8; i>=0; i-- )
  {
        
    if( current_score <= high_scores[i] ) {
          
      break;
  
    }
  }
        
  for( j=8; j>i; j--)
  {
            
    high_scores[j+1] = high_scores[j];
    g_string_assign( high_score_names[j+1], high_score_names[j]->str );
            
  }
  
  high_scores[i+1] = current_score;
  
  g_string_assign( high_score_names[i+1], most_recent_name->str );
  
}



