/*
 *  Copyright (C) 2005 Kouji TAKAO <kouji@netlab.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <string.h>
#include <glib/gi18n.h>
#include <gtk/gtk.h>

#include "application.h"
#include "lock.h"

GType
gpass_gnome_lock_get_type(void)
{
    static GType type = 0;
    
    if (type == 0) {
        static const GTypeInfo info = {
            sizeof(GPassGnomeLockClass),
            NULL,
            NULL,
            NULL,
            NULL,
            NULL,
            sizeof(GPassGnomeLock),
            0,
            NULL,
        };
        
        type = g_type_register_static(GPASS_TYPE_VIEW, "GPassGnomeLock",
                                      &info, 0);
    }
    return type;
}

/***********************************************************
 *
 * Signal handlers
 *
 ***********************************************************/
static gboolean
validate_master_password(GPassGnomeLock *self)
{
    GPassApplication *app = GPASS_APPLICATION(GPASS_VIEW(self)->model);
    GtkWidget *entry;
    const gchar *password;

    entry = glade_xml_get_widget(GPASS_VIEW(self)->xml, "password");
    password = gtk_entry_get_text(GTK_ENTRY(entry));
    if (strcmp(password, app->file->master_password) != 0) {
        gpass_view_show_error_message
            (GPASS_VIEW(self), _("Incorrect password!"), entry);
        return FALSE;
    }
    return TRUE;
}

void
gpass_gnome_lock_on_response(GtkWidget *widget, gint response_id,
                             gpointer user_data)
{
    GPassGnomeLock *self;
    
    gpass_view_self_from_widget(widget, (gpointer **) &self);
    if (response_id == GTK_RESPONSE_OK) {
        if (validate_master_password(self)) {
            GPASS_VIEW(self)->result = GPASS_VIEW_RESULT_SUCCEED;
            gpass_view_shutdown_main_loop(GPASS_VIEW(self));
        }
    }
}
