/*
 *  Copyright (C) 2005 Kouji TAKAO <kouji@netlab.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GPASS_ATTRIBUTE_LIST_H__
#define __GPASS_ATTRIBUTE_LIST_H__

#include "gpass/attribute.h"

G_BEGIN_DECLS

/***********************************************************
 *
 * GPassAttributeListCursor
 *
 ***********************************************************/
#define GPASS_TYPE_ATTRIBUTE_LIST_CURSOR \
    (gpass_attribute_list_cursor_get_type())
#define GPASS_ATTRIBUTE_LIST_CURSOR(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), GPASS_TYPE_ATTRIBUTE_LIST_CURSOR, \
                                GPassAttributeListCursor))
#define GPASS_ATTRIBUTE_LIST_CURSOR_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), GPASS_TYPE_ATTRIBUTE_LIST_CURSOR, \
                             GPassAttributeListCursorClass))
#define GPASS_IS_ATTRIBUTE_LIST_CURSOR(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), GPASS_TYPE_ATTRIBUTE_LIST_CURSOR))
#define GPASS_IS_ATTRIBUTE_LIST_CURSOR_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), GPASS_TYPE_ATTRIBUTE_LIST_CURSOR))
#define GPASS_ATTRIBUTE_LIST_CURSOR_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS((obj), GPASS_TYPE_ATTRIBUTE_LIST_CURSOR, \
                               GPassAttributeListCursorClass))

typedef struct {
    GObject parent;
    
    GList *current;
} GPassAttributeListCursor;

typedef struct {
    GObjectClass parent;
} GPassAttributeListCursorClass;

GType gpass_attribute_list_cursor_get_type(void);

GError *gpass_attribute_list_cursor_next(GPassAttributeListCursor *self);
gboolean gpass_attribute_list_cursor_is_done(GPassAttributeListCursor *self);

/***********************************************************
 *
 * GPassAttributeList
 *
 ***********************************************************/
#define GPASS_TYPE_ATTRIBUTE_LIST (gpass_attribute_list_get_type())
#define GPASS_ATTRIBUTE_LIST(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), GPASS_TYPE_ATTRIBUTE_LIST, \
                                GPassAttributeList))
#define GPASS_ATTRIBUTE_LIST_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), GPASS_TYPE_ATTRIBUTE_LIST, \
                             GPassAttributeListClass))
#define GPASS_IS_ATTRIBUTE_LIST(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), GPASS_TYPE_ATTRIBUTE_LIST))
#define GPASS_IS_ATTRIBUTE_LIST_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), GPASS_TYPE_ATTRIBUTE_LIST))
#define GPASS_ATTRIBUTE_LIST_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS((obj), GPASS_TYPE_ATTRIBUTE_LIST, \
                               GPassAttributeListClass))

typedef struct {
    GObject parent;

    GList *list;
    GHashTable *hash;
} GPassAttributeList;

typedef struct {
    GObjectClass parent;
} GPassAttributeListClass;

GType gpass_attribute_list_get_type(void);

gint gpass_attribute_list_length(GPassAttributeList *self);
GError *gpass_attribute_list_prepend(GPassAttributeList *self,
                                     GPassAttribute *attr);
GError *gpass_attribute_list_append(GPassAttributeList *self,
                                    GPassAttribute *attr);
GPassAttribute *gpass_attribute_list_lookup(GPassAttributeList *self,
                                            const gchar *name);
void gpass_attribute_list_remove(GPassAttributeList *self, const gchar *name);
GPassAttributeListCursor *
gpass_attribute_list_create_cursor(GPassAttributeList *self);
GError *gpass_attribute_list_dump(GPassAttributeList *self, GString **buffer);
GError *gpass_attribute_list_load(GPassAttributeList *self,
                                  const guchar *buffer, gint len,
                                  gint *read_len);

G_END_DECLS

#endif /* #ifndef __GPASS_ATTRIBUTE_LIST_H__ */
