#! /usr/bin/ruby -Ke

#==============================================================================#
# $Id: line1.rb,v 1.3 2004/01/23 00:38:36 yuya Exp $
#==============================================================================#

require 'grb/chart/line/facade'

#==============================================================================#

data = [
  {
    :name   => 'Field 1',
    :color  => GRb::Color.red,
    :value  => [1, 5, 3, 4, 2],
  },
  {
    :name   => 'Field 2',
    :color  => GRb::Color.green,
    :value  => [1, 3, 4, 3, 5],
  },
  {
    :name   => 'Field 3',
    :color  => GRb::Color.blue,
    :value  => [1, 4, 5, 2, 3],
  },
]

#==============================================================================#

facade = GRb::Chart::LineChartFacade.create(500, 300)
facade.title.text                  = 'Line Chart Sample 1'
facade.chart.scale1.maximum        = 10
facade.chart.scale1.minimum        = 0
facade.chart.scale1.interval.major = 2
facade.chart.scale1.interval.minor = 0.5
facade.chart.axis.label.text       = ['A', 'B', 'C', 'D', 'E']
facade.data                        = data
facade.write_png_file('line1.png')

#==============================================================================#
#==============================================================================#
