
#==============================================================================#
# $Id: lozenge.rb,v 1.2 2004/01/23 23:02:00 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/chart/base/marker/lozenge.rb,v $
#==============================================================================#

require 'grb/chart/base/marker/base'

#==============================================================================#

module GRb

  module Chart

    class LozengeMarker < MarkerBase

      def drawing(image, x, y, color)
        poly = Polygon.new
        poly.add(x - @size, y)
        poly.add(x, y - @size)
        poly.add(x + @size, y)
        poly.add(x, y + @size)
        image.polygon(poly, color)
      end

    end # LozengeMarker

  end # Chart

end # GRb

#==============================================================================#
#==============================================================================#
