
#==============================================================================#
# $Id: frame.rb,v 1.2 2004/01/23 05:02:46 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/chart/base/property/composite/frame.rb,v $
#==============================================================================#

require 'grb/chart/base/property/base'
require 'grb/chart/base/property/fill'
require 'grb/chart/base/property/picture'
require 'grb/chart/base/property/gradation'
require 'grb/chart/base/property/border'
require 'grb/chart/base/property/shadow'
require 'grb/chart/base/property/padding'

#==============================================================================#

module GRb

  module Chart

    class FrameProperty < PropertyBase

      def initialize
        @fill      = FillProperty.new
        @picture   = PictureProperty.new
        @gradation = GradationProperty.new
        @border    = BorderProperty.new
        @shadow    = ShadowProperty.new
        @padding   = PaddingProperty.new
        @margin    = PaddingProperty.new

        self.setup
      end

      attr_reader :fill, :picture, :gradation, :border, :shadow, :padding, :margin

      def setup
        @fill.visible          = true
        @fill.color            = GRb::Color.white
        @fill.opacity          = 100
        @picture.visible       = false
        @picture.filepath      = nil
        @picture.opacity       = 100
        @gradation.visible     = false
        @gradation.start_color = GRb::Color.new(192, 255, 255)
        @gradation.end_color   = GRb::Color.new(0, 128, 255)
        @gradation.angle       = 0
        @gradation.opacity     = 100
        @border.visible        = true
        @border.color          = GRb::Color.black
        @border.width          = 1
        @shadow.visible        = false
        @shadow.color          = GRb::Color.gray(192)
        @shadow.offset_x       = 3
        @shadow.offset_y       = 3
        @padding.left          = 5
        @padding.right         = 5
        @padding.top           = 5
        @padding.bottom        = 5
        @margin.left           = 0
        @margin.right          = 0
        @margin.top            = 0
        @margin.bottom         = 0
      end

      def create_decorator(decorator)
        decorator = @padding.create_decorator(decorator)
        decorator = @picture.create_decorator(decorator)
        decorator = @gradation.create_decorator(decorator)
        decorator = @fill.create_decorator(decorator)
        decorator = @border.create_decorator(decorator)
        decorator = @shadow.create_decorator(decorator)
        decorator = @margin.create_decorator(decorator)

        return decorator
      end

    end # FrameProperty

  end # Chart

end # GRb

#==============================================================================#
#==============================================================================#
