
#==============================================================================#
# $Id: axis_label.rb,v 1.3 2004/01/23 05:24:11 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/chart/xy_base/decorator/axis_label.rb,v $
#==============================================================================#

require 'grb/chart/base/decorator/no_child_base'
require 'grb/chart/base/utility/text'

#==============================================================================#

module GRb

  module Chart

    class AxisLabelDecorator < NoChildDecoratorBase

      def initialize
        @number = nil
        @label  = nil
        @font   = nil
      end

      attr_accessor :number, :label, :font

      def draw(image, box)
        width = box.dx.to_f / @number.to_f
        start = box.x + width / 2.0
        texts = self.create_texts

        @number.times { |i|
          x = (start + width * i).ceil
          y = box.y

          texts[i].draw2(image, x, y)
        }
      end

      def create_texts
        return (0...@number).collect { |i|
          GRb::Chart::Text.new(@font, @label[i].to_s, GRb::Font::ALIGN_CENTER, GRb::Font::VALIGN_TOP)
        }
      end

      def dy
        return self.create_texts.collect { |text| text.dy }.max
      end

    end # AxisLabelDecorator

  end # Chart

end # GRb

#==============================================================================#

if $0 == __FILE__
  require 'grb/image'

  GRb::Image.create_and_write_png_file(200, 200, false, __FILE__.sub(/\.rb/, '.png')) { |image|
    GRb::Chart::Decorator::AxisLabel.new.instance_eval {
      self.number = 10
      self.label  = ('A'..'J').to_a
      self.font   = GRb::Chart::Font.new(GRb::Font::Giant, GRb::Color.red(128))
      self.draw(image, GRb::Chart::Box.new(10, 10, 180, 180))
    }
  }
end

#==============================================================================#
#==============================================================================#
