// Copyright (C) 2000-2006, Luca Padovani <padovani@sti.uniurb.it>.
//
// This file is part of GtkMathView, a Gtk widget for MathML.
// 
// GtkMathView is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// GtkMathView is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with GtkMathView; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 
// For details, see the GtkMathView World-Wide-Web page,
// http://helm.cs.unibo.it/mml-widget/, or send a mail to
// <padovani@sti.uniurb.it>

#include "TFM.hh"

static TFM::Font font = {
"CMSY",

  0xf2,
  "TeX math symbols",
  0x00600000,
  0x71a1250b,
  22,
  128
};

static TFM::Dimension dimension[] = {
  { 0x01, "slant", 0x00040000 },
  { 0x02, "space", 0x00000000 },
  { 0x03, "space_stretch", 0x00000000 },
  { 0x04, "space_shrink", 0x00000000 },
  { 0x05, "x_height", 0x0006e38d },
  { 0x06, "quad", 0x001471c0 },
  { 0x07, "extra_space", 0x00000000 },
  { 0x08, "num1", 0x000d00d0 },
  { 0x09, "num2", 0x000646fd },
  { 0x0a, "num3", 0x0007c240 },
  { 0x0b, "denom1", 0x000dd165 },
  { 0x0c, "denom2", 0x0006dead },
  { 0x0d, "sup1", 0x00080c28 },
  { 0x0e, "sup2", 0x0006b6d3 },
  { 0x0f, "sup3", 0x000497b5 },
  { 0x10, "sub1", 0x0002aaab },
  { 0x11, "sub2", 0x00055555 },
  { 0x12, "supdrop", 0x000697b0 },
  { 0x13, "subdrop", 0x00015555 },
  { 0x14, "delim1", 0x001fbbbb },
  { 0x15, "delim2", 0x0015999b },
  { 0x16, "axis_height", 0x00040000 }
};


static TFM::Kerning C_41_Kerning[] = {
  { 0x30, 0x0003a12d }
};

static TFM::Kerning C_42_Kerning[] = {
  { 0x30, 0x000297b3 }
};

static TFM::Kerning C_43_Kerning[] = {
  { 0x30, 0x000297b3 }
};

static TFM::Kerning C_44_Kerning[] = {
  { 0x30, 0x00018e38 }
};

static TFM::Kerning C_45_Kerning[] = {
  { 0x30, 0x000212f5 }
};

static TFM::Kerning C_46_Kerning[] = {
  { 0x30, 0x000212f5 }
};

static TFM::Kerning C_47_Kerning[] = {
  { 0x30, 0x000212f5 }
};

static TFM::Kerning C_48_Kerning[] = {
  { 0x30, 0x000212f5 }
};

static TFM::Kerning C_49_Kerning[] = {
  { 0x30, 0x000084bd }
};

static TFM::Kerning C_4a_Kerning[] = {
  { 0x30, 0x00031c70 }
};

static TFM::Kerning C_4b_Kerning[] = {
  { 0x30, 0x0001097b }
};

static TFM::Kerning C_4c_Kerning[] = {
  { 0x30, 0x000297b3 }
};

static TFM::Kerning C_4d_Kerning[] = {
  { 0x30, 0x000297b3 }
};

static TFM::Kerning C_4e_Kerning[] = {
  { 0x30, 0x00018e38 }
};

static TFM::Kerning C_4f_Kerning[] = {
  { 0x30, 0x000212f5 }
};

static TFM::Kerning C_50_Kerning[] = {
  { 0x30, 0x00018e38 }
};

static TFM::Kerning C_51_Kerning[] = {
  { 0x30, 0x000212f5 }
};

static TFM::Kerning C_52_Kerning[] = {
  { 0x30, 0x00018e38 }
};

static TFM::Kerning C_53_Kerning[] = {
  { 0x30, 0x000297b3 }
};

static TFM::Kerning C_54_Kerning[] = {
  { 0x30, 0x000084bd }
};

static TFM::Kerning C_55_Kerning[] = {
  { 0x30, 0x00018e38 }
};

static TFM::Kerning C_56_Kerning[] = {
  { 0x30, 0x000084bd }
};

static TFM::Kerning C_57_Kerning[] = {
  { 0x30, 0x00018e38 }
};

static TFM::Kerning C_58_Kerning[] = {
  { 0x30, 0x000297b3 }
};

static TFM::Kerning C_59_Kerning[] = {
  { 0x30, 0x00018e38 }
};

static TFM::Kerning C_5a_Kerning[] = {
  { 0x30, 0x000297b3 }
};


static TFM::Character character[] = {
  { 0x00, 0x000f6845, 0x000a38e0, 0x000238e0, 0x00000000, 0, 0, 0, 0 },
  { 0x01, 0x000612f5, 0x0007a12d, 0xffffa12d, 0x00000000, 0, 0, 0, 0 },
  { 0x02, 0x000f6845, 0x000a38e0, 0x000238e0, 0x00000000, 0, 0, 0, 0 },
  { 0x03, 0x000a38e0, 0x000771c8, 0xffff71c8, 0x00000000, 0, 0, 0, 0 },
  { 0x04, 0x000f6845, 0x000a38e0, 0x000238e0, 0x00000000, 0, 0, 0, 0 },
  { 0x05, 0x000a38e0, 0x0007a12d, 0xffffa12d, 0x00000000, 0, 0, 0, 0 },
  { 0x06, 0x000f6845, 0x000a38e0, 0x000238e0, 0x00000000, 0, 0, 0, 0 },
  { 0x07, 0x000f6845, 0x000a38e0, 0x000238e0, 0x00000000, 0, 0, 0, 0 },
  { 0x08, 0x000f6845, 0x000a38e0, 0x000238e0, 0x00000000, 0, 0, 0, 0 },
  { 0x09, 0x000f6845, 0x000a38e0, 0x000238e0, 0x00000000, 0, 0, 0, 0 },
  { 0x0a, 0x000f6845, 0x000a38e0, 0x000238e0, 0x00000000, 0, 0, 0, 0 },
  { 0x0b, 0x000f6845, 0x000a38e0, 0x000238e0, 0x00000000, 0, 0, 0, 0 },
  { 0x0c, 0x000f6845, 0x000a38e0, 0x000238e0, 0x00000000, 0, 0, 0, 0 },
  { 0x0d, 0x00138e30, 0x000b1c73, 0x00031c73, 0x00000000, 0, 0, 0, 0 },
  { 0x0e, 0x000a38e0, 0x0007a12d, 0xffffa12d, 0x00000000, 0, 0, 0, 0 },
  { 0x0f, 0x000a38e0, 0x0007a12d, 0xffffa12d, 0x00000000, 0, 0, 0, 0 },
  { 0x10, 0x000f6845, 0x00081080, 0x00001080, 0x00000000, 0, 0, 0, 0 },
  { 0x11, 0x000f6845, 0x00081080, 0x00001080, 0x00000000, 0, 0, 0, 0 },
  { 0x12, 0x000f6845, 0x000b3bbd, 0x00033bbd, 0x00000000, 0, 0, 0, 0 },
  { 0x13, 0x000f6845, 0x000b3bbd, 0x00033bbd, 0x00000000, 0, 0, 0, 0 },
  { 0x14, 0x000f6845, 0x000b3bbd, 0x00033bbd, 0x00000000, 0, 0, 0, 0 },
  { 0x15, 0x000f6845, 0x000b3bbd, 0x00033bbd, 0x00000000, 0, 0, 0, 0 },
  { 0x16, 0x000f6845, 0x000b3bbd, 0x00033bbd, 0x00000000, 0, 0, 0, 0 },
  { 0x17, 0x000f6845, 0x000b3bbd, 0x00033bbd, 0x00000000, 0, 0, 0, 0 },
  { 0x18, 0x000f6845, 0x00063d28, 0xfffe3d28, 0x00000000, 0, 0, 0, 0 },
  { 0x19, 0x000f6845, 0x00086df8, 0x00006df8, 0x00000000, 0, 0, 0, 0 },
  { 0x1a, 0x000f6845, 0x00096865, 0x00016865, 0x00000000, 0, 0, 0, 0 },
  { 0x1b, 0x000f6845, 0x00096865, 0x00016865, 0x00000000, 0, 0, 0, 0 },
  { 0x1c, 0x00138e30, 0x00096865, 0x00016865, 0x00000000, 0, 0, 0, 0 },
  { 0x1d, 0x00138e30, 0x00096865, 0x00016865, 0x00000000, 0, 0, 0, 0 },
  { 0x1e, 0x000f6845, 0x00096865, 0x00016865, 0x00000000, 0, 0, 0, 0 },
  { 0x1f, 0x000f6845, 0x00096865, 0x00016865, 0x00000000, 0, 0, 0, 0 },
  { 0x20, 0x00138e30, 0x00063d28, 0xfffe3d28, 0x00000000, 0, 0, 0, 0 },
  { 0x21, 0x00138e30, 0x00063d28, 0xfffe3d28, 0x00000000, 0, 0, 0, 0 },
  { 0x22, 0x000a38e0, 0x000b1c73, 0x00031c70, 0x00000000, 0, 0, 0, 0 },
  { 0x23, 0x000a38e0, 0x000b1c73, 0x00031c70, 0x00000000, 0, 0, 0, 0 },
  { 0x24, 0x00138e30, 0x00063d28, 0xfffe3d28, 0x00000000, 0, 0, 0, 0 },
  { 0x25, 0x00138e30, 0x000b1c73, 0x00031c70, 0x00000000, 0, 0, 0, 0 },
  { 0x26, 0x00138e30, 0x000b1c73, 0x00031c70, 0x00000000, 0, 0, 0, 0 },
  { 0x27, 0x000f6845, 0x00081080, 0x00001080, 0x00000000, 0, 0, 0, 0 },
  { 0x28, 0x00138e30, 0x00063d28, 0xfffe3d28, 0x00000000, 0, 0, 0, 0 },
  { 0x29, 0x00138e30, 0x00063d28, 0xfffe3d28, 0x00000000, 0, 0, 0, 0 },
  { 0x2a, 0x000c4bd5, 0x000b1c73, 0x00031c70, 0x00000000, 0, 0, 0, 0 },
  { 0x2b, 0x000c4bd5, 0x000b1c73, 0x00031c70, 0x00000000, 0, 0, 0, 0 },
  { 0x2c, 0x00138e30, 0x00063d28, 0xfffe3d28, 0x00000000, 0, 0, 0, 0 },
  { 0x2d, 0x00138e30, 0x000b1c73, 0x00031c70, 0x00000000, 0, 0, 0, 0 },
  { 0x2e, 0x00138e30, 0x000b1c73, 0x00031c70, 0x00000000, 0, 0, 0, 0 },
  { 0x2f, 0x000f6845, 0x0006e38d, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x30, 0x0005da13, 0x0008e390, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x31, 0x00138e30, 0x0006e38d, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x32, 0x000d5550, 0x00096865, 0x00016865, 0x00000000, 0, 0, 0, 0 },
  { 0x33, 0x000d5550, 0x00096865, 0x00016865, 0x00000000, 0, 0, 0, 0 },
  { 0x34, 0x00117b3b, 0x000b1c73, 0x00031c73, 0x00000000, 0, 0, 0, 0 },
  { 0x35, 0x00117b3b, 0x000b1c73, 0x00031c73, 0x00000000, 0, 0, 0, 0 },
  { 0x36, 0x00000000, 0x000b1c73, 0x00031c70, 0x00000000, 0, 0, 0, 0 },
  { 0x37, 0x00000000, 0x00063d28, 0xfffe3d28, 0x00000000, 0, 0, 0, 0 },
  { 0x38, 0x000b425b, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x39, 0x000b425b, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x3a, 0x000d5550, 0x0006e38d, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x3b, 0x000a38e0, 0x000c0000, 0x0000e38d, 0x00000000, 0, 0, 0, 0 },
  { 0x3c, 0x000e5ecb, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x3d, 0x000e5ecb, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x3e, 0x000f6845, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x3f, 0x000f6845, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x40, 0x000c4bd5, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x41, 0x000fd6cd, 0x000aeef0, 0x00000000, 0x00000000, 1, C_41_Kerning, 0, 0 },
  { 0x42, 0x000d0335, 0x000aeef0, 0x00000000, 0x00005705, 1, C_42_Kerning, 0, 0 },
  { 0x43, 0x000adaa0, 0x000aeef0, 0x00000000, 0x0000b97b, 1, C_43_Kerning, 0, 0 },
  { 0x44, 0x000f6110, 0x000aeef0, 0x00000000, 0x000084bd, 1, C_44_Kerning, 0, 0 },
  { 0x45, 0x000abd9d, 0x000aeef0, 0x00000000, 0x00014e20, 1, C_45_Kerning, 0, 0 },
  { 0x46, 0x000e13e0, 0x000aeef0, 0x00000000, 0x0001a03d, 1, C_46_Kerning, 0, 0 },
  { 0x47, 0x000bf283, 0x000aeef0, 0x00018e3b, 0x0000e118, 1, C_47_Kerning, 0, 0 },
  { 0x48, 0x0010f2f8, 0x000aeef0, 0x00000000, 0x00000000, 1, C_48_Kerning, 0, 0 },
  { 0x49, 0x000b5963, 0x000aeef0, 0x00000000, 0x0000f42b, 1, C_49_Kerning, 0, 0 },
  { 0x4a, 0x000d8a68, 0x000aeef0, 0x00018e3b, 0x0002fe1d, 1, C_4a_Kerning, 0, 0 },
  { 0x4b, 0x000f054d, 0x000aeef0, 0x00000000, 0x00000000, 1, C_4b_Kerning, 0, 0 },
  { 0x4c, 0x000dac2b, 0x000aeef0, 0x00000000, 0x00000000, 1, C_4c_Kerning, 0, 0 },
  { 0x4d, 0x0016d5f0, 0x000aeef0, 0x00000000, 0x00000000, 1, C_4d_Kerning, 0, 0 },
  { 0x4e, 0x00101735, 0x000aeef0, 0x00000000, 0x00026e8d, 1, C_4e_Kerning, 0, 0 },
  { 0x4f, 0x000f913b, 0x000aeef0, 0x00000000, 0x000084bd, 1, C_4f_Kerning, 0, 0 },
  { 0x50, 0x000e0e03, 0x000aeef0, 0x00000000, 0x00015a43, 1, C_50_Kerning, 0, 0 },
  { 0x51, 0x0010221b, 0x000aeef0, 0x00018e3b, 0x00000000, 1, C_51_Kerning, 0, 0 },
  { 0x52, 0x0010fb6b, 0x000aeef0, 0x00000000, 0x00000000, 1, C_52_Kerning, 0, 0 },
  { 0x53, 0x000c3148, 0x000aeef0, 0x00000000, 0x0001206b, 1, C_53_Kerning, 0, 0 },
  { 0x54, 0x000b6180, 0x000aeef0, 0x00000000, 0x000449f5, 1, C_54_Kerning, 0, 0 },
  { 0x55, 0x000c6415, 0x000aeef0, 0x00000000, 0x0001a03d, 1, C_55_Kerning, 0, 0 },
  { 0x56, 0x000c904b, 0x000aeef0, 0x00000000, 0x00015a43, 1, C_56_Kerning, 0, 0 },
  { 0x57, 0x00139045, 0x000aeef0, 0x00000000, 0x00015a43, 1, C_57_Kerning, 0, 0 },
  { 0x58, 0x000e2375, 0x000aeef0, 0x00000000, 0x000257c8, 1, C_58_Kerning, 0, 0 },
  { 0x59, 0x000d2ea5, 0x000aeef0, 0x00018e3b, 0x00015a43, 1, C_59_Kerning, 0, 0 },
  { 0x5a, 0x000e24c5, 0x000aeef0, 0x00000000, 0x00014cfd, 1, C_5a_Kerning, 0, 0 },
  { 0x5b, 0x000d5550, 0x0008e390, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5c, 0x000d5550, 0x0008e390, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5d, 0x000d5550, 0x0008e390, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5e, 0x000d5550, 0x0008e390, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5f, 0x000d5550, 0x0008e390, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x60, 0x000c4bd5, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x61, 0x000c4bd5, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x62, 0x00092f65, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x63, 0x00092f65, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x64, 0x00092f65, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x65, 0x00092f65, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x66, 0x000a38e0, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x67, 0x000a38e0, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x68, 0x000825eb, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x69, 0x000825eb, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x6a, 0x000612f5, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x6b, 0x000a38e0, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x6c, 0x000a38e0, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x6d, 0x000c4bd5, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x6e, 0x000a38e0, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x6f, 0x000612f5, 0x000b1c73, 0x00031c70, 0x00000000, 0, 0, 0, 0 },
  { 0x70, 0x000ffff8, 0x0000d3a0, 0x000f2c60, 0x00000000, 0, 0, 0, 0 },
  { 0x71, 0x000ec8fb, 0x000aeef0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x72, 0x001071c0, 0x000aeef0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x73, 0x0008aaab, 0x000b1c73, 0x00031c73, 0x000212f5, 0, 0, 0, 0 },
  { 0x74, 0x000d5550, 0x0008e390, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x75, 0x000d5550, 0x0008e390, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x76, 0x000f6845, 0x000b3bbd, 0x00033bbd, 0x00000000, 0, 0, 0, 0 },
  { 0x77, 0x000f6845, 0x000b3bbd, 0x00033bbd, 0x00000000, 0, 0, 0, 0 },
  { 0x78, 0x00092f65, 0x000b1c73, 0x00031c73, 0x00000000, 0, 0, 0, 0 },
  { 0x79, 0x00092f65, 0x000b1c73, 0x00031c73, 0x00000000, 0, 0, 0, 0 },
  { 0x7a, 0x00092f65, 0x000b1c73, 0x00031c73, 0x00000000, 0, 0, 0, 0 },
  { 0x7b, 0x000c4bd5, 0x000b1c73, 0x00031c73, 0x00000000, 0, 0, 0, 0 },
  { 0x7c, 0x000f6845, 0x000b1c73, 0x000212f8, 0x00000000, 0, 0, 0, 0 },
  { 0x7d, 0x000f6845, 0x000b1c73, 0x000212f8, 0x00000000, 0, 0, 0, 0 },
  { 0x7e, 0x000f6845, 0x000b1c73, 0x000212f8, 0x00000000, 0, 0, 0, 0 },
  { 0x7f, 0x000f6845, 0x000b1c73, 0x000212f8, 0x00000000, 0, 0, 0, 0 }
};

void
cmsy6_tables(TFM::Font*& _font, TFM::Dimension*& _dimension, TFM::Character*& _character)
{
  _font = &font;
  _dimension = dimension;
  _character = character;
}
