// Copyright (C) 2000-2006, Luca Padovani <padovani@sti.uniurb.it>.
//
// This file is part of GtkMathView, a Gtk widget for MathML.
// 
// GtkMathView is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// GtkMathView is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with GtkMathView; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 
// For details, see the GtkMathView World-Wide-Web page,
// http://helm.cs.unibo.it/mml-widget/, or send a mail to
// <padovani@sti.uniurb.it>

#include "TFM.hh"

static TFM::Font font = {
"CMTI",

  0xf0,
  "TeX text",
  0x00700000,
  0x747d5cca,
  7,
  128
};

static TFM::Dimension dimension[] = {
  { 0x01, "slant", 0x00040000 },
  { 0x02, "space", 0x0006d4f2 },
  { 0x03, "space_stretch", 0x0002d1b0 },
  { 0x04, "space_shrink", 0x0001e120 },
  { 0x05, "x_height", 0x0006e38e },
  { 0x06, "quad", 0x00134d45 },
  { 0x07, "extra_space", 0x0001e120 }
};


static TFM::Kerning C_0b_Kerning[] = {
  { 0x21, 0x0001c2a5 },
  { 0x27, 0x0001c2a5 },
  { 0x29, 0x0001c2a5 },
  { 0x3f, 0x0001c2a5 },
  { 0x5d, 0x0001c2a5 }
};

static TFM::Kerning C_20_Kerning[] = {
  { 0x4c, 0xfff9e2b9 },
  { 0x6c, 0xfffb0c2e }
};

static TFM::Kerning C_27_Kerning[] = {
  { 0x21, 0x0001e120 },
  { 0x3f, 0x0001e120 }
};

static TFM::Kerning C_41_Kerning[] = {
  { 0x43, 0xffff87b7 },
  { 0x47, 0xffff87b7 },
  { 0x4f, 0xffff87b7 },
  { 0x51, 0xffff87b7 },
  { 0x54, 0xfffe9727 },
  { 0x55, 0xffff87b7 },
  { 0x56, 0xfffe1ee0 },
  { 0x57, 0xfffe1ee0 },
  { 0x59, 0xfffe9727 },
  { 0x61, 0xffff0f70 },
  { 0x62, 0xffff87b7 },
  { 0x63, 0xffff0f70 },
  { 0x64, 0xffff0f70 },
  { 0x65, 0xffff0f70 },
  { 0x67, 0xffff0f70 },
  { 0x68, 0xffff87b7 },
  { 0x69, 0xffff87b7 },
  { 0x6b, 0xffff87b7 },
  { 0x6c, 0xffff87b7 },
  { 0x6d, 0xffff87b7 },
  { 0x6e, 0xffff87b7 },
  { 0x6f, 0xffff0f70 },
  { 0x71, 0xffff0f70 },
  { 0x72, 0xffff87b7 },
  { 0x74, 0xffff87b7 },
  { 0x75, 0xffff87b7 },
  { 0x76, 0xffff87b7 },
  { 0x77, 0xffff87b7 }
};

static TFM::Kerning C_44_Kerning[] = {
  { 0x41, 0xffff87b7 },
  { 0x56, 0xffff87b7 },
  { 0x57, 0xffff87b7 },
  { 0x58, 0xffff87b7 },
  { 0x59, 0xffff87b7 }
};

static TFM::Kerning C_46_Kerning[] = {
  { 0x41, 0xfffe1ee0 },
  { 0x43, 0xffff87b7 },
  { 0x47, 0xffff87b7 },
  { 0x4f, 0xffff87b7 },
  { 0x51, 0xffff87b7 },
  { 0x61, 0xfffe9727 },
  { 0x65, 0xfffe9727 },
  { 0x6f, 0xfffe9727 },
  { 0x72, 0xfffe9727 },
  { 0x75, 0xfffe9727 }
};

static TFM::Kerning C_4b_Kerning[] = {
  { 0x43, 0xffff87b7 },
  { 0x47, 0xffff87b7 },
  { 0x4f, 0xffff87b7 },
  { 0x51, 0xffff87b7 }
};

static TFM::Kerning C_4c_Kerning[] = {
  { 0x54, 0xfffe9727 },
  { 0x56, 0xfffe1ee0 },
  { 0x57, 0xfffe1ee0 },
  { 0x59, 0xfffe9727 },
  { 0x61, 0xffff0f70 },
  { 0x63, 0xffff0f70 },
  { 0x64, 0xffff0f70 },
  { 0x65, 0xffff0f70 },
  { 0x67, 0xffff0f70 },
  { 0x6f, 0xffff0f70 },
  { 0x71, 0xffff0f70 }
};

static TFM::Kerning C_4f_Kerning[] = {
  { 0x41, 0xffff87b7 },
  { 0x56, 0xffff87b7 },
  { 0x57, 0xffff87b7 },
  { 0x58, 0xffff87b7 },
  { 0x59, 0xffff87b7 }
};

static TFM::Kerning C_50_Kerning[] = {
  { 0x41, 0xfffe9727 }
};

static TFM::Kerning C_52_Kerning[] = {
  { 0x43, 0xffff87b7 },
  { 0x47, 0xffff87b7 },
  { 0x4f, 0xffff87b7 },
  { 0x51, 0xffff87b7 },
  { 0x54, 0xfffe9727 },
  { 0x55, 0xffff87b7 },
  { 0x56, 0xfffe1ee0 },
  { 0x57, 0xfffe1ee0 },
  { 0x59, 0xfffe9727 },
  { 0x61, 0xffff0f70 },
  { 0x62, 0xffff87b7 },
  { 0x63, 0xffff0f70 },
  { 0x64, 0xffff0f70 },
  { 0x65, 0xffff0f70 },
  { 0x67, 0xffff0f70 },
  { 0x68, 0xffff87b7 },
  { 0x69, 0xffff87b7 },
  { 0x6b, 0xffff87b7 },
  { 0x6c, 0xffff87b7 },
  { 0x6d, 0xffff87b7 },
  { 0x6e, 0xffff87b7 },
  { 0x6f, 0xffff0f70 },
  { 0x71, 0xffff0f70 },
  { 0x72, 0xffff87b7 },
  { 0x74, 0xffff87b7 },
  { 0x75, 0xffff87b7 },
  { 0x76, 0xffff87b7 },
  { 0x77, 0xffff87b7 }
};

static TFM::Kerning C_54_Kerning[] = {
  { 0x41, 0xfffe9727 },
  { 0x61, 0xfffe9727 },
  { 0x65, 0xfffe9727 },
  { 0x6f, 0xfffe9727 },
  { 0x72, 0xfffe9727 },
  { 0x75, 0xfffe9727 },
  { 0x79, 0xfffe9727 }
};

static TFM::Kerning C_56_Kerning[] = {
  { 0x41, 0xfffe1ee0 },
  { 0x43, 0xffff87b7 },
  { 0x47, 0xffff87b7 },
  { 0x4f, 0xffff87b7 },
  { 0x51, 0xffff87b7 },
  { 0x61, 0xfffe9727 },
  { 0x65, 0xfffe9727 },
  { 0x6f, 0xfffe9727 },
  { 0x72, 0xfffe9727 },
  { 0x75, 0xfffe9727 }
};

static TFM::Kerning C_57_Kerning[] = {
  { 0x41, 0xfffe9727 }
};

static TFM::Kerning C_58_Kerning[] = {
  { 0x43, 0xffff87b7 },
  { 0x47, 0xffff87b7 },
  { 0x4f, 0xffff87b7 },
  { 0x51, 0xffff87b7 }
};

static TFM::Kerning C_59_Kerning[] = {
  { 0x41, 0xfffe9727 },
  { 0x61, 0xfffe9727 },
  { 0x65, 0xfffe9727 },
  { 0x6f, 0xfffe9727 },
  { 0x72, 0xfffe9727 },
  { 0x75, 0xfffe9727 }
};

static TFM::Kerning C_62_Kerning[] = {
  { 0x61, 0xffff0f70 },
  { 0x63, 0xffff0f70 },
  { 0x64, 0xffff0f70 },
  { 0x65, 0xffff0f70 },
  { 0x67, 0xffff0f70 },
  { 0x6f, 0xffff0f70 },
  { 0x71, 0xffff0f70 }
};

static TFM::Kerning C_63_Kerning[] = {
  { 0x61, 0xffff0f70 },
  { 0x63, 0xffff0f70 },
  { 0x64, 0xffff0f70 },
  { 0x65, 0xffff0f70 },
  { 0x67, 0xffff0f70 },
  { 0x6f, 0xffff0f70 },
  { 0x71, 0xffff0f70 }
};

static TFM::Kerning C_64_Kerning[] = {
  { 0x6c, 0x0000f090 }
};

static TFM::Kerning C_65_Kerning[] = {
  { 0x61, 0xffff0f70 },
  { 0x63, 0xffff0f70 },
  { 0x64, 0xffff0f70 },
  { 0x65, 0xffff0f70 },
  { 0x67, 0xffff0f70 },
  { 0x6f, 0xffff0f70 },
  { 0x71, 0xffff0f70 }
};

static TFM::Kerning C_66_Kerning[] = {
  { 0x21, 0x0001c2a5 },
  { 0x27, 0x0001c2a5 },
  { 0x29, 0x0001c2a5 },
  { 0x3f, 0x0001c2a5 },
  { 0x5d, 0x0001c2a5 }
};

static TFM::Kerning C_6c_Kerning[] = {
  { 0x6c, 0x0000f090 }
};

static TFM::Kerning C_6e_Kerning[] = {
  { 0x27, 0xfffe1ee0 }
};

static TFM::Kerning C_6f_Kerning[] = {
  { 0x61, 0xffff0f70 },
  { 0x63, 0xffff0f70 },
  { 0x64, 0xffff0f70 },
  { 0x65, 0xffff0f70 },
  { 0x67, 0xffff0f70 },
  { 0x6f, 0xffff0f70 },
  { 0x71, 0xffff0f70 }
};

static TFM::Kerning C_70_Kerning[] = {
  { 0x61, 0xffff0f70 },
  { 0x63, 0xffff0f70 },
  { 0x64, 0xffff0f70 },
  { 0x65, 0xffff0f70 },
  { 0x67, 0xffff0f70 },
  { 0x6f, 0xffff0f70 },
  { 0x71, 0xffff0f70 }
};

static TFM::Kerning C_72_Kerning[] = {
  { 0x61, 0xffff0f70 },
  { 0x63, 0xffff0f70 },
  { 0x64, 0xffff0f70 },
  { 0x65, 0xffff0f70 },
  { 0x67, 0xffff0f70 },
  { 0x6f, 0xffff0f70 },
  { 0x71, 0xffff0f70 }
};

static TFM::Kerning C_77_Kerning[] = {
  { 0x6c, 0x0000f090 }
};

static TFM::Ligature C_0b_Ligature[] = {
  { 0x69, 0x00, 0x0e },
  { 0x6c, 0x00, 0x0f }
};

static TFM::Ligature C_21_Ligature[] = {
  { 0x60, 0x00, 0x3c }
};

static TFM::Ligature C_27_Ligature[] = {
  { 0x27, 0x00, 0x22 }
};

static TFM::Ligature C_2d_Ligature[] = {
  { 0x2d, 0x00, 0x7b }
};

static TFM::Ligature C_3f_Ligature[] = {
  { 0x60, 0x00, 0x3e }
};

static TFM::Ligature C_60_Ligature[] = {
  { 0x60, 0x00, 0x5c }
};

static TFM::Ligature C_66_Ligature[] = {
  { 0x66, 0x00, 0x0b },
  { 0x69, 0x00, 0x0c },
  { 0x6c, 0x00, 0x0d }
};

static TFM::Ligature C_7b_Ligature[] = {
  { 0x2d, 0x00, 0x7c }
};


static TFM::Character character[] = {
  { 0x00, 0x000bc0a7, 0x000ad8fe, 0x00000000, 0x0000f2cb, 0, 0, 0, 0 },
  { 0x01, 0x000f4a02, 0x000ad8fe, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x02, 0x000e5972, 0x000ad8fe, 0x00000000, 0x0000c42e, 0, 0, 0, 0 },
  { 0x03, 0x000cea1b, 0x000ad8fe, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x04, 0x000c7852, 0x000ad8fe, 0x00000000, 0x000067d2, 0, 0, 0, 0 },
  { 0x05, 0x000ddaab, 0x000ad8fe, 0x00000000, 0x00006429, 0, 0, 0, 0 },
  { 0x06, 0x000d68e2, 0x000ad8fe, 0x00000000, 0x0000c375, 0, 0, 0, 0 },
  { 0x07, 0x000e5972, 0x000ad8fe, 0x00000000, 0x00006429, 0, 0, 0, 0 },
  { 0x08, 0x000d68e2, 0x000ad8fe, 0x00000000, 0x0000e595, 0, 0, 0, 0 },
  { 0x09, 0x000e5972, 0x000ad8fe, 0x00000000, 0x00006429, 0, 0, 0, 0 },
  { 0x0a, 0x000d68e2, 0x000ad8fe, 0x00000000, 0x000133e9, 0, 0, 0, 0 },
  { 0x0b, 0x000bc8c7, 0x000b1c72, 0x00031c72, 0x0000f05b, 5, C_0b_Kerning, 2, C_0b_Ligature },
  { 0x0c, 0x000ad839, 0x000b1c72, 0x00031c72, 0x0000e595, 0, 0, 0, 0 },
  { 0x0d, 0x000b5080, 0x000b1c72, 0x00031c72, 0x0000e595, 0, 0, 0, 0 },
  { 0x0e, 0x0010f8be, 0x000b1c72, 0x00031c72, 0x0000e595, 0, 0, 0, 0 },
  { 0x0f, 0x001134e2, 0x000b1c72, 0x00031c72, 0x0000e595, 0, 0, 0, 0 },
  { 0x10, 0x0005e462, 0x0006e38e, 0x00000000, 0x00006e1e, 0, 0, 0, 0 },
  { 0x11, 0x00065cab, 0x0006e38e, 0x00031c72, 0x00006e1e, 0, 0, 0, 0 },
  { 0x12, 0x0009a6a2, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x13, 0x0009a6a2, 0x000b1c72, 0x00000000, 0x00006429, 0, 0, 0, 0 },
  { 0x14, 0x0009a6a2, 0x000a0e39, 0x00000000, 0x000133e9, 0, 0, 0, 0 },
  { 0x15, 0x0009a6a2, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x16, 0x0009a6a2, 0x00092b10, 0x00000000, 0x00013670, 0, 0, 0, 0 },
  { 0x17, 0x000f42f7, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x18, 0x0008b612, 0x00000000, 0x0002b8e5, 0x00000000, 0, 0, 0, 0 },
  { 0x19, 0x000a1eee, 0x000b1c72, 0x00031c72, 0x00012aab, 0, 0, 0, 0 },
  { 0x1a, 0x000d68e2, 0x0006e38e, 0x00000000, 0x00012aab, 0, 0, 0, 0 },
  { 0x1b, 0x000d68e2, 0x0006e38e, 0x00000000, 0x00012aab, 0, 0, 0, 0 },
  { 0x1c, 0x0009a6a2, 0x000871c7, 0x00018e39, 0x000087b7, 0, 0, 0, 0 },
  { 0x1d, 0x00107377, 0x000ad8fe, 0x00000000, 0x0000c375, 0, 0, 0, 0 },
  { 0x1e, 0x00125497, 0x000ad8fe, 0x00000000, 0x0000c375, 0, 0, 0, 0 },
  { 0x1f, 0x000e5972, 0x000bb60e, 0x0000c71e, 0x0000c42e, 0, 0, 0, 0 },
  { 0x20, 0x0004f3d2, 0x0006e38e, 0x00000000, 0x00000000, 2, C_20_Kerning, 0, 0 },
  { 0x21, 0x0005e462, 0x000b1c72, 0x00000000, 0x0000c42e, 0, 0, 1, C_21_Ligature },
  { 0x22, 0x0009a6a2, 0x000b1c72, 0x00000000, 0x0000c42e, 0, 0, 0, 0 },
  { 0x23, 0x000f4a02, 0x000b1c72, 0x00031c72, 0x00011102, 0, 0, 0, 0 },
  { 0x24, 0x000e1560, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x25, 0x000f4a02, 0x000c0000, 0x0000e38e, 0x00011102, 0, 0, 0, 0 },
  { 0x26, 0x000e5972, 0x000b1c72, 0x00000000, 0x00006429, 0, 0, 0, 0 },
  { 0x27, 0x0005e462, 0x000b1c72, 0x00000000, 0x0000c42e, 2, C_27_Kerning, 1, C_27_Ligature },
  { 0x28, 0x0007c582, 0x000c0000, 0x00040000, 0x000087b7, 0, 0, 0, 0 },
  { 0x29, 0x0007c582, 0x000c0000, 0x00040000, 0x000087b7, 0, 0, 0, 0 },
  { 0x2a, 0x0009a6a2, 0x000c0000, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x2b, 0x000e5972, 0x0009a360, 0x0001a360, 0x000087b7, 0, 0, 0, 0 },
  { 0x2c, 0x0005e462, 0x0001d75e, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x2d, 0x0006d4f2, 0x0006e38e, 0x00000000, 0x00006429, 0, 0, 1, C_2d_Ligature },
  { 0x2e, 0x0005e462, 0x0001d75e, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x2f, 0x0009a6a2, 0x000c0000, 0x00040000, 0x000087b7, 0, 0, 0, 0 },
  { 0x30, 0x0009a6a2, 0x000a4fa5, 0x00000000, 0x00012aab, 0, 0, 0, 0 },
  { 0x31, 0x0009a6a2, 0x000a4fa5, 0x00000000, 0x00012aab, 0, 0, 0, 0 },
  { 0x32, 0x0009a6a2, 0x000a4fa5, 0x00000000, 0x00012aab, 0, 0, 0, 0 },
  { 0x33, 0x0009a6a2, 0x000a4fa5, 0x00000000, 0x00012aab, 0, 0, 0, 0 },
  { 0x34, 0x0009a6a2, 0x000a4fa5, 0x00031c72, 0x00012aab, 0, 0, 0, 0 },
  { 0x35, 0x0009a6a2, 0x000a4fa5, 0x00000000, 0x00012aab, 0, 0, 0, 0 },
  { 0x36, 0x0009a6a2, 0x000a4fa5, 0x00000000, 0x00012aab, 0, 0, 0, 0 },
  { 0x37, 0x0009a6a2, 0x000a4fa5, 0x00031c72, 0x00012aab, 0, 0, 0, 0 },
  { 0x38, 0x0009a6a2, 0x000a4fa5, 0x00000000, 0x00012aab, 0, 0, 0, 0 },
  { 0x39, 0x0009a6a2, 0x000a4fa5, 0x00000000, 0x00012aab, 0, 0, 0, 0 },
  { 0x3a, 0x0005e462, 0x0006e38e, 0x00000000, 0x0000c375, 0, 0, 0, 0 },
  { 0x3b, 0x0005e462, 0x0006e38e, 0x00031c72, 0x0000c375, 0, 0, 0, 0 },
  { 0x3c, 0x0005e462, 0x00080000, 0x00031c72, 0x00010a90, 0, 0, 0, 0 },
  { 0x3d, 0x000e5972, 0x00062530, 0xfffe2530, 0x00011102, 0, 0, 0, 0 },
  { 0x3e, 0x0009a6a2, 0x00080000, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x3f, 0x0009a6a2, 0x000b1c72, 0x00000000, 0x0000c855, 0, 0, 1, C_3f_Ligature },
  { 0x40, 0x000e5972, 0x000b1c72, 0x00000000, 0x0000c855, 0, 0, 0, 0 },
  { 0x41, 0x000ddaab, 0x000ad8fe, 0x00000000, 0x00000000, 28, C_41_Kerning, 0, 0 },
  { 0x42, 0x000d2980, 0x000ad8fe, 0x00000000, 0x000133e9, 0, 0, 0, 0 },
  { 0x43, 0x000d68e2, 0x000ad8fe, 0x00000000, 0x000133e9, 0, 0, 0, 0 },
  { 0x44, 0x000e1a10, 0x000ad8fe, 0x00000000, 0x0000c42e, 5, C_44_Kerning, 0, 0 },
  { 0x45, 0x000cb137, 0x000ad8fe, 0x00000000, 0x0000c375, 0, 0, 0, 0 },
  { 0x46, 0x000c38f0, 0x000ad8fe, 0x00000000, 0x0000f2cb, 10, C_46_Kerning, 0, 0 },
  { 0x47, 0x000e75e5, 0x000ad8fe, 0x00000000, 0x00013670, 0, 0, 0, 0 },
  { 0x48, 0x000ddaab, 0x000ad8fe, 0x00000000, 0x00006429, 0, 0, 0, 0 },
  { 0x49, 0x000746bb, 0x000ad8fe, 0x00000000, 0x00006e1e, 0, 0, 0, 0 },
  { 0x4a, 0x0009df87, 0x000ad8fe, 0x00000000, 0x0000f05b, 0, 0, 0, 0 },
  { 0x4b, 0x000e52f5, 0x000ad8fe, 0x00000000, 0x000133e9, 4, C_4b_Kerning, 0, 0 },
  { 0x4c, 0x000bc0a7, 0x000ad8fe, 0x00000000, 0x00000000, 11, C_4c_Kerning, 0, 0 },
  { 0x4d, 0x0010ac5b, 0x000ad8fe, 0x00000000, 0x00006429, 0, 0, 0, 0 },
  { 0x4e, 0x000ddaab, 0x000ad8fe, 0x00000000, 0x00006429, 0, 0, 0, 0 },
  { 0x4f, 0x000e5972, 0x000ad8fe, 0x00000000, 0x0000c42e, 5, C_4f_Kerning, 0, 0 },
  { 0x50, 0x000cb137, 0x000ad8fe, 0x00000000, 0x000133e9, 1, C_50_Kerning, 0, 0 },
  { 0x51, 0x000e5972, 0x000ad8fe, 0x00031c72, 0x0000c42e, 0, 0, 0, 0 },
  { 0x52, 0x000da1c7, 0x000ad8fe, 0x00000000, 0x000067d2, 28, C_52_Kerning, 0, 0 },
  { 0x53, 0x000a9732, 0x000ad8fe, 0x00000000, 0x0000c375, 0, 0, 0, 0 },
  { 0x54, 0x000d68e2, 0x000ad8fe, 0x00000000, 0x0000f2cb, 7, C_54_Kerning, 0, 0 },
  { 0x55, 0x000ddaab, 0x000ad8fe, 0x00000000, 0x00006429, 0, 0, 0, 0 },
  { 0x56, 0x000ddaab, 0x000ad8fe, 0x00000000, 0x0000c42e, 10, C_56_Kerning, 0, 0 },
  { 0x57, 0x00128d7b, 0x000ad8fe, 0x00000000, 0x0000c42e, 1, C_57_Kerning, 0, 0 },
  { 0x58, 0x000ddaab, 0x000ad8fe, 0x00000000, 0x00006e1e, 4, C_58_Kerning, 0, 0 },
  { 0x59, 0x000ddaab, 0x000ad8fe, 0x00000000, 0x0000e595, 6, C_59_Kerning, 0, 0 },
  { 0x5a, 0x000b87c2, 0x000ad8fe, 0x00000000, 0x000133e9, 0, 0, 0, 0 },
  { 0x5b, 0x0005e462, 0x000c0000, 0x00040000, 0x0000c855, 0, 0, 0, 0 },
  { 0x5c, 0x0009a6a2, 0x000b1c72, 0x00000000, 0x0000c375, 0, 0, 0, 0 },
  { 0x5d, 0x0005e462, 0x000c0000, 0x00040000, 0x00010a90, 0, 0, 0, 0 },
  { 0x5e, 0x0009a6a2, 0x000b1c72, 0x00000000, 0x0000f05b, 0, 0, 0, 0 },
  { 0x5f, 0x0005e462, 0x000ad8fe, 0x00000000, 0x00006e1e, 0, 0, 0, 0 },
  { 0x60, 0x0005e462, 0x000b1c72, 0x00000000, 0x0000c42e, 0, 0, 1, C_60_Ligature },
  { 0x61, 0x0009a6a2, 0x0006e38e, 0x00000000, 0x00006e1e, 0, 0, 0, 0 },
  { 0x62, 0x0008b612, 0x000b1c72, 0x00000000, 0x0000f2cb, 7, C_62_Kerning, 0, 0 },
  { 0x63, 0x0008b612, 0x0006e38e, 0x00000000, 0x0000c855, 7, C_63_Kerning, 0, 0 },
  { 0x64, 0x0009a6a2, 0x000b1c72, 0x00000000, 0x0000e595, 1, C_64_Kerning, 0, 0 },
  { 0x65, 0x0008b612, 0x0006e38e, 0x00000000, 0x00012aab, 7, C_65_Kerning, 0, 0 },
  { 0x66, 0x0005e465, 0x000b1c72, 0x00031c72, 0x0000f05b, 5, C_66_Kerning, 3, C_66_Ligature },
  { 0x67, 0x0008b612, 0x0006e38e, 0x00031c72, 0x000067d2, 0, 0, 0, 0 },
  { 0x68, 0x0009a6a2, 0x000b1c72, 0x00000000, 0x00006e1e, 0, 0, 0, 0 },
  { 0x69, 0x0005e462, 0x000a8209, 0x00000000, 0x0000c375, 0, 0, 0, 0 },
  { 0x6a, 0x0005e462, 0x000a8209, 0x00031c72, 0x00013670, 0, 0, 0, 0 },
  { 0x6b, 0x0008b612, 0x000b1c72, 0x00000000, 0x000067d2, 0, 0, 0, 0 },
  { 0x6c, 0x0004f3d2, 0x000b1c72, 0x00000000, 0x0000e595, 1, C_6c_Kerning, 0, 0 },
  { 0x6d, 0x000f4a02, 0x0006e38e, 0x00000000, 0x00006e1e, 0, 0, 0, 0 },
  { 0x6e, 0x000a9732, 0x0006e38e, 0x00000000, 0x00006e1e, 1, C_6e_Kerning, 0, 0 },
  { 0x6f, 0x0009a6a2, 0x0006e38e, 0x00000000, 0x0000f2cb, 7, C_6f_Kerning, 0, 0 },
  { 0x70, 0x0009a6a2, 0x0006e38e, 0x00031c72, 0x0000f2cb, 7, C_70_Kerning, 0, 0 },
  { 0x71, 0x0008b612, 0x0006e38e, 0x00031c72, 0x000067d2, 0, 0, 0, 0 },
  { 0x72, 0x000801a7, 0x0006e38e, 0x00000000, 0x000067d2, 7, C_72_Kerning, 0, 0 },
  { 0x73, 0x0007c582, 0x0006e38e, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x74, 0x00065cab, 0x0009d75e, 0x00000000, 0x0000f05b, 0, 0, 0, 0 },
  { 0x75, 0x000a1eeb, 0x0006e38e, 0x00000000, 0x00006e1e, 0, 0, 0, 0 },
  { 0x76, 0x0008b612, 0x0006e38e, 0x00000000, 0x000067d2, 0, 0, 0, 0 },
  { 0x77, 0x000c7852, 0x0006e38e, 0x00000000, 0x000067d2, 1, C_77_Kerning, 0, 0 },
  { 0x78, 0x0008b615, 0x0006e38e, 0x00000000, 0x0000e595, 0, 0, 0, 0 },
  { 0x79, 0x00092e5b, 0x0006e38e, 0x00031c72, 0x000067d2, 0, 0, 0, 0 },
  { 0x7a, 0x0007c585, 0x0006e38e, 0x00000000, 0x00010a90, 0, 0, 0, 0 },
  { 0x7b, 0x0009a6a2, 0x0006e38e, 0x00000000, 0x00011102, 0, 0, 1, C_7b_Ligature },
  { 0x7c, 0x00134d45, 0x0006e38e, 0x00000000, 0x00011102, 0, 0, 0, 0 },
  { 0x7d, 0x0009a6a2, 0x000b1c72, 0x00000000, 0x0000c855, 0, 0, 0, 0 },
  { 0x7e, 0x0009a6a2, 0x000ad8fe, 0x00000000, 0x000087b7, 0, 0, 0, 0 },
  { 0x7f, 0x0009a6a2, 0x000ad8fe, 0x00000000, 0x0000f2cb, 0, 0, 0, 0 }
};

void
cmti7_tables(TFM::Font*& _font, TFM::Dimension*& _dimension, TFM::Character*& _character)
{
  _font = &font;
  _dimension = dimension;
  _character = character;
}
