/***************************************************************************
 *   Copyright (C) 2005 by TAM(Teppei Tamra)                               *
 *   tam-t@par.odn.ne.jp                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "wordsdic.h"
using namespace Honoka;

WordsDic::WordsDic(const string &filename)
{
    fd = open(filename.c_str(),O_RDONLY);
    if (fd == -1) return;
    mmapsize = lseek(fd,0,SEEK_END);
    if (mmapsize == -1) {
        close(fd);
        fd = -1;
        return;
    }
    void *ptr = mmap(0,mmapsize,PROT_READ,MAP_PRIVATE,fd,0);
    if (ptr == MAP_FAILED) {
        close(fd);
        fd = -1;
        return;
    }
    mmapptr = (char *)ptr;
    return;
}


WordsDic::~WordsDic()
{
    if (fd != -1) {
        munmap(mmapptr,mmapsize);
        close(fd);
    }
}




/*!
    \fn Honoka::WordsDic::find(const string &word)
 */
set<string> Honoka::WordsDic::find(const string &word)
{
    set<string> res,bres;
    if (fd == -1) return res;
    if (word.length() > 255) return res;
    if (fd == -1) return res;
    char w[256],ow[256];
    for(unsigned int i = 0;i < word.length();i ++) {
        w[i] = (char)tolower(word[i]);
        ow[i] = word[i];
    }
    w[word.length()] = 0;
    ow[word.length()] = 0;
    char *p = mmapptr;
    while(p < mmapptr + mmapsize) {
        char b[256],ob[256];
        for(unsigned int i = 0;i < word.length();i ++) {
            b[i] = (char)tolower(p[i]);
            ob[i] = p[i];
        }
        if (strncmp(w,b,word.length()) == 0) {
            string s;
            for(unsigned int i = 0;p[i] != '\n';i ++) {
                if (p[i] == 0) break;
                s += p[i];
            }
            if (strncmp(ow,ob,word.length()) == 0)
                res.insert(s);
            else bres.insert(s);
        }
        while(*p != '\n') p ++;
        p ++;
    }
    for(set<string>::iterator it = bres.begin();it != bres.end();it ++) res.insert(*it);
    return res;
}
