/*
 * IIIMF-SKK, Japanese Language Engine for
 *                        IIIMF (Internet/Intranet Input Method Framework)
 *
 * Copyright (C) 2003 Motonobu Ichimura <famao@momonga-linux.org>
 * Copyright (C) 2002 Motonobu Ichimura <famao@kondara.org>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 */
                                                                                                          
/* $Id: menu.c,v 1.1.2.1 2003/08/01 13:47:53 famao Exp $ */
                                                                                                          
/* vi:set ts=4 sw=4: */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "support.h"
#include "menu.h"

GtkWidget *
menu_new (MenuEntry *entry, gpointer user_data)
{
	GtkWidget *menu;
	GtkWidget *item;
	int i;
	if (!entry)
		return NULL;
	menu = gtk_menu_new ();
	for (i = 0;  entry[i].label != NULL; i++) {
		item = gtk_menu_item_new_with_label (_(entry[i].label));
		gtk_container_add (GTK_CONTAINER (menu), item);
		gtk_object_set_data (GTK_OBJECT (menu),
				entry[i].label, (gpointer) item);
		gtk_object_set_data (GTK_OBJECT (item), "_menu_status",
				(gpointer) entry[i].data);
		if (entry[i].func) {
			gtk_signal_connect (GTK_OBJECT (item), "activate",
					GTK_SIGNAL_FUNC (entry[i].func), user_data);
		}
		gtk_widget_show (item);
	}
	return menu;
}

GtkWidget *
radio_menu_new (MenuEntry *entry, gpointer user_data)
{
	GtkWidget *menu;
	GtkAccelGroup *accel_group;
	GSList *status_group = NULL;
	GtkWidget *item;
	int i;
	if (!entry)
		return NULL;
	menu = gtk_menu_new ();
	accel_group = gtk_menu_get_accel_group (GTK_MENU (menu));
	for (i = 0; entry[i].label != NULL; i++) {
		gchar *id = NULL;
		item = gtk_radio_menu_item_new_with_label
			(status_group, _(entry[i].label));
		status_group = gtk_radio_menu_item_group (GTK_RADIO_MENU_ITEM (item));
		gtk_container_add (GTK_CONTAINER (menu), item);
		gtk_object_set_data (GTK_OBJECT (menu),
				entry[i].label, (gpointer) item);
		gtk_object_set_data (GTK_OBJECT (item), "_menu_status",
				(gpointer) entry[i].data);
		id = g_strdup_printf ("%d", entry[i].data);
		gtk_object_set_data (GTK_OBJECT (menu), id, (gpointer) item);
		g_free (id);
		if (entry[i].func) {
			gtk_signal_connect (GTK_OBJECT (item),
					"activate",
					GTK_SIGNAL_FUNC (entry[i].func), user_data);
		}
		gtk_widget_show (item);

	}
	gtk_object_set_data (GTK_OBJECT (menu), "_status_group", status_group);
	return menu;
}

void
radio_menu_add (GtkWidget *radio_menu, GtkWidget *add_item)
{
	if (!radio_menu)
		return;
	if (!add_item)
		return;
	if (!GTK_IS_RADIO_MENU_ITEM (add_item))
		return;
	if (!GTK_IS_CONTAINER (radio_menu))
		return;
	gtk_container_add (GTK_CONTAINER (radio_menu), add_item);
}

void
menu_add (GtkWidget *menu, GtkWidget *add_item)
{
	if (!menu)
		return;
	if (!add_item)
		return;
	if (!GTK_IS_MENU_ITEM (add_item))
		return;
	if (!GTK_IS_CONTAINER (menu))
		return;
	gtk_container_add (GTK_CONTAINER (menu), add_item);
}

void
radio_menu_add_entry (GtkWidget *radio_menu, MenuEntry *entry, gpointer user_data)
{
	GSList *status_group;
	GtkAccelGroup *accel_group;
	GtkWidget *item;
	gint i;
	if (!radio_menu)
		return;
	if (!entry)
		return;
	status_group = (GSList *)gtk_object_get_data (GTK_OBJECT (radio_menu), "_status_group");
	accel_group = gtk_menu_get_accel_group (GTK_MENU (radio_menu));
	for (i = 0; entry[i].label != NULL; i++) {
		item = gtk_radio_menu_item_new_with_label
			(status_group, _(entry[i].label));
		status_group = gtk_radio_menu_item_group (GTK_RADIO_MENU_ITEM (item));
		gtk_container_add (GTK_CONTAINER (radio_menu), item);
		gtk_object_set_data (GTK_OBJECT (radio_menu),
				entry[i].label, (gpointer) item);
		gtk_object_set_data (GTK_OBJECT (item), "_menu_status",
				(gpointer) entry[i].data);
		if (entry[i].func) {
			gtk_signal_connect (GTK_OBJECT (item),
					"activate",
					GTK_SIGNAL_FUNC (entry[i].func), user_data);
		}
		gtk_widget_show (item);

	}
	gtk_object_set_data (GTK_OBJECT (radio_menu), "_status_group", status_group);
}

void
menu_add_entry (GtkWidget *menu, MenuEntry *entry, gpointer user_data)
{
	GtkWidget *item;
	gint i;
	if (!menu)
		return;
	if (!entry)
		return;
	for (i = 0; entry[i].label != NULL; i++) {
		item = gtk_menu_item_new_with_label (_(entry[i].label));
		gtk_container_add (GTK_CONTAINER (menu), item);
		gtk_object_set_data (GTK_OBJECT (menu),
				entry[i].label, (gpointer) item);
		gtk_object_set_data (GTK_OBJECT (item), "_menu_status",
				(gpointer) entry[i].data);
		if (entry[i].func) {
			gtk_signal_connect (GTK_OBJECT (item),
					"activate",
					GTK_SIGNAL_FUNC (entry[i].func), user_data);
		}
		gtk_widget_show (item);
	}
}

gpointer
menu_item_get_activate_data (GtkWidget *menuitem)
{
	if (!menuitem)
		return NULL;
	if (!GTK_IS_MENU_ITEM (menuitem))
		return NULL;
	return gtk_object_get_data (GTK_OBJECT (menuitem), "_menu_status");
}

GtkWidget *
menu_find_item_by_data (GtkWidget *menu, gpointer user_data)
{
	if (!menu)
		return NULL;
	return NULL;
}

#ifdef MENU_DEBUG

static void
activate_func (GtkMenuItem *item, gpointer user_data)
{
	g_message ("activate");
}

static MenuEntry hoge[] = 
{
	{ "fuga", 1 , activate_func },
	{ "hoge", 2 , activate_func },
	{ NULL, 0 , NULL }
};

int
main (int argc, char **argv)
{
	GtkWidget *menu;
	gtk_init (&argc, &argv);
	menu = menu_new (hoge, NULL);
	gtk_menu_popup (GTK_MENU (menu),
			NULL, NULL, NULL, NULL, 0, 0);
	gtk_main ();
	return 0;
}
#endif
