//
// C++ Implementation: 
//
// Description: 
//
//
// Author: Jean-Michel PETIT <k9copy@free.fr>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//


#include "k9prefmencoder.h"
#include <qtextedit.h>
#include "k9mencodercmdgen.h"
#include <kpushbutton.h>
#include <kiconloader.h>
#include <klocale.h>

k9prefMencoder::k9prefMencoder(QWidget* parent)
: QWidget(parent)
{
   Ui_prefMencoder.setupUi(this);
   m_update=false;
   load();
   Ui_prefMencoder.btnOpt1->setIcon(SmallIcon("configure"));
   Ui_prefMencoder.btnOpt2->setIcon(SmallIcon("configure"));
   Ui_prefMencoder.btnOpt3->setIcon(SmallIcon("configure"));
   Ui_prefMencoder.btnOptA->setIcon(SmallIcon("configure"));
   Ui_prefMencoder.btnAddA->setGuiItem(KStandardGuiItem::Add);
   Ui_prefMencoder.btnAddV->setGuiItem(KStandardGuiItem::Add);
   Ui_prefMencoder.btnDeleteA->setGuiItem(KStandardGuiItem::Remove);
   Ui_prefMencoder.btnDeleteV->setGuiItem(KStandardGuiItem::Remove);
   Ui_prefMencoder.bReset->setGuiItem(KStandardGuiItem::Reset );

}

void k9prefMencoder::load() {
   Ui_prefMencoder.lbvCodecs->clear();
   for (int i=0;i < m_codecs.count();i++) {
       Ui_prefMencoder.lbvCodecs->insertItem(m_codecs.getCodecName(i));              
   }
   Ui_prefMencoder.lbvCodecs->setCurrentItem(0);

   Ui_prefMencoder.lbaCodecs->clear();
   for (int i=0;i < m_audioCodecs.count();i++) {
       Ui_prefMencoder.lbaCodecs->insertItem(m_audioCodecs.getCodecName(i));              
   }
   Ui_prefMencoder.lbaCodecs->setCurrentItem(0);

}

void k9prefMencoder::lbvCodecsCurrentChanged(Q3ListBoxItem *_item) {
   if (_item) {
        int i=Ui_prefMencoder.lbvCodecs->currentItem();            
        m_update=true;
        Ui_prefMencoder.leFourcc->setText(m_codecs.getFourcc(i));
        Ui_prefMencoder.teOpt1->setText(m_codecs.getOptions0(i));
        Ui_prefMencoder.teOpt2->setText(m_codecs.getOptions1(i));
        Ui_prefMencoder.teOpt3->setText(m_codecs.getOptions2(i));
        Ui_prefMencoder.leVLabel->setText(_item->text());
        m_update=false;
    }
}

void k9prefMencoder::lbaCodecsCurrentChanged(Q3ListBoxItem *_item) {
   if (_item) {
        int i=Ui_prefMencoder.lbaCodecs->currentItem();            
        m_update=true;
        Ui_prefMencoder.teOptA->setText(m_audioCodecs.getOptions(i));
        Ui_prefMencoder.leALabel->setText(_item->text());
        m_update=false;
    }
}

void k9prefMencoder::save()
{
   m_codecs.save();
   m_audioCodecs.save();

}

void k9prefMencoder::btnOpt1Clicked() {
   QString s=Ui_prefMencoder.teOpt1->text();
   if( k9MencoderCmdGen::getMencoderOptions(s))
        Ui_prefMencoder.teOpt1->setText(s);

}
void k9prefMencoder::btnOpt2Clicked() {
   QString s=Ui_prefMencoder.teOpt2->text();
   if( k9MencoderCmdGen::getMencoderOptions(s))
        Ui_prefMencoder.teOpt2->setText(s);

}
void k9prefMencoder::btnOpt3Clicked() {
   QString s=Ui_prefMencoder.teOpt3->text();
   if( k9MencoderCmdGen::getMencoderOptions(s))
        Ui_prefMencoder.teOpt3->setText(s);

}
void k9prefMencoder::btnOptAClicked() {
   QString s=Ui_prefMencoder.teOptA->text();
   if( k9MencoderCmdGen::getMencoderOptions(s))
        Ui_prefMencoder.teOptA->setText(s);

}

void k9prefMencoder::btnAddVClicked() {
   Ui_prefMencoder.lbvCodecs->insertItem(i18n("new profile"));
   m_codecs.setOptions0(Ui_prefMencoder.lbvCodecs->count()-1,"-ovc copy");
   m_codecs.setOptions1(Ui_prefMencoder.lbvCodecs->count()-1,"-ovc copy");
   m_codecs.setOptions2(Ui_prefMencoder.lbvCodecs->count()-1,"-ovc copy");
   m_codecs.setCodecName(Ui_prefMencoder.lbvCodecs->count()-1,i18n("new profile"));
   Ui_prefMencoder.lbvCodecs->setCurrentItem(Ui_prefMencoder.lbvCodecs->count()-1);

}

void k9prefMencoder::btnDeleteVClicked() {
   m_codecs.remove(Ui_prefMencoder.lbvCodecs->currentItem());
   Ui_prefMencoder.lbvCodecs->removeItem(Ui_prefMencoder.lbvCodecs->currentItem());
}

void k9prefMencoder::btnAddAClicked() {
   Ui_prefMencoder.lbaCodecs->insertItem(i18n("new profile"));
   m_audioCodecs.setOptions (Ui_prefMencoder.lbaCodecs->count()-1,"-oac copy");
   m_audioCodecs.setCodecName(Ui_prefMencoder.lbaCodecs->count()-1,i18n("new profile"));
   Ui_prefMencoder.lbaCodecs->setCurrentItem(Ui_prefMencoder.lbaCodecs->count()-1);

}

void k9prefMencoder::bResetClicked() {
   m_codecs.reset();
   m_audioCodecs.reset();
   load();
   Ui_prefMencoder.lbvCodecs->setCurrentItem(0);
   Ui_prefMencoder.lbaCodecs->setCurrentItem(0);
   lbvCodecsCurrentChanged (Ui_prefMencoder.lbvCodecs->item(0));
   lbaCodecsCurrentChanged (Ui_prefMencoder.lbaCodecs->item(0));


}

void k9prefMencoder::btnDeleteAClicked() {
   m_audioCodecs.remove(Ui_prefMencoder.lbaCodecs->currentItem());
   Ui_prefMencoder.lbaCodecs->removeItem(Ui_prefMencoder.lbaCodecs->currentItem());
}


void k9prefMencoder::teOptATextChanged() {
  if (!m_update)
      m_audioCodecs.setOptions(Ui_prefMencoder.lbaCodecs->currentItem(),Ui_prefMencoder.teOptA->text());
}

void k9prefMencoder::teOpt1TextChanged() {
  if (!m_update)
      m_codecs.setOptions0(Ui_prefMencoder.lbvCodecs->currentItem(),Ui_prefMencoder.teOpt1->text());
}

void k9prefMencoder::teOpt2TextChanged() {
   if (!m_update)
   m_codecs.setOptions1(Ui_prefMencoder.lbvCodecs->currentItem(),Ui_prefMencoder.teOpt2->text());

}

void k9prefMencoder::teOpt3TextChanged() {
   if (!m_update)
   m_codecs.setOptions2(Ui_prefMencoder.lbvCodecs->currentItem(),Ui_prefMencoder.teOpt3->text());

}


void k9prefMencoder::leVLabelTextChanged(const QString &_value) {
   if (!m_update) {
       Ui_prefMencoder.lbvCodecs->changeItem(_value,Ui_prefMencoder.lbvCodecs->currentItem());
       m_codecs.setCodecName(Ui_prefMencoder.lbvCodecs->currentItem(),_value);
    }
}
void k9prefMencoder::leALabelTextChanged(const QString &_value) {
   if (!m_update) {
       Ui_prefMencoder.lbaCodecs->changeItem(_value,Ui_prefMencoder.lbaCodecs->currentItem());
       m_audioCodecs.setCodecName(Ui_prefMencoder.lbaCodecs->currentItem(),_value);
    }
}

void k9prefMencoder::leFourccTextChanged(const QString &_value) {
    if (!m_update) {
        m_codecs.setFourcc(Ui_prefMencoder.lbvCodecs->currentItem(),_value);
    }
}


k9prefMencoder::~k9prefMencoder()
{
}



/*$SPECIALIZATION$*/

