//
// C++ Implementation: k9copy
//
// Description:
//
//
// Author: Jean-Michel PETIT <k9copy@free.fr>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "k9main.h"
#include "k9copy.h"
#include "k9settings.h"
#include "k9playbackoptions.h"
#include "k9langselect.h"
#include "k9config.h"
#include <kdeversion.h>
#include <kstatusbar.h>
#include <kstdaccel.h>
#include <kaction.h>
#include <KStandardAction>
#include <kedittoolbar.h>
#include "kviewmpeg2.h"
#include "k9titlefactor.h"
#include "k9mp4title.h"
#include "k9tools.h"
#include <QDockWidget>
#include "images.h"
#include <KShortcutsDialog>
#include "dvdread.h"
#include <QMenu>
#include <KActionCollection>

#include "k9importfiles.h"

k9Copy::k9Copy()
        : KXmlGuiWindow( ) {
   // accept dnd
    loadDvdread();
    m_import=NULL;

    setAcceptDrops(true);
    setDockOptions(QMainWindow::AllowTabbedDocks |QMainWindow::AnimatedDocks);
    setCorner(Qt::BottomRightCorner,Qt::RightDockWidgetArea);
    setCorner(Qt::TopRightCorner,Qt::RightDockWidgetArea);

    setCorner(Qt::BottomLeftCorner,Qt::LeftDockWidgetArea);

    // then, setup our actions
    setupActions();

    // and a status bar
    statusBar()->show();
    statusBar()->insertItem(i18n("Ready"),sbMessage,1);
    statusBar()->setItemAlignment(sbMessage,Qt::AlignLeft | Qt::AlignVCenter);

    statusBar()->insertFixedItem("",sbFactor);
    statusBar()->setItemFixed(sbFactor,100);

    createCopyWindows();
   // backupAction->setChecked(true);
    setupGUI();
}


void k9Copy::createCopyWindows() {
 /*   saveDock();
    if (m_k9ImportView) {
        m_k9ImportView->close();
        m_k9Import=NULL;
        m_k9ImportView=NULL;
    }
    removeToolWindows();
*/
    m_actions["open"]->setEnabled(true);
    m_actions["quit"]->setEnabled(true);
    m_actions["preferences"]->setEnabled(true);
    m_actions["playtitle"]->setEnabled(true);
    m_actions["copy"]->setEnabled(true);
 //   m_actions["create"]->setEnabled(false);
    m_actions["mp4"]->setEnabled(true);
    m_actions["mpeg"]->setEnabled(true);
    m_actions["eject"]->setEnabled(true);


    k9Config config;
    m_useXine=config.getUseXine();
    m_usePhonon=config.getUsePhonon();
    m_useMplayer=config.getUseMplayer();

    m_useDvdAuthor=config.getUseDvdAuthor();

    if (config.getPrefVersion() != VERSION) {
        initCodecs();
        config.read();
        config.setPrefVersion(VERSION);
        config.save();
    }


    m_k9Main=new k9Main(this,0,&m_drives);
    setCentralWidget(m_k9Main);

    m_factors =new k9TitleFactor( this);
    m_factors->setUseDvdAuthor(m_useDvdAuthor);
    QDockWidget *doc=new QDockWidget(this);//i18n("Shrink Factor"),this,Qt::Tool);
    doc->setObjectName("factors");
    doc->setFeatures(QDockWidget::DockWidgetMovable | QDockWidget::DockWidgetFloatable |QDockWidget::DockWidgetClosable );
    QDockWidget *firstDock=doc;
    doc->setWidget(m_factors);
    doc->setWindowTitle(i18n("Shrink Factor"));
    addDockWidget(Qt::BottomDockWidgetArea, doc);
 
    connect(m_k9Main,SIGNAL(SelectionChanged( k9DVD*,bool )),m_factors,SLOT(SelectionChanged( k9DVD*,bool )));
    connect(m_k9Main,SIGNAL(changedTitle( k9DVDTitle* )),m_factors,SLOT(changedTitle( k9DVDTitle* )));

    m_mp4=new k9MP4Title(this);
    doc=new QDockWidget(this);//i18n("MPEG4 Encoding Options"),this,Qt::Tool);
    doc->setObjectName("mp4title");
    doc->setFeatures(QDockWidget::DockWidgetMovable | QDockWidget::DockWidgetFloatable |QDockWidget::DockWidgetClosable);
    doc->setWidget(m_mp4);
    doc->setWindowTitle(i18n("MPEG4 Encoding Options"));
    addDockWidget(Qt::BottomDockWidgetArea, doc);
    tabifyDockWidget(firstDock,doc);

    connect(m_k9Main,SIGNAL(changedTitle( k9DVDTitle* )),m_mp4,SLOT(titleChanged( k9DVDTitle* )));
    connect(m_k9Main,SIGNAL(SelectionChanged( k9DVD*,bool )),m_mp4,SLOT(selectionChanged( k9DVD*,bool )));

    // allow the view to change the statusbar and caption

    connect(m_k9Main, SIGNAL(changeStatusbar(const QString&,int )),
            this,   SLOT(changeStatusbar(const QString&,int)));
    connect(m_k9Main, SIGNAL(changeCaption(const QString&)),
            this,   SLOT(changeCaption(const QString&)));



    doc=new QDockWidget(this);//
    doc->setObjectName("playbackoptions");
    firstDock=doc;
    doc->setFeatures(QDockWidget::DockWidgetMovable | QDockWidget::DockWidgetFloatable |QDockWidget::DockWidgetClosable);
    m_options=new k9PlaybackOptions(m_k9Main,this);
    doc->setWidget(m_options);
    doc->setWindowTitle(i18n("DVD playback options"));
    addDockWidget(Qt::RightDockWidgetArea, doc);


    m_lang=new k9LangSelect(m_k9Main,this);
    doc=new QDockWidget(this);//,this,Qt::Tool);
    doc->setObjectName("langselect");
    doc->setFeatures(QDockWidget::DockWidgetMovable | QDockWidget::DockWidgetFloatable |QDockWidget::DockWidgetClosable);
    doc->setWidget(m_lang);
    doc->setWindowTitle(i18n("Selection"));
    addDockWidget(Qt::RightDockWidgetArea, doc);
    tabifyDockWidget(firstDock,doc);
    if (m_useXine) {
  	m_mp2=new k9xine(this);
    }
    else if (m_usePhonon) {
	m_mp2=new k9Phonon(this);
    }else if (m_useMplayer)
	m_mp2=new K9Mplayer(this);
    else
        m_mp2=new kViewMPEG2(this);

    doc=new QDockWidget(this);//i18n("Preview"),this,Qt::Tool);
    doc->setObjectName("preview");
    m_dockPreview=doc;
    doc->setFeatures(QDockWidget::DockWidgetMovable | QDockWidget::DockWidgetFloatable |QDockWidget::DockWidgetClosable );
    doc->setWidget(m_mp2);
    doc->setWindowTitle(i18n("Preview"));
    addDockWidget(Qt::RightDockWidgetArea, doc);
    tabifyDockWidget(firstDock,doc);

    connect(m_k9Main,SIGNAL(showPreview( k9DVD*, k9DVDTitle*,int )),m_mp2,SLOT(open( k9DVD*, k9DVDTitle*,int )));
    connect(m_k9Main,SIGNAL(stopPreview()),m_mp2,SLOT(bStopClick()));



    setAutoSaveSettings();
//    KSimpleConfig settings("K9Copy");
//    if (settings.hasGroup("dock"))
//        dockManager->readConfig((KConfig*)&settings,"dock");
}

void k9Copy::removeToolWindows() {
/*    for (KMdiToolViewAccessor *acc=m_ToolViews.first();acc;acc=m_ToolViews.next()) {
        deleteToolWindow(acc);
    }
    m_ToolViews.clear();
*/
}

void k9Copy::createImportWindows() {
    if (!m_import)
       m_import=new k9ImportFiles(this);    
    m_import->show();
    hide();
}


k9Copy::~k9Copy() {
    k9Config config;
    if (config.getPrefDelTmpFiles())
        k9Tools::clearOutput(config.getPrefOutput()+"/dvd");
}

void k9Copy::initCodecs() {
    k9VideoCodecs v(NULL);
    v.reset();
    k9AudioCodecs a(NULL);
    a.reset();
}

bool k9Copy::queryClose   (    ) {
    return true;
}

void k9Copy::setupActions() {

    m_actions["open"]=KStandardAction::open(this, SLOT(fileOpen()), (QObject*)actionCollection());
    m_actions["quit"]=KStandardAction::quit(this, SLOT(quit()),(QObject*) actionCollection());
    m_actions["preferences"]=KStandardAction::preferences(this,SLOT(preferences()),(QObject*)actionCollection());
    KStandardAction::keyBindings(this, SLOT(optionsConfigureKeys()), (QObject*)actionCollection());
   KStandardAction::configureToolbars(this, SLOT(optionsConfigureToolbars()), (QObject*)actionCollection());


    setStandardToolBarMenuEnabled(TRUE);
    createStandardStatusBarAction();

    //PlayTitleAction = new KAction(i18n("Play title"),(QObject*)actionCollection());
//, SLOT(ActionPlayTitle()),"PlayTitle"
    QPixmap img;
    img.loadFromData( img_preview, sizeof( img_preview ), "PNG" );
  //  PlayTitleAction->setIcon(QIcon(img));
    PlayTitleAction = new KAction(KIcon(img), i18n("Play title"), this);
    actionCollection()->addAction( "PlayTitle", PlayTitleAction );
    connect(PlayTitleAction, SIGNAL(triggered(bool)),this, SLOT(ActionPlayTitle()));
    m_actions["playtitle"]=PlayTitleAction;
   

    CopyAction = new KAction(KIcon("dvdcopy"),i18n("Copy"),this);
    actionCollection()->addAction("Copy",CopyAction);
    connect(CopyAction, SIGNAL(triggered(bool)), SLOT(ActionCopy()));
    m_actions["copy"]=CopyAction;

    extractMPEG=new KAction(KIcon("mpeg"),i18n("Extract to MPEG files"),this);
    actionCollection()->addAction("ExtractMPEG",extractMPEG);
    connect(extractMPEG, SIGNAL(triggered(bool)), SLOT(ActionMPEG()));
    m_actions["mpeg"]=extractMPEG;
 
    mkMP4Action = new KAction(KIcon("mp4"),i18n("Create MPEG-4"),this);
    actionCollection()->addAction("MakeMPEG4",mkMP4Action);
    connect(mkMP4Action, SIGNAL(triggered(bool)), SLOT(ActionMP4()));
    m_actions["mp4"]=mkMP4Action;

/*    ejectAction = new KAction(i18n("Eject"),0,
                              this, SLOT(ActionEject()),
                              actionCollection() , "Eject");
*/
    ejectAction = new KAction(KIcon("media-eject"),i18n("Eject"),this);
    actionCollection()->addAction("Eject",ejectAction);   
    connect(ejectAction, SIGNAL(triggered(bool)), SLOT(ActionEject()));

    m_actions["eject"]=ejectAction;



    authorAction = new KAction(i18n("DVD Author"),this );
    actionCollection()->addAction("author",authorAction);   
    connect(authorAction, SIGNAL(triggered(bool)), SLOT(ActionAuthor()));
    m_actions["author"]=authorAction;

    
/*    backupAction= new KRadioAction(i18n("DVD Backup"),0,
                              this, SLOT(ActionBackup()),
                              actionCollection(), "backup");

    backupAction->setExclusiveGroup("mode");
    m_actions["backup"]=backupAction;

    authorAction= new KRadioAction(i18n("DVD Author"),0,
                              this, SLOT(ActionAuthor()),
                              actionCollection(), "author");
    authorAction->setExclusiveGroup("mode");
    m_actions["author"]=authorAction;

    m_actions["create"]= new KAction(i18n("Create DVD"),0,
                              this, SLOT(ActionCreate()),
                              actionCollection(), "Create");
    m_actions["create"]->setIcon("author");
*/

}

void k9Copy::setActions( bool enabled) {
//    if (m_k9MainView) {
        m_actions["open"]->setEnabled(enabled);
        m_actions["quit"]->setEnabled(enabled);
        m_actions["preferences"]->setEnabled(enabled);
        m_actions["playtitle"]->setEnabled(enabled);
        m_actions["copy"]->setEnabled(enabled);
        m_actions["mp4"]->setEnabled(enabled);
        m_actions["mpeg"]->setEnabled(enabled);
        m_actions["eject"]->setEnabled(enabled);
        m_mp2->setEnabled(enabled);
        m_mp4->setEnabled(enabled);
        m_factors->setEnabled(enabled);
        m_lang->setEnabled(enabled);
        m_options->setEnabled(enabled);
/*    } else {
        m_actions["create"]->setEnabled(enabled);
        m_menuEdit->setEnabled(enabled);
        m_newTitle->setEnabled(enabled);
        m_chapterEdit->setEnabled(enabled);
        m_k9Import->setEnabled(enabled);
    }
*/

}

void k9Copy::optionsConfigureKeys() {
    KShortcutsDialog::configure(actionCollection());
}

void k9Copy::optionsConfigureToolbars() {
    // use the standard toolbar editor
//    saveMainWindowSettings(KGlobal::config(), autoSaveGroup());
    KEditToolBar dlg(factory());
    connect(&dlg,SIGNAL(newToolbarConfig()),this,SLOT(newToolbarConfig()));
    dlg.exec();
}

void k9Copy::newToolbarConfig() {
    // this slot is called when user clicks "Ok" or "Apply" in the toolbar editor.
    // recreate our GUI, and re-apply the settings (e.g. "text under icons", etc.)
    createGUI(0);

//    applyMainWindowSettings(KGlobal::config(), autoSaveGroup());
}

void k9Copy::fileOpen() {
    m_k9Main->Open();

}



void k9Copy::preferences() {
    k9settings settings(this,i18n("Settings"));
    settings.exec();
    k9Config config;
    m_useXine=config.getUseXine();
    m_usePhonon=config.getUsePhonon();
    m_useMplayer=config.getUseMplayer();

//    if (m_k9MainView) {
        m_k9Main->readSettings();
        m_mp2->close();
        if (m_useMplayer)
            m_mp2=new K9Mplayer(this);
	else if (m_useXine)
	    m_mp2=new k9xine(this);
 	else if (m_usePhonon)
	    m_mp2=new k9Phonon(this);
        else
             m_mp2=new kViewMPEG2(this);
	m_dockPreview->setWidget(m_mp2);

        connect(m_k9Main,SIGNAL(showPreview( k9DVD*, k9DVDTitle*,int )),m_mp2,SLOT(open( k9DVD*, k9DVDTitle*,int )));
        connect(m_k9Main,SIGNAL(stopPreview()),m_mp2,SLOT(bStopClick()));
        m_mp4->load();
  //  }
}


void k9Copy::ActionCopy() {
    if (m_useMplayer)
        ((K9Mplayer*)m_mp2)->bStopClick();
    else if (m_useXine)
	((k9xine*)m_mp2)->bStopClick();
    else if (m_usePhonon)
	((k9Phonon*)m_mp2)->bStopClick();
    else
        ((kViewMPEG2*)m_mp2)->bStopClick();
    m_k9Main->Copy();
}

void k9Copy::ActionPlayTitle() {
//    m_previewAcc->show();
    m_k9Main->PreviewTitle();

}

void k9Copy::ActionMP4() {
    m_k9Main->CreateMP4();
}

void k9Copy::ActionMPEG() {
    m_k9Main->extractMPEG2();
}


void k9Copy::ActionEject() {
    m_k9Main->eject();
}

void k9Copy::ActionBackup() {
   createCopyWindows();
}

void k9Copy::ActionAuthor() {
    createImportWindows();
}

void k9Copy::ActionCreate() {
//    m_k9Import->execute();
}

/*KMdiToolViewAccessor * k9Copy::setToolWindow(QWidget *_widget,KDockWidget::DockPosition _pos,const QString &tabToolTip,const QString &tabCaption) {
    KMdiToolViewAccessor *acc=addToolWindow(_widget, _pos, getMainDockWidget(),0,tabToolTip,tabCaption);
    m_ToolViews.append(acc);
    return acc;
}

void k9Copy::removeToolWindow(KMdiToolViewAccessor *toolWin) {
    deleteToolWindow(toolWin);
    m_ToolViews.removeRef(toolWin);
}

*/
void k9Copy::changeStatusbar(const QString& text,int id) {
    // display the text on the statusbar
    statusBar()->changeItem(text,id);
}

void k9Copy::changeCaption(const QString& text) {
    // display the text on the caption
    setCaption(text);
}

void k9Copy::clone( QString _input,QString _output) {
    show();
    m_k9Main->Clone( _input,_output);
}

void k9Copy::setInput(QString _input) {
    m_k9Main->setInput(_input);
}

void k9Copy::setOutput(QString _output) {
    m_k9Main->setOutput(_output);
}


void k9Copy::quit() {
    close( );
}

void k9Copy::saveDock() {
//    KConfig config("K9Copy");
//    if (m_k9MainView) {
//        dockManager->writeConfig(&config,"dock");
//        m_k9Main->saveSettings();
//    } else if (m_k9ImportView) {
//        dockManager->writeConfig(&config,"dockImport");
//    }
}

void k9Copy::closeEvent( QCloseEvent* ce ) {
    m_k9Main->saveSettings();
    saveAutoSaveSettings();
    ce->accept();
    kapp->quit();
}

void k9Copy::setEnabledCreateDVD(bool _state) {
//	m_actions["create"]->setEnabled(_state);
}

