/***************************************************************************
*   Copyright (C) 2004 by  ͤ                                            *
*   tasuku@linux-life.net                                                 *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#include "dlgopen.h"
#include "anthy.h"
#include "canna.h"

#include <kapplication.h>
#include <kconfig.h>
#include <kdebug.h>
#include <klocale.h>
#include <kiconloader.h>
#include <qstringlist.h>

dlgOpen::dlgOpen( QWidget *parent, const char *name )
		: KDialogBase(KDialogBase::Swallow, i18n("Open"), Ok|Cancel, Ok, parent, name, true )
{
	setIcon( SmallIcon( "fileopen" ) );
	lstDicList = new KListBox( this );

	connect( lstDicList, SIGNAL( executed( QListBoxItem* ) ) , this, SLOT( slotOk() ) );
	connect( lstDicList, SIGNAL( returnPressed( QListBoxItem* ) ), this, SLOT( slotOk() ) );
	connect( lstDicList, SIGNAL( selectionChanged() ), this, SLOT( slotEnableButtonOK() ) );
	enableButtonOK( false );

	setMainWidget( lstDicList );

	resize( configDialogSize( "dlgOpen" ) );
}

dlgOpen::~dlgOpen()
{
	saveDialogSize( "dlgOpen" );
}

void dlgOpen::setDictionaryType( Dictionary::DictionaryType dictype )
{
	switch( dictype ){
		case Dictionary::Canna:
			lstDicList->insertStringList( Canna::lsdic() );
			break;
		case Dictionary::Anthy:
			lstDicList->insertStringList( Anthy::lsdic() );
			break;
		default:
			break;
	}
}

QString dlgOpen::dicname()
{
	return lstDicList->currentText();
}

void dlgOpen::slotEnableButtonOK()
{
	enableButtonOK( true );
}

bool dlgOpen::queryClose()
{
	if( lstDicList->currentItem() ){
		return true;
	}else{
		return false;
	}
}
