/***************************************************************************
*   Copyright (C) 2004 by  ͤ                                            *
*   tasuku@linux-life.net                                                 *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#ifndef DLGEDIT_H
#define DLGEDIT_H

#include "worditem.h"
#include "cannadic.h"
#include <kdialogbase.h>
#include <kcombobox.h>
#include <klineedit.h>
#include <klocale.h>
#include <qstring.h>
#include <knuminput.h>
#include <qwidgetstack.h>
#include <qcheckbox.h>
#include <qlabel.h>

class dlgEdit : public KDialogBase
{
	Q_OBJECT
public:
	enum EditModes { APPEND, EDIT, MULTIEDIT };

	dlgEdit( QWidget *parent = 0, const char *name = 0 );
	~dlgEdit();
	void setTo( QString to ){ txtTo->setText( to ); };
	void setEditMode( EditModes mode, bool blFreqEnabled );
	void setWordItem( WordItem* word );
	Word word();

	void addType( Type type );
	bool isTypeEnabled(){ return chkType->isEnabled(); }
	bool isFreqEnabled(){ return chkFreq->isEnabled(); }

public slots:
	void slotOk();
	void slotChangeEnabled();

private:
	bool isError();

	QValueList<Type> m_type;
	CannaDic* m_cannadic;
	KLineEdit* txtFrom;
	KLineEdit* txtTo;
	QWidgetStack* wstType;
	QLabel* lblType;
	QCheckBox* chkType;
	KComboBox* cbxType;
	QWidgetStack* wstFreq;
	QLabel* lblFreq;
	QCheckBox* chkFreq;
	KIntNumInput* iniFreq;
	bool m_isFreq;
};

#endif //DLGEDIT_H
