/* 
 *  Copyright (C) 2004 Girish Ramakrishnan All Rights Reserved.
 *	
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 */

// $Id: customtraylabel.h,v 1.8 2005/02/09 03:38:00 cs19713 Exp $

#ifndef _CUSTOMTRAYLABEL_H
#define _CUSTOMTRAYLABEL_H

#include <qaction.h>
#include "qtraylabel.h"

class QStringList;
class QPopupMenu;
class QString;
class QSettings;
class QWidget;
class QDropEvent;

class CustomTrayLabel : public QTrayLabel
{
  Q_OBJECT

public:
  CustomTrayLabel(Window w, QWidget* p = 0, const QString& t = QString::null);
  CustomTrayLabel(const QStringList& argv, pid_t pid, QWidget* parent = 0);

  // Session management
  bool saveState(QSettings& settings);
  bool restoreState(QSettings& settings);

  bool isLaunchOnStartup(void) const   { return mAutoLaunch->isOn(); }
  bool isDockWhenObscured(void) const { return mDockWhenObscured->isOn(); }
  
  void setAppName(const QString& name);

public slots:
  // overridden to update our menu
  void setDockWhenMinimized(bool dwm);
  void setSkipTaskbar(bool skip);

  void setLaunchOnStartup(bool launch);
  void setDockWhenObscured(bool dock) { mDockWhenObscured->setOn(dock); }
  void enableSessionManagement(bool sm) { mSessionManagement->setOn(sm); }
  
protected:
  void dropEvent(QDropEvent *ev);
  bool canUnsubscribeFromRoot(void);
  void mapEvent(void);
  void obscureEvent(void);
  void destroyEvent(void);
  void mouseReleaseEvent(QMouseEvent * ev);
  bool canDockWindow(Window w);
  void processDead(void);

private slots:
  void setCustomIcon(void);
  void updateMenu();
  void slotSetBalloonTimeout(void);
  void slotSetLaunchOnStartup(void);
  
private:
  void installMenu();
  bool mUndockWhenDead;
  QPopupMenu *mOptionsMenu, *mMainMenu;
  QAction *mDockOnRestore, *mAutoLaunch, *mBalloonTimeout, *mSkipTaskbar,
          *mDockWhenMinimized, *mDockWhenObscured, *mSessionManagement;
  int mShowId;
};

#endif // _CUSTOMTRAYLABEL_H
