/***************************************************************************
*   Copyright (C) 2004 by Kita Developers                                 *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef _KITAWRITEDIALOG_H_
#define _KITAWRITEDIALOG_H_

#include <qwidget.h>
#include <kio/job.h>
#include <kparts/browserextension.h>

#include "writedialogbase.h"

class KitaHTMLPart;
class QCp932Codec;

/* mode */
enum{
    WRITEMODE_NORMAL,
    WRITEMODE_NEWTHREAD
};


/**
 * 
 * Hideki Ikemoto
 **/
class KitaWriteView : public KitaWriteDialogBase
{
    Q_OBJECT

    QCString m_array;
    bool m_error;
    KitaHTMLPart *m_preview;
    KURL m_datURL;
    KURL m_bbscgi;
    int m_bbstype;
    int m_mode;

    static QCp932Codec* m_cp932Codec;

    char *cookie_type;
    char *cookie_value;

public:

    KitaWriteView( QWidget* parent, const char* name, const KURL& url, int mode, const QString& newThreadName = QString::null );
    virtual ~KitaWriteView();
    void setMessage( const QString& bodyStr );
    void insertMessage( const QString& str );

    const QString name() const;
    const QString mail() const;
    const QString body() const;
    const KURL datURL() const;

public slots:

    virtual void setFocus();
    void slotPostMessage();
    void slotCancel();
    void slotEnableWriting( bool enable );


private slots:

    void slotRecieveData( KIO::Job*, const QByteArray& );
    void slotPostFinished( KIO::Job* );
    void slotCurrentChanged ( QWidget * w );
    void find_cookie_typevalue( const char *response );
    bool slotBodyTextChanged();

private:

    QString setPostStr();
    QString setJBBSPostStr();
    QString setFlashCGIPostStr();
    void logPostMessage();
    int resultCode( const QString& response ) const;
    QString resultMessage( const QString& response ) const;
    QString resultTitle( const QString& response ) const;
    void set2chCookieStr( KIO::TransferJob* job );


signals:

    void postFinished( KIO::Job* );
    void postResponse( const QString& response, const KURL& bbscgi = KURL() );
    void openURLRequestExt( const KURL& url, const KParts::URLArgs& args = KParts::URLArgs(),
                            QString mimetype = QString::null,
                            int usr1 = 0,
                            const KURL& usrUrl1 = KURL() );
    void closeCurrentTab();
};
#endif
