/***************************************************************************
 *   Copyright (C) 2008 by Joerg Zopes   *
 *   joerg.zopes@linux-specialist.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef WIFISTARTUP_H
#define WIFISTARTUP_H

#include <qmultilineedit.h>
#include <qpushbutton.h>
#include <qfiledialog.h>
#include <qmessagebox.h>
#include <qprocess.h>
#include <qtooltip.h>
#include <qdialog.h>
#include <qlabel.h>
#include <cstdlib>
#include <cstring>

/**
    @author Joerg Zopes <joerg.zopes@linux-specialist.com>
 */
class wifiStartup : public QDialog
{
    Q_OBJECT
    public:
        wifiStartup(QWidget *parent = 0, const char *name = 0, QString startupScript = "");
        ~wifiStartup();
    private:
        QProcess        * scriptProcess;
        QMultiLineEdit  * scriptOutput;
        QString           script;
        QPushButton     * exportScriptButton;
        QPushButton     * startScriptButton;
        QPushButton     * doneButton;
        QLabel          * headLine;
        QLabel          * debugLabel;

        void initDialog();

    private slots:
        void slot_scriptProcessCanReadStdout();
        void slot_exportScriptButtonClicked();
        void slot_startScriptButtonClicked();
        void slot_scriptProcessExited();
        void slot_doneButtonClicked();
};

#endif
