/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kkakabc.h"

#include <klocale.h>
#include <kabc/stdaddressbook.h>

#include "kkacontactdata.h"
#include "kkatreeview.h"
#include "kkagroup.h"
#include "kkahomeaddress.h"
#include "kkaofficeaddress.h"

using namespace KKAddressBook;

void KKAKABC::doImport( KKATreeView* tvw )
{
	QString basename = i18n( "KAddressBook" );
	KKAGroup* group = new KKAGroup( tvw );
	int i = getGroupNo( tvw, basename );
	group->setText( 0, basename + ( i == 0 ? QString( "" ) : QString::number( i ) ) );

	KABC::StdAddressBook* address = KABC::StdAddressBook::self();
	for( KABC::AddressBook::ConstIterator it = address->begin(); it != address->end(); ++it )
	{
		KKAContactData* data = new KKAContactData( tvw );
		setData( data, *it );
		group->addImportData( data );
	}
	tvw->setCurrentItem( group );
}

int KKAKABC::getGroupNo( KKATreeView* tvw, const QString& basename )
{
	int i = 0;
	bool bl = false;
	while( !bl )
	{
		bl = true;
		for( QListViewItem* item = tvw->firstChild(); item; item = item->nextSibling() )
		{
			if( item->text( 0 ) == basename + ( i == 0 ? QString( "" ) : QString::number( i ) ) )
			{
				bl = false;
				break;
			}
		}
		if( !bl ) i++;
	}
	return i;
}

void KKAKABC::setData( KKAContactData* to, const KABC::Addressee& from )
{
	to->setPrefix( from.prefix() );
	to->setName( from.name() );
	to->setSuffix( from.suffix() );
	
	setAddress( to->home(), from.address( KABC::Address::Home ) );
	setAddress( to->office(), from.address( KABC::Address::Work ) );
	to->office()->setPost( from.role() );
	to->office()->setCorporation( from.organization() );
}

void KKAKABC::setAddress( KKAAddressData* to, KABC::Address from )
{
	QString country = KABC::Address::countryToISO( from.country() );
	to->setCountry( country );
	if( country == "jp" )
	{
		to->setZipcode( from.postalCode().replace( "-", "" ) );
		to->setAddress( from.region() + from.locality() + from.street() );
	}
	else
	{
		to->setZipcode( from.postalCode() );
		to->setAddress( from.street() + " " + from.locality() + " " + from.region() );
	}
	to->setPreference( from.type() & KABC::Address::Pref );
}

void KKAKABC::doExport( KKATreeView* tvw )
{
}
