/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kkdimageitem.h"
#include <kmdcodec.h>
#include <kdebug.h>
using namespace KKDesigner;

KKDImageItem::KKDImageItem( const QPoint& l, const QSize& s, QObject* parent )
	: KKDItemBase( l.x(), l.y(), s.width(), s.height(), parent )
	, m_image()

{
	connect( this, SIGNAL( sizeChanged() ), this, SLOT( resizeImage() ) );
}

KKDImageItem::KKDImageItem( const QPoint& l, const QImage& i, QObject* parent )
	: KKDItemBase( l.x(), l.y(), i.width(), i.height(), parent )
	, m_image( i )
{
	connect( this, SIGNAL( sizeChanged() ), this, SLOT( resizeImage() ) );
}

KKDImageItem::KKDImageItem( QDomElement e, QObject* parent )
	: KKDItemBase( e, parent )
{
	if( e.hasAttribute( "image" ) && !e.attribute( "image" ).isEmpty() )
	{
		QByteArray borg, bdec;
		borg = e.attribute( "image" ).utf8();
		KCodecs::base64Decode( borg, bdec );
		QDataStream stream( bdec, IO_ReadOnly );
		stream >> m_image;
		m_resizedImage = m_image.smoothScale( size() );
	}
	connect( this, SIGNAL( sizeChanged() ), this, SLOT( resizeImage() ) );
}

KKDImageItem::KKDImageItem( const KKDImageItem* item, QObject* parent )
	: KKDItemBase( item, parent )
	, m_image( item->m_image )
{
	connect( this, SIGNAL( sizeChanged() ), this, SLOT( resizeImage() ) );
}

KKDImageItem::~KKDImageItem()
{
}

//BEGIN Properties
void KKDImageItem::setImage( const QImage& i )
{
	if( locked() ) return;
	m_image = i;
	resizeImage();
	emit repaint( rect() );
	emit imageChanged();
}
//END Properties

void KKDImageItem::resizeImage()
{
	if( !m_image.isNull() )
	{
		m_resizedImage = m_image.smoothScale( size() );
	}
	else
	{
		m_resizedImage = m_image;
	}
}

QDomElement KKDImageItem::toElement( QDomDocument& doc, const QString& t )
{
	QString tag( t == QString::null ? tagName() : t );
	QDomElement elem = KKDItemBase::toElement( doc, tag );
	if( !m_image.isNull() )
	{
		QByteArray borg, benc;
		QDataStream stream( borg, IO_WriteOnly );
		stream << m_image;
		KCodecs::base64Encode( borg, benc );
		elem.setAttribute( "image", benc );
	}
	return elem;
}

void KKDImageItem::drawItemBefore( QRect& r, QPainter& p, DrawMode m, const KKAddressBook::KKAContactData* d )
{
	KKDItemBase::drawItemBefore( r, p, m, d );
	if( !m_image.isNull() && ( m != PrintMode || imagePrint() ) )
	{
		p.drawImage( r, m_resizedImage );
	}
}

void KKDImageItem::drawItemAfter( QRect& r, QPainter& p, DrawMode m, const KKAddressBook::KKAContactData* d )
{
	KKDItemBase::drawItemAfter( r, p, m, d );
}
