/***************************************************************************
 *
 *   KYum - a KDE GUI for yum
 *
 *   Copyright (C) 2005 by Steffen Offermann
 *   steffen_ac@yahoo.com
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#ifndef Process_H_Included
#define Process_H_Included

#include <qprocess.h>

class Process : public QProcess
  {
    public:
                  Process (QObject * pParent = 0, const char * pName = 0);
                  Process (const QString & arg0, QObject * pParent = 0, const char * pName = 0);
                  Process (const QStringList & args, QObject * pParent = 0, const char * pName = 0);
      virtual   ~ Process ();

      QString     getCmdLine() const;

      QString     getCmdName() const;
  };


inline Process::Process (QObject * pParent, const char * pName)
  : QProcess(pParent, pName)
{
}


inline Process::Process(const QString & arg0, QObject * pParent, const char * pName)
  : QProcess(arg0, pParent, pName)
{
}


inline Process::Process(const QStringList & args, QObject * pParent, const char * pName)
  : QProcess(args, pParent, pName)
{
}



#endif
