/***************************************************************************
 *
 *   KYum - a KDE GUI for yum
 *
 *   Copyright (C) 2005 by Steffen Offermann
 *   steffen_ac@yahoo.com
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#include <qlayout.h>
#include <qsplitter.h>

#include <klocale.h>
#include <kmessagebox.h>

#include "KYumView.h"
#include "KYumConf.h"
#include "OptionsWidget.h"
#include "OptionsView.h"
#include "YumConfView.h"
#include "YumConfTab.h"

/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

YumConfTab::YumConfTab(QWidget * pParent)

  : QWidget(pParent, "YumConfTab")

{
    QHBoxLayout * pTopLayout = new QHBoxLayout(this);
    pTopLayout->setAutoAdd(true);

    //
    // Splitter between plain text editor and table editor
    //
    QSplitter * pHSplitter = new QSplitter(this);
    pHSplitter->setOrientation(QSplitter::Horizontal);

    m_pOptionsView = new OptionsView(pHSplitter);
    m_pYumConfView = new YumConfView(pHSplitter);

    connect(m_pOptionsView, SIGNAL(optionChanged(QString, QString)),
            this,           SLOT(slotOptionChanged(QString, QString)));

    KYumConf & yumConf = KYumView::getKYumView()->getYumConf();

    connect(&yumConf, SIGNAL(mainCfgLoaded()), this, SLOT(slotConfigChanged()));
}


/***************************************************************************/
/**
 *  The yum configuration has changed (in memory), so we need to update
 *  the respective table view to reflect the changes.
 *
 ***************************************************************************/

void YumConfTab::updateOptionTable(const CfgGroup * pGroup)
{
    QStringList items;

    if ( pGroup )
        pGroup->getItemNames(items);

    //
    // Remove all current values from the table...
    //
    m_pOptionsView->setDefaults();

    //
    // Then add/overwrite with items from pGroup...
    //
    if ( pGroup )
        m_pOptionsView->setOptions(pGroup);
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

void YumConfTab::slotOptionChanged(QString strKey, QString strValue)
{
    KYumConf &    yumConf   = KYumView::getKYumView()->getYumConf();
    CfgGroup::Ptr ptrGroup  = yumConf.getGroup("main");

    if ( ptrGroup.isValid() )
    {
        QString strOldValue = ptrGroup->getValue(strKey);

        //
        // If the location where repositories are stored has been changed,
        // we will save the repositories that are currently displayed and
        // then replace the list of repositories with those found in the
        // new directory.
        //
        if ( strKey == "reposdir" && strValue != strOldValue
               /*&& 0 < number of repos displayed */ )
        {
            QString strMsg = i18n("You have changed the location for yum's repositories.\n"
                                  "KYum will save your modifications to the repositories \n"
                                  "in the previously defined location before loading the \n"
                                  "contents of the new directory.");

            KMessageBox::information(0, strMsg, "KYum Information");

            if ( yumConf.saveRepos() )
            {
                //
                // Update yum.conf in memory...
                //
                ptrGroup->setValue(strKey, strValue);

                //
                // Notify YumConfView to reflect the changes...
                //
                m_pYumConfView->configChanged(true);

                //
                // ... and finally load repositories found in the new location...
                //
                yumConf.loadRepos();
            }
        }
        else
        {
            ptrGroup->setValue(strKey, strValue);
            m_pYumConfView->configChanged(true);
        }
    }
}


/***************************************************************************/
/**
 *  The (in-memory-) contents of yum.conf have changed.
 *
 ***************************************************************************/

void YumConfTab::slotConfigChanged()
{
    KYumConf & yumConf = KYumView::getKYumView()->getYumConf();
    updateOptionTable(yumConf.getGroup("main"));
}


#include "YumConfTab.moc"
