/*
    libfame - Fast Assembly MPEG Encoder Library
    Copyright (C) 2000-2001 Vivien Chappelier

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

FAME_ALIGNED short const _mmx_128[] = { 128, 128, 128, 128 };
FAME_ALIGNED char const _mmx_128c[] = { 128, 128, 128, 128, 128, 128, 128, 128 };
FAME_ALIGNED short const _mmx_1[] = { 1, 1, 1, 1 };

/* AA&N coefficients */
/* 2*cos(4pi/16) */
/* 2*(cos(2pi/16)-cos(6pi/16)) */
/* 2*(cos(2pi/16)+cos(6pi/16)) */
/* 2*cos(6pi/16) */

#define DCT1 ((short) (1.414213562 * (double)(1 << 14) + .5)) /* 14-bit */
#define DCT2 ((short) (1.082392200 * (double)(1 << 14) + .5)) /* 14-bit */
#define DCT3 ((short) (2.613125925 * (double)(1 << 13) + .5)) /* 13-bit */
#define DCT4 ((short) (0.765366865 * (double)(1 << 15) + .5)) /* 15-bit */

FAME_ALIGNED short const _mmx_cos[] = {
  -DCT2, -DCT2, -DCT2, -DCT2,
   DCT1,  DCT1,  DCT1,  DCT1,
   DCT4,  DCT4,  DCT4,  DCT4,
   DCT3,  DCT3,  DCT3,  DCT3
};

FAME_ALIGNED short const _mmx_icos[] = {
  DCT2, DCT2, DCT2, DCT2,
  DCT1, DCT1, DCT1, DCT1,
  DCT3, DCT3, DCT3, DCT3,
  DCT4, DCT4, DCT4, DCT4
};
