/*
 * Value wrapper API
 *
 * Copyright (C) 2004-2006 Christian Hammond
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _GALAGO_VALUE_H_
#define _GALAGO_VALUE_H_

#include <libgalago/galago-object.h>

typedef struct _GalagoValue GalagoValue;

typedef enum
{
	GALAGO_VALUE_TYPE_UNKNOWN = 0,  /* Unknown type.            */
	GALAGO_VALUE_TYPE_CHAR,         /* Character.               */
	GALAGO_VALUE_TYPE_UCHAR,        /* Unsigned character.      */
	GALAGO_VALUE_TYPE_BOOLEAN,      /* Boolean.                 */
	GALAGO_VALUE_TYPE_SHORT,        /* Short integer.           */
	GALAGO_VALUE_TYPE_USHORT,       /* Unsigned short integer.  */
	GALAGO_VALUE_TYPE_INT,          /* Integer.                 */
	GALAGO_VALUE_TYPE_UINT,         /* Unsigned integer.        */
	GALAGO_VALUE_TYPE_LONG,         /* Long integer.            */
	GALAGO_VALUE_TYPE_ULONG,        /* Unsigned long integer.   */
	GALAGO_VALUE_TYPE_STRING,       /* String.                  */
	GALAGO_VALUE_TYPE_OBJECT,       /* Object pointer.          */
	GALAGO_VALUE_TYPE_POINTER,      /* Generic pointer.         */
	GALAGO_VALUE_TYPE_LIST,         /* A list of values.        */
	GALAGO_VALUE_TYPE_ARRAY         /* An array of values.      */

} GalagoType;

G_BEGIN_DECLS

/**************************************************************************/
/** Value API                                                             */
/**************************************************************************/

GalagoValue *galago_value_new(GalagoType type, const void *data, void *detail);
GalagoValue *galago_value_new_object(GType type, const GObject *obj);
GalagoValue *galago_value_new_list(GalagoType type, GList *list, void *detail);
GalagoValue *galago_value_new_array(GalagoType type, const void *array,
									gsize size, void *detail);
void galago_value_destroy(GalagoValue *value);

GalagoType galago_value_get_type(const GalagoValue *value);
GalagoType galago_value_get_subtype(const GalagoValue *value);
GType galago_value_get_gtype(const GalagoValue *value);

void galago_value_set_char(GalagoValue *value, char data);
void galago_value_set_uchar(GalagoValue *value, unsigned char data);
void galago_value_set_boolean(GalagoValue *value, gboolean data);
void galago_value_set_short(GalagoValue *value, short data);
void galago_value_set_ushort(GalagoValue *value, unsigned short data);
void galago_value_set_int(GalagoValue *value, int data);
void galago_value_set_uint(GalagoValue *value, unsigned int data);
void galago_value_set_long(GalagoValue *value, long data);
void galago_value_set_ulong(GalagoValue *value, unsigned long data);
void galago_value_set_string(GalagoValue *value, const char *data);
void galago_value_set_object(GalagoValue *value, void *data);
void galago_value_set_pointer(GalagoValue *value, void *data);
void galago_value_set_list(GalagoValue *value, GList *data);
void galago_value_set_array(GalagoValue *value, const void *data, gsize size);

char galago_value_get_char(const GalagoValue *value);
unsigned char galago_value_get_uchar(const GalagoValue *value);
gboolean galago_value_get_boolean(const GalagoValue *value);
short galago_value_get_short(const GalagoValue *value);
unsigned short galago_value_get_ushort(const GalagoValue *value);
int galago_value_get_int(const GalagoValue *value);
unsigned int galago_value_get_uint(const GalagoValue *value);
long galago_value_get_long(const GalagoValue *value);
unsigned long galago_value_get_ulong(const GalagoValue *value);
const char *galago_value_get_string(const GalagoValue *value);
void *galago_value_get_object(const GalagoValue *value);
void *galago_value_get_pointer(const GalagoValue *value);
GList *galago_value_get_list(const GalagoValue *value);
void galago_value_get_array(const GalagoValue *value,
							const void **ret_array, gsize *ret_size);

G_END_DECLS

#endif /* _GALAGO_VALUE_H_ */
