
#include "commonHelp.h"
/*============================================================================*/
/* コマンドヘルプ,man,musahi GUI 共通メッセージ管理                           */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* コマンドのタイトル                                                         */
/* コマンドヘルプの最初の行に表示                                             */
/*----------------------------------------------------------------------------*/
#define HELPT "数値範囲による置換"

/*----------------------------------------------------------------------------*/
/* パラメータ                                                                 */
/* コマンドヘルプの USAGE:として"キーワード XXXT"を表示 ex)-k キー項目名リスト*/
/* flagのオプションはコマンドヘルプのOPTIONS)として表示 ex)-z : 標準出力の圧縮*/
/*----------------------------------------------------------------------------*/
/*-f*/
#define FLDT "変換する数値項目リスト"
#define FLDC "ここで指定した項目の数値を-Rと-vで指定した数値範囲リストおよび置換文字列リストに従って置換する"
#define FLDF NULL

/*-R*/
#define LSTT "数値範囲リスト"
#define LSTC "置換対象となる数値範囲を指定する(1.1_2.5 : 1.1以上2.5未満)。"

/*-v*/
#define VALT "置換文字列リスト"
#define VALC "-Rで指定した数値範囲に対応する置換文字列を指定する。"

/*-O*/
#define OTHT "範囲外文字列"
#define OTHC "-Rで指定した数値範囲リストのいずれとも合致しない値を置換するときの文字列(指定がなければNULLとなる)。"

/*-F*/
#define FRPT "範囲外を項目の値として出力"
#define FRPC "-Rで指定した数値範囲リストのいずれとも合致しない値は、その項目の値のまま出力する。"

/*-r*/
#define REQT "-Rの範囲を'〜より大きく〜以下'として扱う"
#define REQC "このオプションを指定することによって、'1.1_2.5'は'1.1より大きく2.5以下'として扱う。"

/*-A*/
#define NEWT C_NEWT
#define NEWC C_NEWC

/*-i*/
#define INFT C_INFT
#define INFC C_INFC

/*-o*/
#define OTFT C_OTFT
#define OTFC C_OTFC

/*-z*/
#define ZIPT C_ZIPT
#define ZIPC C_ZIPC

/*-t*/
#define TXTT C_TXTT
#define TXTC C_TXTC

/*----------------------------------------------------------------------------*/
/* 要約                                                                       */
/* コマンドヘルプのSUMMARY:として表示する                                     */
/* HTMLヘルプやmanには、下のHELPDの上に結合する形で表示する                   */
/*----------------------------------------------------------------------------*/
#define HELPS "-fで指定した項目について、-Rの数値範囲条件と-vの置換文字列により、項目の値を置換する。"

/*----------------------------------------------------------------------------*/
/* 例                                                                         */
/*----------------------------------------------------------------------------*/
#define HELPE "\
xtchgnum -f 金額 -R MIN,5,10,MAX -v 大,中,小 -i dat.xt -o rsl.xt\n\
xtchgnum -f 金額 -R 0,5,10,20 -v 大,中,小 -O 範囲外 -i dat.xt -o rsl.xt\n\
"

/*----------------------------------------------------------------------------*/
/* 参照コマンド(必ずカンマで区切り、空白は用いない)                           */
/*----------------------------------------------------------------------------*/
#define HELPR "xtchgstr,xtsed"

/*----------------------------------------------------------------------------*/
/* 作者について                                                               */
/* コマンドヘルプには表示されない                                             */
/*----------------------------------------------------------------------------*/
#define HELPA C_HELPA

/*----------------------------------------------------------------------------*/
/* バグレポート                                                               */
/* ここを登録すればコマンドヘルプのBUG REPORT:に表示される。                  */
/* 登録がなければ(#define HELPB "")何も表示しない。                           */
/*----------------------------------------------------------------------------*/
#define HELPB C_HELPB

/*----------------------------------------------------------------------------*/
/* ホームページ                                                               */
/* ここを登録すればコマンドヘルプのINFORMATION:に表示される。                 */
/* 登録がなければ(#define HELPH "")何も表示しない。                           */
/*----------------------------------------------------------------------------*/
#define HELPH C_HELPH

