#!/usr/bin/env bash

################################################################################
# xtrfm version 1.0.1
# RFM
# 2003/07/22 Y.Hamuro ^쐬
# 2004/01/21 tops /bin/bash -> /usr/bin/env bash ɕύX(ĉwE)
# 2004/01/21 wvŃo[W\\悤ɕύX(1.0.1)
################################################################################

#===============================================================================
#wvbZ[W( -h^ꂽƂɕ\\ )
#-------------------------------------------------------------------------------
# -h^ꂽƂɕ\\B
# "cat >/dev/stderr <<EOR""EOF"̍s܂ł̃eLXĝ܂܉ʂɕ\\
# p@ɂāAȗ\\ȃp[^͊("[]")Ŋ邱ƁB
#===============================================================================
function help {
cat >/dev/stderr <<EOF
------------------------
xtrfm.sh version 1.0.1
------------------------
p@) xtrfm [-c ڋqIDږ] [-d tږ] [-D t] [-m zږ]
              [-p] [-R RecencỹNX] [-F FrequencỹNX]
              [-M MonetarỹNX] -i̓t@C -O o̓fBNg
  -c ڋqIDږ : ڋqIDږw肷(ڂ̎w\)
                    ȗ"ڋq"Ƃږ𗘗pB
  -d tږ   : ڋq̖Kږw肷B
                    ȗ"t"Ƃږ𗘗pB
  -D t     : RecencyvZ邽߂̊BYYYYMMDĎ`Ŏw肷B
                    RecencýAutv|uڋq̍ŏIKvŌvZ
                    ɂ`B
                    ȗ͖{̓tpB
  -m zږ   : ڋq̍wzږw肷B
                    ȗ"z"Ƃږ𗘗pB
  -p          : w肳ꂽԂŃf[^IɁARFM͂sB
                    ԂYYYYMMDD_YYYYMMDĎ`Ŏw肷B
                    ȗ͓̓t@CSẴf[^pRFM͂sB
  -R              : Recency̃NXɕ邩(ftHg5)
  -F              : Frequency̃NXɕ邩(ftHg5)
  -M              : Monetary̃NXɕ邩(ftHg5)
  -i ̓t@C : ChJ[hpłB
  -O o̓fBNg : ʂo͂fBNgB
                          w肵fBNg݂Ȃ΍쐬B
                          ȗ́AJgfBNg"outfiles"ɍ쐬B

p) xtrfm -i dat.xt -O rsl
EOF
exit 1
}

#===============================================================================
#p[^̃Zbg
# Ƃp[^́A̒lϐɃZbgAƂȂp[^́A
# ϐ"1"ZbgB
#-------------------------------------------------------------------------------
# getopts̈ɂ
#   ŏ̃R(:)́AsȃIvV͎ɁAoptϐ"?"ZbgB
#   ̂ƂɂÃP[X"\?)"ɈAhelps邱ƂɂȂB
#   ݒ肵p[^A"At@xbg+R"(ex."i:")ŗ^ƈƂ
#   p[^ƂĈARȂ̏ꍇ́ÂȂp[^ƂĈB
#   ex. "i:a:thv" -> "-i", "-a"͈Ƃp[^B
#                    "-t", "-h", "-v"͈ƂȂp[^B
#   OPTARGϐɃZbgB
#
# while & case ̏ɂ
#   while[v(whiledone܂ł̃ubN)񂲂ƂɁA[U͂
#   p[^Â`FbNAgetopts̈(LQ)ɊÂA
#   opt,OPTARGϐZbgB
#   optϐɂ́A[U͂p[^̃L[[hZbgA
#   OPTARGϐɂ́ÃL[[hƂȂA̒lZbgB
#   [Usȃp[^͂ꍇ́Aoptϐ"?"ZbgA
#   "\? )"̈ꕶsB
#
# caseƂ
#   "case $opt in ` case"́Aoptϐ̓eAu x )vx̒lƓs
#   R}hsBu x )v̌ɂ͕̃R}hLq\\ł邪A
#   Ō̃R}ȟ";;"(I[L)KvB
#===============================================================================
  while getopts ":c:d:D:m:p:R:F:M:i:O:h" opt; do
    case $opt in
      c  ) cFld=$OPTARG ;;
      d  ) dFld=$OPTARG ;;
      D  ) today=$OPTARG ;;
      m  ) mFld=$OPTARG ;;
      p  ) period=$OPTARG ;;
      R  ) bucketR=$OPTARG ;;
      F  ) bucketF=$OPTARG ;;
      M  ) bucketM=$OPTARG ;;
      i  ) inFile=$OPTARG ;;
      O  ) outPath=$OPTARG ;;
      h  ) help ;;
      \? ) echo xxxx; exit 0 ;help ;;
    esac
  done

#-------------------------------------------------------------------------------
# OPTINDPZB->̏ɂALp[^$nŎQ
# \\ƂȂB
#-------------------------------------------------------------------------------
  shift $(($OPTIND -1 ))

#-------------------------------------------------------------------------------
# p[^̃`FbN
#-------------------------------------------------------------------------------
  if [ "$cFld" = "" ]; then
     cFld="ڋq"
  fi
  if [ "$dFld" = "" ]; then
     dFld="t"
  fi
  if [ "$today" = "" ]; then
     today=`date +%Y%m%d`
  fi
  if [ "$mFld" = "" ]; then
     mFld="z"
  fi
  if [ "$period" = "" ]; then
     periodFrom="0"
     periodTo="99999999"
  else
     periodFrom=${period%_*}
     periodTo=${period#*_}
  fi
  if [ "$bucketR" = "" ]; then
    bucketR=5
  fi
  if [ "$bucketF" = "" ]; then
    bucketF=5
  fi
  if [ "$bucketM" = "" ]; then
    bucketM=5
  fi
  if [ "$inFile" = "" ]; then
     help; exit 1
  fi
  if [ "$outPath" = "" ]; then
     outPath="./outfiles"
  fi

#-------------------------------------------------------------------------------
# eO
#-------------------------------------------------------------------------------
# [Nt@C̃vtBbNX̐ݒ
# $$̓vZXԍ
wf=/tmp/xt##$$-xtrfm

#o̓fBNg݂ȂȂ쐬
  if [ ! -d $outPath ]; then
     mkdir -p $outPath
  fi

#-------------------------------------------------------------------------------
# C
#-------------------------------------------------------------------------------
# 1. ̓f[^𕹍A
# 2. Kvȍ(ڋq,t,z)𔲂A
# 3. f[^IA
# 4. ڋqʓʋzv߂B
xtcat -i "$inFile" |
xtsel -c "\$$dFld>$periodFrom && \$$dFld<$periodTo" |
xtcut -f $cFld,$dFld,$mFld |
xtagg -k $cFld,$dFld -f $mFld -c sum -o $wf-01

#XpxNX߂
xtcut -f $cFld -i $wf-01 |
xtcount -k $cFld -a X |
xtbucket -n $bucketF -f X:Fclass -o $wf-F

#zNX߂
xtcut -f $cFld,$mFld -i $wf-01 |
xtagg -k $cFld -f $mFld -c sum |
xtbucket -n $bucketM -f $mFld:Mclass -o $wf-M

#RecencyNX߂
xtsetchr -v "$today" -a today -i $wf-01 |
xtcut -f $cFld,$dFld,today |
xtagg -k $cFld -f $dFld -c max |
xtcal -c "day($today,\$$dFld)" -a Recency |
xtbucket -n $bucketR -f Recency:Rclass -o $wf-R

#O̃t@C
xtjoin -nN -k $cFld -m $wf-F -f Fclass -i $wf-R |
xtjoin -nN -k $cFld -m $wf-M -f Mclass |
xtcut -f $cFld,Rclass,Fclass,Mclass -o $outPath/dat.xt

#-------------------------------------------------------------------------------
# ㏈
#-------------------------------------------------------------------------------
# [Nt@C̍폜
  rm $wf-*

# I(Xe[^X͂O)
  exit 0
