//%2006////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2000, 2001, 2002 BMC Software; Hewlett-Packard Development
// Company, L.P.; IBM Corp.; The Open Group; Tivoli Systems.
// Copyright (c) 2003 BMC Software; Hewlett-Packard Development Company, L.P.;
// IBM Corp.; EMC Corporation, The Open Group.
// Copyright (c) 2004 BMC Software; Hewlett-Packard Development Company, L.P.;
// IBM Corp.; EMC Corporation; VERITAS Software Corporation; The Open Group.
// Copyright (c) 2005 Hewlett-Packard Development Company, L.P.; IBM Corp.;
// EMC Corporation; VERITAS Software Corporation; The Open Group.
// Copyright (c) 2006 Hewlett-Packard Development Company, L.P.; IBM Corp.;
// EMC Corporation; Symantec Corporation; The Open Group.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// 
// THE ABOVE COPYRIGHT NOTICE AND THIS PERMISSION NOTICE SHALL BE INCLUDED IN
// ALL COPIES OR SUBSTANTIAL PORTIONS OF THE SOFTWARE. THE SOFTWARE IS PROVIDED
// "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
// LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
// HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
// ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
//==============================================================================
//
//%/////////////////////////////////////////////////////////////////////////////

#ifndef Pegasus_ProviderClassList_h
#define Pegasus_ProviderClassList_h

#include <Pegasus/Common/Config.h>
#include <Pegasus/Common/CIMInstance.h>
#include <Pegasus/Common/CIMName.h>


PEGASUS_NAMESPACE_BEGIN

/**
    Entry for list of indication providers
 */
struct providerClassList
{
    CIMInstance provider;
    CIMInstance providerModule;
    Array <CIMName> classList;
   // Enabling Indications on Remote CMPI -V 5245
#ifdef PEGASUS_ENABLE_REMOTE_CMPI
    Boolean isRemoteNameSpace;
    String remoteInfo;
#endif

    providerClassList()
    {
    }

    providerClassList (const providerClassList & rh)
    :   provider (rh.provider),
        providerModule (rh.providerModule),
        classList (rh.classList)
#ifdef PEGASUS_ENABLE_REMOTE_CMPI
        ,
        isRemoteNameSpace (rh.isRemoteNameSpace),
        remoteInfo (rh.remoteInfo)
#endif
    {
    }

    providerClassList & operator= (const providerClassList & rh)
    {
        if (this != & rh)
        {
            provider = rh.provider;
            providerModule = rh.providerModule;
            classList = rh.classList;
#ifdef PEGASUS_ENABLE_REMOTE_CMPI
            isRemoteNameSpace = rh.isRemoteNameSpace;
            remoteInfo = rh.remoteInfo;
#endif
        }
        return * this;
    }
};

typedef struct providerClassList ProviderClassList;

PEGASUS_NAMESPACE_END

#endif  /* Pegasus_ProviderClassList_h */
