/*
 *  KANJI Code conversion routines.
 */

#ifndef PTEXENC_PTEXENC_H
#define PTEXENC_PTEXENC_H

#include <kpathsea/c-proto.h>
#include <kpathsea/types.h>

extern KPSEDLL char *ptexenc_version_string;

#define KANJI_OPTS "{jis|euc|sjis|utf8}"

/* get/set Kanji encode name as string */
extern KPSEDLL string     get_kanji_enc_string P1H(void);
extern KPSEDLL int        set_kanji_enc_string P2H(string file, string inter);
#define getkanjiencstring get_kanji_enc_string
#define setkanjiencstring set_kanji_enc_string

/* decide if internal Kanji encode is SJIS/UTF8 or not */
extern KPSEDLL boolean  is_internalSJIS P1H(void);
extern KPSEDLL boolean  is_internalUPTEX P1H(void);
#define isinternalSJIS  is_internalSJIS
#define isinternalUPTEX is_internalUPTEX

/* check char range */
extern KPSEDLL boolean ismultichr P3H(int length, int nth, int c);
#define iskanji1(c) ismultichr(2,1,c)
#define iskanji2(c) ismultichr(2,2,c)

/* internal (EUC/SJIS/UPTEX) from/to buffer (EUC/SJIS/UTF-8) code conversion */
extern KPSEDLL int multistrlen P3H(unsigned char *s, int len, int pos);
extern KPSEDLL long fromBUFF P3H(unsigned char *s, int len, int pos);
extern KPSEDLL long toBUFF P1H(long inter);

/* internal (EUC/SJIS/UPTEX) from/to DVI (JIS/UCS) code conversion */
extern KPSEDLL long fromDVI P1H(long dvi);
extern KPSEDLL long toDVI P1H(long inter);

/* JIS/EUC/SJIS/KUTN/UCS to internal (EUC/SJIS/UPTEX) code conversion */
/* (only for \euc primitive, etc.) */
extern KPSEDLL long fromJIS P1H(long jis);
extern KPSEDLL long fromEUC P1H(long euc);
extern KPSEDLL long fromSJIS P1H(long sjis);
extern KPSEDLL long fromKUTEN P1H(long kuten);
extern KPSEDLL long fromUCS P1H(long ucs);

/* fputs/putc with encoding conversion */
extern KPSEDLL int putc2 P2H(int c, FILE* fp);
extern KPSEDLL int fputs2 P2H(const char* s, FILE* fp);

/* input line with encoding conversion */
extern KPSEDLL int input_line2 P5H(FILE* fp, string buff, long pos,
                                   const long buffsize, int* lastchar);
#define inputline2(fp,buff,pos,size) (input_line2(fp,buff,(pos)+1,size,NULL)-1)

/* open/close through nkf */
extern KPSEDLL void nkf_disable P1H(void);
extern KPSEDLL FILE *nkf_open P2H(const char* path, const char* mode);
extern KPSEDLL int nkf_close P1H(FILE* fp);

#endif /* PTEXENC_PTEXENC_H */
